/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.data;

import android.content.Context;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.data.SyncUserDataResult;
import org.infobip.mobile.messaging.mobile.data.SyncUserDataTask;
import org.infobip.mobile.messaging.mobile.data.UserDataMapper;
import org.infobip.mobile.messaging.mobile.synchronizer.RetryableSynchronizer;
import org.infobip.mobile.messaging.mobile.synchronizer.Task;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.util.PreferenceHelper;

public class UserDataSynchronizer
extends RetryableSynchronizer {
    private final Broadcaster broadcaster;
    private final MobileMessagingCore mobileMessagingCore;
    private UserData userDataToReport;

    public UserDataSynchronizer(Context context, MobileMessagingCore mobileMessagingCore, Executor executor, Broadcaster broadcaster) {
        super(context, mobileMessagingCore.getStats(), executor);
        this.broadcaster = broadcaster;
        this.mobileMessagingCore = mobileMessagingCore;
    }

    @Override
    public void synchronize(final MobileMessaging.ResultListener listener, Object object) {
        if (object == null || !(object instanceof UserData)) {
            return;
        }
        this.userDataToReport = (UserData)object;
        if (this.mobileMessagingCore.shouldSaveUserData()) {
            PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA);
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA, this.userDataToReport.toString());
        }
        new SyncUserDataTask(this.context, this.userDataToReport){

            protected void onPostExecute(SyncUserDataResult syncUserDataResult) {
                if (syncUserDataResult.hasError()) {
                    MobileMessagingLogger.e("MobileMessaging API returned error (user data)!");
                    UserDataSynchronizer.this.stats.reportError(MobileMessagingStatsError.USER_DATA_SYNC_ERROR);
                    if (syncUserDataResult.hasInvalidParameterError()) {
                        UserDataSynchronizer.this.mobileMessagingCore.setUserDataReportedWithError();
                        if (listener != null) {
                            listener.onError(MobileMessagingError.createFrom(syncUserDataResult.getError()));
                        }
                    } else {
                        MobileMessagingLogger.v("User data synchronization will be postponed to a later time due to communication error");
                        if (listener != null) {
                            UserDataSynchronizer.this.performCallbackResult(listener, syncUserDataResult);
                        } else {
                            UserDataSynchronizer.this.retry(syncUserDataResult);
                        }
                    }
                    UserDataSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(syncUserDataResult.getError()));
                    return;
                }
                UserData userData = UserDataMapper.fromUserDataReport(UserDataSynchronizer.this.userDataToReport.getExternalUserId(), syncUserDataResult.getPredefined(), syncUserDataResult.getCustom());
                UserDataSynchronizer.this.mobileMessagingCore.setUserDataReported(userData);
                UserDataSynchronizer.this.broadcaster.userDataReported(userData);
                if (listener != null) {
                    listener.onResult(userData);
                }
            }

            protected void onCancelled(SyncUserDataResult syncUserDataResult) {
                MobileMessagingLogger.e("Error reporting user data!");
                UserDataSynchronizer.this.stats.reportError(MobileMessagingStatsError.USER_DATA_SYNC_ERROR);
                UserDataSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(syncUserDataResult.getError()));
                MobileMessagingLogger.v("User data synchronization will be postponed to a later time due to communication error");
                if (listener != null) {
                    UserDataSynchronizer.this.performCallbackResult(listener, syncUserDataResult);
                } else {
                    UserDataSynchronizer.this.retry(syncUserDataResult);
                }
            }
        }.executeOnExecutor(this.executor, new Void[0]);
    }

    private void performCallbackResult(MobileMessaging.ResultListener listener, SyncUserDataResult result) {
        if (this.mobileMessagingCore.shouldSaveUserData()) {
            listener.onResult(UserData.merge(this.mobileMessagingCore.getUserData(), this.userDataToReport));
        } else {
            listener.onError(MobileMessagingError.createFrom(result.getError()));
        }
    }

    @Override
    public Task getTask() {
        return Task.SYNC_USER_DATA;
    }
}

