/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import org.infobip.mobile.messaging.MobileMessagingCore;

public class MobileMessagingConnectivityReceiver
extends BroadcastReceiver {
    private MobileMessagingCore mobileMessagingCore;

    public MobileMessagingConnectivityReceiver() {
    }

    @VisibleForTesting
    public MobileMessagingConnectivityReceiver(MobileMessagingCore mobileMessagingCore) {
        this.mobileMessagingCore = mobileMessagingCore;
    }

    public void onReceive(Context context, Intent intent) {
        if (intent == null || !"android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            return;
        }
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") == 0) {
            networkInfo = manager.getActiveNetworkInfo();
        }
        Boolean internetConnectedBefore = this.mobileMessagingCore(context).getInternetConnected();
        boolean internetConnected = networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED || intent.hasExtra("noConnectivity") && !intent.getBooleanExtra("noConnectivity", false);
        this.mobileMessagingCore(context).setInternetConnected(internetConnected);
        if (null != internetConnectedBefore && !internetConnectedBefore.booleanValue() && internetConnected) {
            this.mobileMessagingCore(context).retrySync();
        }
    }

    private MobileMessagingCore mobileMessagingCore(Context context) {
        if (this.mobileMessagingCore == null) {
            this.mobileMessagingCore = MobileMessagingCore.getInstance(context);
        }
        return this.mobileMessagingCore;
    }
}

