/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.dal.bundle;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.dal.bundle.BundleMapper;

public class MessageBundleMapper
extends BundleMapper {
    private static final String BUNDLED_MESSAGE_TAG = MessageBundleMapper.class.getName() + ".message";
    private static final JsonSerializer serializer = new JsonSerializer(false);

    @Nullable
    public static Message messageFromBundle(@NonNull Bundle bundle) {
        return MessageBundleMapper.objectFromBundle(bundle, BUNDLED_MESSAGE_TAG, Message.class);
    }

    @NonNull
    public static List<Message> messagesFromBundles(@NonNull ArrayList<Bundle> bundles) {
        return MessageBundleMapper.objectsFromBundles(bundles, BUNDLED_MESSAGE_TAG, Message.class);
    }

    @NonNull
    public static Bundle messageToBundle(@NonNull Message message) {
        return MessageBundleMapper.objectToBundle(message, BUNDLED_MESSAGE_TAG);
    }

    @NonNull
    public static ArrayList<Bundle> messagesToBundles(@NonNull List<Message> messages) {
        return MessageBundleMapper.objectsToBundles(messages, BUNDLED_MESSAGE_TAG);
    }
}

