/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.notification.NotificationHandler;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.storage.MessageStoreWrapper;
import org.infobip.mobile.messaging.util.StringUtils;

public class MobileMessageHandler {
    private Broadcaster broadcaster;
    private NotificationHandler notificationHandler;
    private MessageStoreWrapper messageStoreWrapper;
    private MobileMessagingCore mobileMessagingCore;

    public MobileMessageHandler(MobileMessagingCore mobileMessagingCore, Broadcaster broadcaster, NotificationHandler notificationHandler, MessageStoreWrapper messageStoreWrapper) {
        this.broadcaster = broadcaster;
        this.notificationHandler = notificationHandler;
        this.messageStoreWrapper = messageStoreWrapper;
        this.mobileMessagingCore = mobileMessagingCore;
    }

    public void handleMessage(Message message) {
        if (!this.mobileMessagingCore.isPushRegistrationEnabled()) {
            return;
        }
        if (StringUtils.isBlank(message.getMessageId())) {
            MobileMessagingLogger.w("Ignoring message without messageId");
            return;
        }
        message.setReceivedTimestamp(Time.now());
        this.sendDeliveryReport(message);
        if (!MobileMessagingCore.hasGeo(message)) {
            this.saveMessage(message);
            this.broadcaster.messageReceived(message);
        } else {
            this.broadcaster.geoMessageReceived(message);
        }
        MobileMessagingLogger.d("Message is silent: " + message.isSilent());
        if (!message.isSilent()) {
            this.notificationHandler.displayNotification(message);
        }
    }

    private void saveMessage(Message message) {
        MobileMessagingLogger.d("Saving message: " + message.getMessageId());
        try {
            this.messageStoreWrapper.upsert(message);
        }
        catch (Exception e) {
            MobileMessagingLogger.e(InternalSdkError.ERROR_SAVING_MESSAGE.get(), e);
        }
    }

    private void sendDeliveryReport(Message message) {
        if (StringUtils.isBlank(message.getMessageId())) {
            MobileMessagingLogger.e("No ID received for message: " + message);
            return;
        }
        MobileMessagingLogger.d("Sending DR: " + message.getMessageId());
        this.mobileMessagingCore.setMessagesDelivered(message.getMessageId());
    }
}

