/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.dal.bundle.FCMMessageMapper;
import org.infobip.mobile.messaging.gcm.MobileMessageHandler;
import org.infobip.mobile.messaging.gcm.RegistrationTokenHandler;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.notification.NotificationHandler;
import org.infobip.mobile.messaging.platform.AndroidBroadcaster;

public class MobileMessagingGcmIntentService
extends IntentService {
    public static final String ACTION_GCM_MESSAGE_RECEIVE = "com.google.android.c2dm.intent.RECEIVE";
    public static final String ACTION_ACQUIRE_INSTANCE_ID = "org.infobip.mobile.messaging.gcm.INSTANCE_ID";
    public static final String ACTION_TOKEN_CLEANUP = "org.infobip.mobile.messaging.gcm.token.cleanup";
    public static final String EXTRA_GCM_SENDER_ID = "org.infobip.mobile.messaging.gcm.GCM_SENDER_ID";
    private final RegistrationTokenHandler registrationTokenHandler = new RegistrationTokenHandler();
    private MobileMessageHandler mobileMessageHandler;

    public MobileMessagingGcmIntentService() {
        super("MobileMessaging-" + MobileMessagingGcmIntentService.class.getSimpleName());
    }

    public void onHandleIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        switch (action) {
            case "com.google.android.c2dm.intent.RECEIVE": {
                Message message = FCMMessageMapper.fromCloudBundle(intent.getExtras());
                MobileMessagingLogger.v("RECEIVED MESSAGE FROM FCM", message);
                this.mobileMessageHandler().handleMessage(message);
                break;
            }
            case "org.infobip.mobile.messaging.gcm.token.cleanup": {
                this.registrationTokenHandler.handleRegistrationTokenCleanup((Context)this, intent.getStringExtra(EXTRA_GCM_SENDER_ID));
                break;
            }
            case "org.infobip.mobile.messaging.gcm.INSTANCE_ID": {
                this.registrationTokenHandler.handleRegistrationTokenUpdate((Context)this);
            }
        }
    }

    private MobileMessageHandler mobileMessageHandler() {
        if (this.mobileMessageHandler == null) {
            NotificationHandler notificationHandler = MobileMessagingCore.resolveNotificationHandler((Context)this);
            MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance((Context)this);
            this.mobileMessageHandler = new MobileMessageHandler(mobileMessagingCore, new AndroidBroadcaster((Context)this), notificationHandler, mobileMessagingCore.getMessageStoreWrapper());
        }
        return this.mobileMessageHandler;
    }
}

