/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile;

import android.util.Log;
import java.io.Serializable;
import java.util.Locale;
import org.infobip.mobile.messaging.api.support.ApiIOException;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendBaseException;

public class MobileMessagingError
implements Serializable {
    private String code;
    private String message;
    private Type type;
    private Throwable tr;

    public static MobileMessagingError createFrom(Throwable e) {
        if (e instanceof BackendBaseException) {
            return ((BackendBaseException)e).getError();
        }
        if (e instanceof ApiIOException) {
            return new MobileMessagingError((ApiIOException)e);
        }
        return new MobileMessagingError(e);
    }

    public MobileMessagingError(String code, String message) {
        this(code, message, Type.SDK_ERROR, new Throwable(message));
    }

    private MobileMessagingError(ApiIOException apiException) {
        this(apiException.getCode(), apiException.getMessage(), Type.SERVER_ERROR, new Throwable(apiException.getMessage()));
    }

    private MobileMessagingError(Throwable e) {
        this("-10", e != null ? e.getMessage() : "Something went wrong", Type.UNKNOWN_ERROR, new Throwable(e != null ? e.getMessage() : "Something went wrong"));
    }

    private MobileMessagingError(String code, String message, Type type, Throwable tr) {
        this.code = code;
        this.message = message;
        this.type = type;
        this.tr = tr;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public String getStacktrace() {
        return this.tr != null ? Log.getStackTraceString((Throwable)this.tr) : null;
    }

    public String toString() {
        return String.format(Locale.getDefault(), "%s, %s, %s", this.type.name(), this.code, this.message);
    }

    public static enum Type {
        UNKNOWN_ERROR,
        SDK_ERROR,
        SERVER_ERROR;

    }
}

