/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.common;

import android.annotation.SuppressLint;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.api.support.ApiIOException;
import org.infobip.mobile.messaging.api.support.http.client.DefaultApiClient;
import org.infobip.mobile.messaging.mobile.common.ResultWrapper;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendCommunicationException;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendInvalidParameterException;

public abstract class MAsyncTask<IN, OUT> {
    @SuppressLint(value={"StaticFieldLeak"})
    private AsyncTask<IN, Void, ResultWrapper<IN, OUT>> asyncTask = new AsyncTask<IN, Void, ResultWrapper<IN, OUT>>(){

        protected void onPreExecute() {
            MAsyncTask.this.before();
        }

        protected ResultWrapper<IN, OUT> doInBackground(IN[] ins) {
            try {
                return new ResultWrapper(MAsyncTask.this.run(ins));
            }
            catch (Throwable error) {
                return new ResultWrapper(ins, error);
            }
        }

        protected void onPostExecute(ResultWrapper<IN, OUT> resultWrapper) {
            if (resultWrapper.error == null) {
                MAsyncTask.this.after(resultWrapper.result);
                return;
            }
            if (MAsyncTask.isInvalidParameterError(resultWrapper.error)) {
                BackendInvalidParameterException error = new BackendInvalidParameterException(resultWrapper.error.getMessage(), (ApiIOException)resultWrapper.error);
                MAsyncTask.this.error(error);
                MAsyncTask.this.error(resultWrapper.inputs, error);
                return;
            }
            if (MAsyncTask.isBackendError(resultWrapper.error)) {
                BackendCommunicationException error = new BackendCommunicationException(resultWrapper.error.getMessage(), (ApiIOException)resultWrapper.error);
                MAsyncTask.this.error(error);
                MAsyncTask.this.error(resultWrapper.inputs, error);
                return;
            }
            MAsyncTask.this.error(resultWrapper.error);
            MAsyncTask.this.error(resultWrapper.inputs, resultWrapper.error);
        }
    };

    public void before() {
    }

    public abstract OUT run(IN[] var1);

    public void after(OUT out) {
    }

    public void error(Throwable error) {
    }

    public void error(IN[] ins, Throwable error) {
    }

    public void execute(IN ... ins) {
        this.asyncTask.execute((Object[])ins);
    }

    public void execute(Executor executor, IN ... ins) {
        this.asyncTask.executeOnExecutor(executor, (Object[])ins);
    }

    private static boolean isBackendError(@NonNull Throwable error) {
        if (!(error instanceof ApiIOException)) {
            return false;
        }
        String errorCode = ((ApiIOException)error).getCode();
        return DefaultApiClient.ErrorCode.UNKNOWN_API_BACKEND_ERROR.getValue().equals(errorCode);
    }

    private static boolean isInvalidParameterError(@NonNull Throwable error) {
        if (!(error instanceof ApiIOException)) {
            return false;
        }
        String code = ((ApiIOException)error).getCode();
        return "5".equals(code) || "9".equals(code);
    }
}

