/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.data;

import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.api.data.MobileApiData;
import org.infobip.mobile.messaging.api.data.UserDataReport;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.common.MRetryPolicy;
import org.infobip.mobile.messaging.mobile.common.MRetryableTask;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendInvalidParameterException;
import org.infobip.mobile.messaging.mobile.data.UserDataMapper;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.util.StringUtils;

public class UserDataReporter {
    private final Executor executor;
    private final Broadcaster broadcaster;
    private final MobileMessagingCore mobileMessagingCore;
    private final MRetryPolicy retryPolicy;
    private final MRetryPolicy noRetryPolicy;
    private final MobileMessagingStats stats;
    private final MobileApiData mobileApiData;

    public UserDataReporter(MobileMessagingCore mobileMessagingCore, Executor executor, Broadcaster broadcaster, MRetryPolicy retryPolicy, MobileMessagingStats stats, MobileApiData mobileApiData) {
        this.executor = executor;
        this.broadcaster = broadcaster;
        this.mobileMessagingCore = mobileMessagingCore;
        this.stats = stats;
        this.mobileApiData = mobileApiData;
        this.retryPolicy = retryPolicy;
        this.noRetryPolicy = new MRetryPolicy.Builder().withMaxRetries(0).build();
    }

    public void sync(final MobileMessaging.ResultListener listener, final UserData userData) {
        if (userData == null) {
            return;
        }
        this.mobileMessagingCore.saveUnreportedUserData(userData);
        new MRetryableTask<UserData, UserData>(){

            public UserData run(UserData[] userData2) {
                if (StringUtils.isBlank(UserDataReporter.this.mobileMessagingCore.getPushRegistrationId())) {
                    MobileMessagingLogger.w("Can't report system data without valid registration");
                    throw InternalSdkError.NO_VALID_REGISTRATION.getException();
                }
                UserDataReport request = UserDataMapper.toUserDataReport(userData2[0].getPredefinedUserData(), userData2[0].getCustomUserData());
                MobileMessagingLogger.v("USER DATA >>>", request);
                UserDataReport response = UserDataReporter.this.mobileApiData.reportUserData(userData2[0].getExternalUserId(), request);
                MobileMessagingLogger.v("USER DATA <<<", response);
                return UserDataMapper.fromUserDataReport(userData2[0].getExternalUserId(), response.getPredefinedUserData(), response.getCustomUserData());
            }

            @Override
            public void after(UserData userData2) {
                UserDataReporter.this.mobileMessagingCore.setUserDataReported(userData2);
                UserDataReporter.this.broadcaster.userDataReported(userData2);
                if (listener != null) {
                    listener.onResult(userData2);
                }
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.e("MobileMessaging API returned error (user data)! ", error);
                UserDataReporter.this.mobileMessagingCore.setLastHttpException(error);
                UserDataReporter.this.stats.reportError(MobileMessagingStatsError.USER_DATA_SYNC_ERROR);
                if (error instanceof BackendInvalidParameterException) {
                    UserDataReporter.this.mobileMessagingCore.setUserDataReportedWithError();
                    if (listener != null) {
                        listener.onError(MobileMessagingError.createFrom(error));
                    }
                } else {
                    MobileMessagingLogger.v("User data synchronization will be postponed to a later time due to communication error");
                    if (listener != null) {
                        listener.onResult(UserData.merge(UserDataReporter.this.mobileMessagingCore.getUserData(), userData));
                    }
                }
                UserDataReporter.this.broadcaster.error(MobileMessagingError.createFrom(error));
            }
        }.retryWith(this.retryPolicy(listener)).execute(this.executor, (IN[])new UserData[]{userData});
    }

    private MRetryPolicy retryPolicy(MobileMessaging.ResultListener listener) {
        return listener == null && this.mobileMessagingCore.shouldSaveUserData() ? this.retryPolicy : this.noRetryPolicy;
    }
}

