/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.platform;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import java.io.Serializable;
import java.util.List;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.LocalEvent;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.dal.bundle.MessageBundleMapper;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.platform.Broadcaster;

public class AndroidBroadcaster
implements Broadcaster {
    private final Context context;

    public AndroidBroadcaster(@NonNull Context context) {
        this.context = context;
    }

    @Override
    public void messageReceived(@NonNull Message message) {
        Intent messageReceived = this.prepareIntent(Event.MESSAGE_RECEIVED);
        messageReceived.putExtras(MessageBundleMapper.messageToBundle(message));
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(messageReceived);
        this.context.sendBroadcast(messageReceived);
    }

    @Override
    public void geoMessageReceived(Message message) {
        Intent messageReceived = this.prepareIntent(LocalEvent.GEO_MESSAGE_RECEIVED.getKey());
        messageReceived.putExtras(MessageBundleMapper.messageToBundle(message));
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(messageReceived);
        this.context.sendBroadcast(messageReceived);
    }

    @Override
    public void notificationTapped(Message message) {
        Intent notificationTapped = this.prepareIntent(Event.NOTIFICATION_TAPPED);
        notificationTapped.putExtras(MessageBundleMapper.messageToBundle(message));
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(notificationTapped);
        this.context.sendBroadcast(notificationTapped);
    }

    @Override
    public void error(@NonNull MobileMessagingError error) {
        Intent reportingError = this.prepareIntent(Event.API_COMMUNICATION_ERROR);
        reportingError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)error);
        this.context.sendBroadcast(reportingError);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(reportingError);
    }

    @Override
    public void registrationAcquired(String cloudToken) {
        Intent registrationComplete = this.prepareIntent(Event.REGISTRATION_ACQUIRED);
        registrationComplete.putExtra("org.infobip.mobile.messaging.gcm.token", cloudToken);
        this.context.sendBroadcast(registrationComplete);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(registrationComplete);
    }

    @Override
    public void registrationCreated(String cloudToken, String pushRegistrationId) {
        Intent registrationCreated = this.prepareIntent(Event.REGISTRATION_CREATED);
        registrationCreated.putExtra("org.infobip.mobile.messaging.gcm.token", cloudToken);
        registrationCreated.putExtra("org.infobip.mobile.messaging.infobip.token", pushRegistrationId);
        this.context.sendBroadcast(registrationCreated);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(registrationCreated);
    }

    @Override
    public void registrationEnabled(String cloudToken, String deviceInstanceId, Boolean registrationEnabled) {
        Intent registrationUpdated = this.prepareIntent(Event.PUSH_REGISTRATION_ENABLED);
        registrationUpdated.putExtra("org.infobip.mobile.messaging.gcm.token", cloudToken);
        registrationUpdated.putExtra("org.infobip.mobile.messaging.infobip.token", deviceInstanceId);
        registrationUpdated.putExtra("org.infobip.mobile.messaging.push.registration.enabled", (Serializable)registrationEnabled);
        this.context.sendBroadcast(registrationUpdated);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(registrationUpdated);
    }

    @Override
    public void deliveryReported(String ... messageIds) {
        if (messageIds.length == 0) {
            return;
        }
        Intent deliveryReportsSent = this.prepareIntent(Event.DELIVERY_REPORTS_SENT);
        Bundle extras = new Bundle();
        extras.putStringArray("org.infobip.mobile.messaging.message.ids", messageIds);
        deliveryReportsSent.putExtras(extras);
        this.context.sendBroadcast(deliveryReportsSent);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(deliveryReportsSent);
    }

    @Override
    public void seenStatusReported(String ... messageIds) {
        if (messageIds.length == 0) {
            return;
        }
        Intent seenReportsSent = this.prepareIntent(Event.SEEN_REPORTS_SENT);
        Bundle extras = new Bundle();
        extras.putStringArray("org.infobip.mobile.messaging.message.ids", messageIds);
        seenReportsSent.putExtras(extras);
        this.context.sendBroadcast(seenReportsSent);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(seenReportsSent);
    }

    @Override
    public void messagesSent(List<Message> messages) {
        Intent messagesSent = this.prepareIntent(Event.MESSAGES_SENT);
        messagesSent.putParcelableArrayListExtra("org.infobip.mobile.messaging.messages", MessageBundleMapper.messagesToBundles(messages));
        this.context.sendBroadcast(messagesSent);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(messagesSent);
    }

    @Override
    public void userDataReported(UserData userData) {
        Intent userDataReported = this.prepareIntent(Event.USER_DATA_REPORTED);
        userDataReported.putExtra("org.infobip.mobile.messaging.userdata", userData.toString());
        this.context.sendBroadcast(userDataReported);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(userDataReported);
    }

    @Override
    public void systemDataReported(SystemData systemData) {
        Intent dataReported = this.prepareIntent(Event.SYSTEM_DATA_REPORTED);
        dataReported.putExtra("org.infobip.mobile.messaging.systemdata", systemData.toString());
        this.context.sendBroadcast(dataReported);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(dataReported);
    }

    private Intent prepareIntent(Event event) {
        return this.prepareIntent(event.getKey());
    }

    private Intent prepareIntent(String event) {
        return new Intent(event).setPackage(this.context.getPackageName());
    }
}

