/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import java.util.List;
import org.infobip.mobile.messaging.ApplicationCodeProvider;
import org.infobip.mobile.messaging.Installation;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.SuccessPending;
import org.infobip.mobile.messaging.User;
import org.infobip.mobile.messaging.UserAttributes;
import org.infobip.mobile.messaging.UserIdentity;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.Result;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.StringUtils;

@TargetApi(value=11)
public abstract class MobileMessaging {
    public static synchronized MobileMessaging getInstance(Context context) {
        return MobileMessagingCore.getInstance(context);
    }

    public abstract void setMessagesDelivered(String ... var1);

    public abstract void setMessagesSeen(String ... var1);

    public abstract MessageStore getMessageStore();

    public abstract void saveInstallation(Installation var1);

    public abstract void saveInstallation(Installation var1, ResultListener<Installation> var2);

    public abstract void fetchInstallation(ResultListener<Installation> var1);

    public abstract Installation getInstallation();

    public abstract void setInstallationAsPrimary(String var1, boolean var2, ResultListener<List<Installation>> var3);

    public abstract void setInstallationAsPrimary(String var1, boolean var2);

    public abstract void saveUser(User var1);

    public abstract void saveUser(User var1, ResultListener<User> var2);

    public abstract void fetchUser(@NonNull ResultListener<User> var1);

    @Nullable
    public abstract User getUser();

    public abstract void personalize(@NonNull UserIdentity var1, @Nullable UserAttributes var2);

    public abstract void personalize(@NonNull UserIdentity var1, @Nullable UserAttributes var2, ResultListener<User> var3);

    public abstract void personalize(@NonNull UserIdentity var1, @Nullable UserAttributes var2, boolean var3);

    public abstract void personalize(@NonNull UserIdentity var1, @Nullable UserAttributes var2, boolean var3, ResultListener<User> var4);

    public abstract void depersonalize();

    public abstract void depersonalize(ResultListener<SuccessPending> var1);

    public abstract void depersonalizeInstallation(String var1, ResultListener<List<Installation>> var2);

    public abstract void sendMessages(Message ... var1);

    public abstract void sendMessages(ResultListener<Message[]> var1, Message ... var2);

    public abstract void cleanup();

    public static final class Builder {
        private final Application application;
        private String senderId = (String)MobileMessagingProperty.SENDER_ID.getDefaultValue();
        private String applicationCode = (String)MobileMessagingProperty.APPLICATION_CODE.getDefaultValue();
        private String apiUri = (String)MobileMessagingProperty.API_URI.getDefaultValue();
        private NotificationSettings notificationSettings = null;
        private boolean reportCarrierInfo = true;
        private boolean reportSystemInfo = true;
        private boolean geofencingActivated = false;
        private boolean doMarkSeenOnNotificationTap = true;
        private boolean shouldSaveUserData = true;
        private boolean storeAppCodeOnDisk = true;
        private ApplicationCodeProvider applicationCodeProvider = null;
        private Class<? extends MessageStore> messageStoreClass = (Class)MobileMessagingProperty.MESSAGE_STORE_CLASS.getDefaultValue();

        public Builder(Application application) {
            if (null == application) {
                throw new IllegalArgumentException("application object is mandatory!");
            }
            this.application = application;
            this.loadDefaultApiUri((Context)application);
            this.loadGcmSenderId((Context)application);
            this.loadApplicationCode((Context)application);
            this.loadNotificationSettings((Context)application);
        }

        private void loadNotificationSettings(Context context) {
            boolean displayNotificationEnabled = (Boolean)MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED.getDefaultValue();
            if (!displayNotificationEnabled) {
                return;
            }
            this.notificationSettings = new NotificationSettings.Builder(context).build();
        }

        private void loadDefaultApiUri(Context context) {
            String apiUri;
            int resource = ResourceLoader.loadResourceByName(context, "string", "infobip_api_uri");
            if (resource > 0 && StringUtils.isNotBlank(apiUri = context.getResources().getString(resource))) {
                this.apiUri = apiUri;
            }
        }

        private void loadGcmSenderId(Context context) {
            String senderId;
            String senderId2;
            int googleServicesResource = ResourceLoader.loadResourceByName(context, "string", "gcm_defaultSenderId");
            if (googleServicesResource > 0 && StringUtils.isNotBlank(senderId2 = context.getResources().getString(googleServicesResource))) {
                this.senderId = senderId2;
                return;
            }
            int ibResource = ResourceLoader.loadResourceByName(context, "string", "google_app_id");
            if (ibResource > 0 && StringUtils.isNotBlank(senderId = context.getResources().getString(ibResource))) {
                this.senderId = senderId;
            }
        }

        private void loadApplicationCode(Context context) {
            String applicationCode;
            int resource = ResourceLoader.loadResourceByName(context, "string", "infobip_application_code");
            if (resource > 0 && StringUtils.isNotBlank(applicationCode = context.getResources().getString(resource))) {
                this.applicationCode = applicationCode;
            }
        }

        private void validateWithParam(Object o) {
            if (null != o) {
                return;
            }
            throw new IllegalArgumentException("Can't use 'with' method with null argument!");
        }

        private void validateApplicationCodeAvailability() {
            if (this.applicationCode != null && this.storeAppCodeOnDisk) {
                return;
            }
            if (this.applicationCodeProvider != null && !this.storeAppCodeOnDisk) {
                return;
            }
            throw new IllegalArgumentException("Application code is not provided to the library, make sure it is available in resources, builder or via app code provider");
        }

        public Builder withSenderId(String senderId) {
            this.validateWithParam(senderId);
            this.senderId = senderId;
            return this;
        }

        public Builder withApplicationCode(String applicationCode) {
            this.validateWithParam(applicationCode);
            this.storeAppCodeOnDisk = true;
            this.applicationCode = applicationCode;
            return this;
        }

        public Builder withoutStoringApplicationCode(ApplicationCodeProvider applicationCodeProvider) {
            Exception exception = null;
            try {
                this.application.getClassLoader().loadClass(applicationCodeProvider.getClass().getCanonicalName());
            }
            catch (ClassNotFoundException | NullPointerException e) {
                exception = e;
            }
            if (exception != null || applicationCodeProvider instanceof Activity) {
                throw new IllegalArgumentException("Application code provider should be implemented in a separate class file that implements ApplicationCodeProvider!");
            }
            this.validateWithParam(applicationCodeProvider);
            this.storeAppCodeOnDisk = false;
            this.applicationCodeProvider = applicationCodeProvider;
            return this;
        }

        public Builder withApiUri(String apiUri) {
            this.validateWithParam(apiUri);
            this.apiUri = apiUri;
            return this;
        }

        public Builder withDisplayNotification(NotificationSettings notificationSettings) {
            this.validateWithParam(notificationSettings);
            this.notificationSettings = notificationSettings;
            return this;
        }

        public Builder withoutDisplayNotification() {
            this.notificationSettings = null;
            return this;
        }

        public Builder withMessageStore(Class<? extends MessageStore> messageStoreClass) {
            this.validateWithParam(messageStoreClass);
            this.messageStoreClass = messageStoreClass;
            return this;
        }

        public Builder withoutMessageStore() {
            this.messageStoreClass = null;
            return this;
        }

        public Builder withoutCarrierInfo() {
            this.reportCarrierInfo = false;
            return this;
        }

        public Builder withoutSystemInfo() {
            this.reportSystemInfo = false;
            return this;
        }

        @RequiresPermission(value="android.permission.READ_PHONE_STATE")
        public Builder withMobileNetworkInfoOnAllDevices() {
            return this;
        }

        public Builder withoutMarkingSeenOnNotificationTap() {
            this.doMarkSeenOnNotificationTap = false;
            return this;
        }

        public Builder withoutStoringUserData() {
            this.shouldSaveUserData = false;
            return this;
        }

        public MobileMessaging build() {
            return this.build(null);
        }

        public MobileMessaging build(@Nullable InitListener initListener) {
            this.validateApplicationCodeAvailability();
            MobileMessagingCore.setApiUri((Context)this.application, this.apiUri);
            MobileMessagingCore.setSenderId((Context)this.application, this.senderId);
            MobileMessagingCore.setMessageStoreClass((Context)this.application, this.messageStoreClass);
            MobileMessagingCore.setReportCarrierInfo((Context)this.application, this.reportCarrierInfo);
            MobileMessagingCore.setReportSystemInfo((Context)this.application, this.reportSystemInfo);
            MobileMessagingCore.setDoMarkSeenOnNotificationTap((Context)this.application, this.doMarkSeenOnNotificationTap);
            MobileMessagingCore.setShouldSaveUserData((Context)this.application, this.shouldSaveUserData);
            MobileMessagingCore.setShouldSaveAppCode((Context)this.application, this.storeAppCodeOnDisk);
            MobileMessagingCore.Builder mobileMessagingCoreBuilder = new MobileMessagingCore.Builder(this.application).withDisplayNotification(this.notificationSettings);
            if (this.storeAppCodeOnDisk) {
                mobileMessagingCoreBuilder.withApplicationCode(this.applicationCode);
            } else if (this.applicationCodeProvider != null) {
                mobileMessagingCoreBuilder.withApplicationCode(this.applicationCodeProvider);
            }
            return mobileMessagingCoreBuilder.build(initListener);
        }
    }

    public static interface InitListener {
        public void onSuccess();

        public void onError(InternalSdkError var1, @Nullable Integer var2);
    }

    public static abstract class ResultListener<T> {
        public abstract void onResult(Result<T, MobileMessagingError> var1);
    }
}

