/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.infobip.mobile.messaging.CustomAttributeHolder;
import org.infobip.mobile.messaging.CustomAttributeValue;
import org.infobip.mobile.messaging.util.DateTimeUtil;

public class UserAttributes
extends CustomAttributeHolder {
    String firstName;
    String lastName;
    String middleName;
    Gender gender;
    String birthday;
    Set<String> tags;

    public UserAttributes() {
    }

    public UserAttributes(Map<String, CustomAttributeValue> customAttributes) {
        super(customAttributes);
    }

    public UserAttributes(String firstName, String lastName, String middleName, Gender gender, String birthday, Set<String> tags, Map<String, CustomAttributeValue> customAttributes) {
        super(customAttributes);
        this.firstName = firstName;
        this.lastName = lastName;
        this.middleName = middleName;
        this.gender = gender;
        this.birthday = birthday;
        this.tags = tags;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
        this.setField("tags", tags);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
        this.setField("firstName", firstName);
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
        this.setField("lastName", lastName);
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
        this.setField("middleName", middleName);
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
        this.setField("gender", gender != null ? gender.name() : gender);
    }

    public Date getBirthday() {
        try {
            return DateTimeUtil.DateFromYMDString(this.birthday);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setBirthday(Date birthday) {
        this.birthday = DateTimeUtil.DateToYMDString(birthday);
        this.setField("birthday", this.birthday);
    }

    String getBirthdayString() {
        return this.birthday;
    }

    void setBirthdayString(String birthday) {
        this.birthday = birthday;
        this.setField("birthday", birthday);
    }

    public static enum Gender {
        Male,
        Female;

    }
}

