/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.cloud.firebase;

import com.google.firebase.iid.FirebaseInstanceId;
import java.io.IOException;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.cloud.RegistrationTokenHandler;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.util.StringUtils;

public class FirebaseRegistrationTokenHandler
extends RegistrationTokenHandler {
    private static final String TAG = FirebaseRegistrationTokenHandler.class.getSimpleName();
    private final Broadcaster broadcaster;

    public FirebaseRegistrationTokenHandler(MobileMessagingCore mobileMessagingCore, Broadcaster broadcaster) {
        super(mobileMessagingCore);
        this.broadcaster = broadcaster;
    }

    @Override
    public void handleNewToken(String senderId, String token) {
        MobileMessagingLogger.v(TAG, (Object)"RECEIVED TOKEN", token);
        this.broadcaster.tokenReceived(token);
        this.sendRegistrationToServer(token);
    }

    @Override
    public void cleanupToken(String senderId) {
        if (StringUtils.isBlank(senderId)) {
            return;
        }
        try {
            FirebaseInstanceId.getInstance().deleteToken(senderId, "FCM");
        }
        catch (IOException e) {
            MobileMessagingLogger.e(TAG, "Error while deleting token", e);
        }
    }

    @Override
    public void acquireNewToken(String senderId) {
        try {
            String token = FirebaseInstanceId.getInstance().getToken(senderId, "FCM");
            this.handleNewToken(senderId, token);
        }
        catch (IOException e) {
            MobileMessagingLogger.e(TAG, "Error while acquiring token", e);
        }
    }
}

