/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.cloud.gcm;

import android.content.Context;
import com.google.android.gms.gcm.GcmPubSub;
import com.google.android.gms.iid.InstanceID;
import java.io.IOException;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.cloud.RegistrationTokenHandler;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.platform.Broadcaster;

@Deprecated
public class GCMRegistrationTokenHandler
extends RegistrationTokenHandler {
    private static final String[] TOPICS = new String[]{"global"};
    private final Broadcaster broadcaster;
    private final Context context;

    public GCMRegistrationTokenHandler(MobileMessagingCore mobileMessagingCore, Broadcaster broadcaster, Context context) {
        super(mobileMessagingCore);
        this.broadcaster = broadcaster;
        this.context = context;
    }

    @Override
    public void handleNewToken(String senderId, String ignored) {
        try {
            InstanceID instanceID = InstanceID.getInstance((Context)this.context);
            String token = instanceID.getToken(senderId, "GCM", null);
            MobileMessagingLogger.v("MobileMessaging", (Object)"RECEIVED TOKEN", token);
            this.broadcaster.tokenReceived(token);
            this.sendRegistrationToServer(token);
            this.subscribeTopics(token);
        }
        catch (IOException e) {
            MobileMessagingLogger.e(InternalSdkError.ERROR_TOKEN_REFRESH.get(), e);
        }
    }

    @Override
    public void cleanupToken(String senderId) {
        try {
            InstanceID instanceID = InstanceID.getInstance((Context)this.context);
            instanceID.deleteToken(senderId, "GCM");
        }
        catch (IOException e) {
            MobileMessagingLogger.e(InternalSdkError.ERROR_GCM_TOKEN_CLEANUP.get(), e);
        }
    }

    @Override
    public void acquireNewToken(String senderId) {
        try {
            InstanceID instanceID = InstanceID.getInstance((Context)this.context);
            String token = instanceID.getToken(senderId, "GCM", null);
            MobileMessagingLogger.v("MobileMessaging", (Object)"RECEIVED TOKEN AFTER RESET", token);
            this.broadcaster.tokenReceived(token);
            this.sendRegistrationToServer(token);
            this.subscribeTopics(token);
        }
        catch (IOException e) {
            MobileMessagingLogger.e(InternalSdkError.ERROR_GCM_TOKEN_CLEANUP.get(), e);
        }
    }

    private void subscribeTopics(String token) throws IOException {
        GcmPubSub pubSub = GcmPubSub.getInstance((Context)this.context);
        for (String topic : TOPICS) {
            pubSub.subscribe(token, "/topics/" + topic, null);
        }
    }
}

