/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.dal.sqlite;

import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseContract;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseHelper;
import org.infobip.mobile.messaging.dal.sqlite.PrimaryKeyViolationException;
import org.infobip.mobile.messaging.dal.sqlite.SqliteDatabaseProvider;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

public abstract class BaseDatabaseHelper
extends SQLiteOpenHelper
implements DatabaseHelper,
SqliteDatabaseProvider {
    private static final Map<Class<? extends DatabaseContract.DatabaseObject>, DatabaseContract.DatabaseObject> databaseObjectsCache = new HashMap<Class<? extends DatabaseContract.DatabaseObject>, DatabaseContract.DatabaseObject>();
    protected final Context context;
    private SQLiteDatabase sqLiteDatabase;

    public BaseDatabaseHelper(Context context, String databaseName, int currentVersion) {
        super(context, databaseName, null, currentVersion);
        this.context = context;
    }

    private SQLiteDatabase db() {
        if (this.sqLiteDatabase == null) {
            this.sqLiteDatabase = this.getWritableDatabase();
        }
        return this.sqLiteDatabase;
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> List<T> findAll(Class<T> cls) {
        Cursor cursor = this.db().rawQuery("SELECT * FROM " + this.getTableName(cls), new String[0]);
        List<T> objects = this.loadFromCursor(cursor, cls);
        cursor.close();
        return objects;
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> T find(Class<T> cls, @NonNull String primaryKey) {
        Cursor cursor = this.db().rawQuery("SELECT * FROM " + this.getTableName(cls) + " WHERE " + this.getPrimaryKeyColumn(cls) + " = ?", new String[]{primaryKey});
        List<T> objects = this.loadFromCursor(cursor, cls);
        cursor.close();
        return (T)(objects != null && !objects.isEmpty() ? (DatabaseContract.DatabaseObject)objects.get(0) : null);
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> long countAll(Class<T> cls) {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.db(), (String)this.getTableName(cls));
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> long countAll(Class<T> cls, String sqlWhereCondition) {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.db(), (String)this.getTableName(cls), (String)sqlWhereCondition);
    }

    @Override
    public void save(DatabaseContract.DatabaseObject object) {
        this.db().insertWithOnConflict(object.getTableName(), null, object.getContentValues(), 5);
    }

    @Override
    public void insert(DatabaseContract.DatabaseObject object) throws PrimaryKeyViolationException {
        try {
            this.db().insertOrThrow(object.getTableName(), null, object.getContentValues());
        }
        catch (SQLException ignored) {
            throw new PrimaryKeyViolationException();
        }
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> void deleteAll(Class<T> cls) {
        this.db().delete(this.getTableName(cls), null, new String[0]);
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> void delete(Class<T> cls, @NonNull String primaryKey) {
        this.db().delete(this.getTableName(cls), this.getPrimaryKeyColumn(cls) + "=?", new String[]{primaryKey});
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> void delete(Class<T> cls, String[] primaryKeys) {
        this.db().delete(this.getTableName(cls), this.getPrimaryKeyColumn(cls) + " IN (" + new String(new char[primaryKeys.length - 1]).replace("\u0000", "?,") + "?)", primaryKeys);
    }

    private DatabaseContract.DatabaseObject emptyDatabaseObject(Class<? extends DatabaseContract.DatabaseObject> cls) {
        DatabaseContract.DatabaseObject emptyInstance = databaseObjectsCache.get(cls);
        if (emptyInstance != null) {
            return emptyInstance;
        }
        try {
            emptyInstance = cls.newInstance();
        }
        catch (Exception e) {
            MobileMessagingLogger.e(Log.getStackTraceString((Throwable)e));
            throw new RuntimeException(e);
        }
        databaseObjectsCache.put(cls, emptyInstance);
        return emptyInstance;
    }

    private <T extends DatabaseContract.DatabaseObject> List<T> loadFromCursor(Cursor cursor, Class<T> cls) {
        if (cursor.getCount() == 0) {
            cursor.close();
            return new ArrayList();
        }
        ArrayList<DatabaseContract.DatabaseObject> objects = new ArrayList<DatabaseContract.DatabaseObject>();
        if (cursor.moveToFirst()) {
            do {
                try {
                    DatabaseContract.DatabaseObject object = (DatabaseContract.DatabaseObject)cls.newInstance();
                    object.fillFromCursor(cursor);
                    objects.add(object);
                }
                catch (Exception e) {
                    MobileMessagingLogger.e(Log.getStackTraceString((Throwable)e));
                }
            } while (cursor.moveToNext());
        }
        return objects;
    }

    private String getTableName(Class<? extends DatabaseContract.DatabaseObject> cls) {
        DatabaseContract.DatabaseObject o = this.emptyDatabaseObject(cls);
        return o != null ? o.getTableName() : null;
    }

    private String getPrimaryKeyColumn(Class<? extends DatabaseContract.DatabaseObject> cls) {
        DatabaseContract.DatabaseObject o = this.emptyDatabaseObject(cls);
        return o != null ? o.getPrimaryKeyColumnName() : null;
    }

    @Override
    public SQLiteDatabase getDatabase() {
        return this.db();
    }

    @Override
    public void deleteDatabase() {
        if (this.sqLiteDatabase != null) {
            this.sqLiteDatabase.close();
            this.sqLiteDatabase = null;
        }
        this.context.deleteDatabase(this.getDatabaseName());
    }
}

