/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.appinstance;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.CustomAttributeValue;
import org.infobip.mobile.messaging.Installation;
import org.infobip.mobile.messaging.InstallationMapper;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.UserMapper;
import org.infobip.mobile.messaging.api.appinstance.AppInstance;
import org.infobip.mobile.messaging.api.appinstance.MobileApiAppInstance;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.Result;
import org.infobip.mobile.messaging.mobile.common.MRetryableTask;
import org.infobip.mobile.messaging.mobile.common.RetryPolicyProvider;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.platform.Platform;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.util.DeviceInformation;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.StringUtils;
import org.infobip.mobile.messaging.util.SystemInformation;

public class InstallationSynchronizer {
    private final Context context;
    private final MobileMessagingCore mobileMessagingCore;
    private final MobileMessagingStats stats;
    private final Executor executor;
    private final Broadcaster broadcaster;
    private final RetryPolicyProvider retryPolicyProvider;
    private final MobileApiAppInstance mobileApiAppInstance;

    public InstallationSynchronizer(Context context, MobileMessagingCore mobileMessagingCore, MobileMessagingStats stats, Executor executor, Broadcaster broadcaster, RetryPolicyProvider retryPolicyProvider, MobileApiAppInstance mobileApiAppInstance) {
        this.context = context;
        this.mobileMessagingCore = mobileMessagingCore;
        this.stats = stats;
        this.executor = executor;
        this.broadcaster = broadcaster;
        this.retryPolicyProvider = retryPolicyProvider;
        this.mobileApiAppInstance = mobileApiAppInstance;
    }

    public void sync() {
        this.sync(null);
    }

    @VisibleForTesting
    void sync(MobileMessaging.ResultListener<Installation> actionListener) {
        boolean cloudTokenPresentAndUnreported;
        PushInstallation installation = new PushInstallation();
        SystemData systemDataForReport = this.systemDataForReport();
        if (systemDataForReport != null) {
            installation = this.from(systemDataForReport);
        }
        if (cloudTokenPresentAndUnreported = this.isCloudTokenPresentAndUnreported()) {
            installation.setToken(this.mobileMessagingCore.getCloudToken());
        }
        if (this.mobileMessagingCore.isPushServiceTypeChanged()) {
            installation.setServiceType();
        }
        if (this.mobileMessagingCore.getUnreportedPrimarySetting() != null) {
            installation.setPrimaryDevice(this.mobileMessagingCore.getUnreportedPrimarySetting());
        }
        if (!this.mobileMessagingCore.isApplicationUserIdReported().booleanValue()) {
            installation.setApplicationUserId(this.mobileMessagingCore.getApplicationUserId());
        }
        if (this.mobileMessagingCore.isPushRegistrationEnabledUnreported()) {
            installation.setPushRegistrationEnabled(this.mobileMessagingCore.isPushRegistrationEnabled());
        }
        if (this.mobileMessagingCore.isRegistrationUnavailable()) {
            installation.setServiceType();
            if (cloudTokenPresentAndUnreported) {
                this.createInstance(installation, actionListener);
            }
        } else if (installation.hasDataToReport()) {
            this.patch(installation, actionListener);
        }
    }

    public void updatePrimaryStatus(String pushRegId, Boolean primary, MobileMessaging.ResultListener<Installation> actionListener) {
        Installation installation = new Installation(pushRegId);
        installation.setPrimaryDevice(primary);
        this.patch(installation, actionListener);
    }

    private void createInstance(final Installation installation, final MobileMessaging.ResultListener<Installation> actionListener) {
        new MRetryableTask<Void, AppInstance>(){

            @Override
            public boolean shouldCancel() {
                return !InstallationSynchronizer.this.mobileMessagingCore.isRegistrationUnavailable();
            }

            public AppInstance run(Void[] voids) {
                MobileMessagingLogger.v("CREATE INSTALLATION >>>", (Object)installation);
                InstallationSynchronizer.this.setCloudTokenReported(true);
                return InstallationSynchronizer.this.mobileApiAppInstance.createInstance(false, InstallationMapper.toBackend(installation));
            }

            @Override
            public void afterBackground(AppInstance appInstance) {
                MobileMessagingLogger.v("CREATE INSTALLATION <<<", appInstance);
                if (appInstance == null) {
                    InstallationSynchronizer.this.setCloudTokenReported(false);
                    return;
                }
                Installation installation2 = InstallationMapper.fromBackend(appInstance);
                InstallationSynchronizer.this.setPushRegistrationId(installation2.getPushRegistrationId());
                InstallationSynchronizer.this.updateInstallationReported(installation2, true);
            }

            @Override
            public void after(AppInstance appInstance) {
                Installation installation2 = InstallationMapper.fromBackend(appInstance);
                InstallationSynchronizer.this.broadcaster.registrationCreated(installation2.getPushServiceToken(), installation2.getPushRegistrationId());
                if (actionListener != null) {
                    actionListener.onResult(new Result(installation2));
                }
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.v("CREATE INSTALLATION ERROR <<<", error);
                InstallationSynchronizer.this.setCloudTokenReported(false);
                InstallationSynchronizer.this.mobileMessagingCore.setLastHttpException(error);
                InstallationSynchronizer.this.stats.reportError(MobileMessagingStatsError.REGISTRATION_SYNC_ERROR);
                InstallationSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(error));
                if (actionListener != null) {
                    actionListener.onResult(new Result<Installation, MobileMessagingError>(InstallationSynchronizer.this.mobileMessagingCore.getInstallation(true), MobileMessagingError.createFrom(error)));
                }
            }

            public void cancelled(Void[] voids) {
                MobileMessagingLogger.v("CREATE INSTALLATION CANCELLED <<<");
                if (actionListener != null) {
                    actionListener.onResult(new Result(InstallationSynchronizer.this.mobileMessagingCore.getInstallation(true)));
                }
            }
        }.retryWith(this.retryPolicyProvider.DEFAULT()).execute(this.executor, (IN[])new Void[0]);
    }

    public void patch(final Installation installation, final MobileMessaging.ResultListener<Installation> actionListener) {
        String pushRegId = this.mobileMessagingCore.getPushRegistrationId();
        final boolean myDevice = this.isMyDevice(installation, pushRegId);
        if (!myDevice) {
            pushRegId = installation.getPushRegistrationId();
        }
        if (!installation.hasDataToReport()) {
            MobileMessagingLogger.w("Attempt to save empty installation data, will do nothing");
            if (actionListener != null) {
                actionListener.onResult(new Result(InternalSdkError.ERROR_SAVING_EMPTY_OBJECT.getError()));
            }
            return;
        }
        final String pushRegIdToUpdate = pushRegId;
        new MRetryableTask<Void, Void>(){

            public Void run(Void[] voids) {
                MobileMessagingLogger.v("UPDATE INSTALLATION >>>");
                InstallationSynchronizer.this.mobileApiAppInstance.patchInstance(pushRegIdToUpdate, true, new HashMap(installation.getMap()));
                return null;
            }

            @Override
            public void after(Void aVoid) {
                MobileMessagingLogger.v("UPDATE INSTALLATION <<<");
                InstallationSynchronizer.this.updateInstallationReported(installation, myDevice);
                Installation installationToReturn = installation;
                if (myDevice) {
                    installationToReturn = InstallationSynchronizer.this.mobileMessagingCore.getInstallation(true);
                }
                InstallationSynchronizer.this.broadcaster.installationUpdated(installationToReturn);
                if (actionListener != null) {
                    actionListener.onResult(new Result(installationToReturn));
                }
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.v("UPDATE INSTALLATION ERROR <<<", error);
                InstallationSynchronizer.this.setCloudTokenReported(false);
                InstallationSynchronizer.this.mobileMessagingCore.setLastHttpException(error);
                InstallationSynchronizer.this.stats.reportError(MobileMessagingStatsError.REGISTRATION_SYNC_ERROR);
                InstallationSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(error));
                if (actionListener != null) {
                    actionListener.onResult(new Result<Installation, MobileMessagingError>(InstallationSynchronizer.this.mobileMessagingCore.getInstallation(true), MobileMessagingError.createFrom(error)));
                }
            }
        }.retryWith(this.retryPolicyProvider.DEFAULT()).execute(this.executor, (IN[])new Void[0]);
    }

    private boolean isMyDevice(Installation installation, String myPushRegId) {
        return installation.getPushRegistrationId() != null && myPushRegId.equals(installation.getPushRegistrationId()) || installation.getPushRegistrationId() == null;
    }

    private void updateInstallationReported(Installation installation, boolean myDevice) {
        PreferenceHelper.remove(this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED);
        if (!myDevice) {
            this.mobileMessagingCore.savePrimarySetting(false);
            return;
        }
        if (installation.isPrimaryDevice() != null) {
            this.mobileMessagingCore.savePrimarySetting(installation.isPrimaryDevice());
        }
        if (installation.isPushRegistrationEnabled() != null) {
            this.setPushRegistrationEnabled(installation.isPushRegistrationEnabled());
            this.mobileMessagingCore.setPushRegistrationEnabledReported();
        }
        this.setCloudTokenReported(true);
        this.mobileMessagingCore.setApplicationUserIdReported(true);
        String unreportedCustomAttributes = this.mobileMessagingCore.getUnreportedCustomAttributes();
        if (unreportedCustomAttributes != null) {
            this.mobileMessagingCore.setUnreportedCustomAttributes(null);
            String reportedCustomAtts = this.mobileMessagingCore.getCustomAttributes();
            Map<String, CustomAttributeValue> customAttsMap = UserMapper.customAttsFrom(reportedCustomAtts);
            Map<String, CustomAttributeValue> unreportedCustomAttsMap = UserMapper.customAttsFrom(unreportedCustomAttributes);
            if (customAttsMap == null) {
                customAttsMap = new HashMap<String, CustomAttributeValue>();
            }
            customAttsMap.putAll(unreportedCustomAttsMap);
            this.mobileMessagingCore.saveCustomAttributes(customAttsMap);
        }
        this.mobileMessagingCore.setSystemDataReported();
        this.mobileMessagingCore.setReportedPushServiceType();
    }

    public void fetchInstance(final MobileMessaging.ResultListener<Installation> actionListener) {
        if (this.mobileMessagingCore.isRegistrationUnavailable()) {
            return;
        }
        new MRetryableTask<Void, AppInstance>(){

            public AppInstance run(Void[] voids) {
                MobileMessagingLogger.v("GET INSTALLATION >>>");
                return InstallationSynchronizer.this.mobileApiAppInstance.getInstance(InstallationSynchronizer.this.mobileMessagingCore.getPushRegistrationId());
            }

            @Override
            public void after(AppInstance instance) {
                Installation installation = InstallationMapper.fromBackend(instance);
                if (installation.isPrimaryDevice() != null) {
                    InstallationSynchronizer.this.mobileMessagingCore.savePrimarySetting(installation.isPrimaryDevice());
                }
                InstallationSynchronizer.this.mobileMessagingCore.saveCustomAttributes(installation.getCustomAttributes());
                if (actionListener != null) {
                    actionListener.onResult(new Result(installation));
                }
                MobileMessagingLogger.v("GET INSTALLATION <<<");
            }

            @Override
            public void error(Throwable error) {
                if (actionListener != null) {
                    actionListener.onResult(new Result<Installation, MobileMessagingError>(InstallationSynchronizer.this.mobileMessagingCore.getInstallation(true), MobileMessagingError.createFrom(error)));
                }
                MobileMessagingLogger.v("GET INSTALLATION ERROR <<<", error);
            }
        }.retryWith(this.retryPolicyProvider.DEFAULT()).execute(this.executor, (IN[])new Void[0]);
    }

    private boolean isCloudTokenPresentAndUnreported() {
        return !this.isCloudTokenReported() && StringUtils.isNotBlank(this.mobileMessagingCore.getCloudToken());
    }

    private SystemData systemDataForReport() {
        boolean reportEnabled = PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.REPORT_SYSTEM_INFO);
        SystemData data = new SystemData(SoftwareInformation.getSDKVersionWithPostfixForSystemData(this.context), reportEnabled ? SystemInformation.getAndroidSystemVersion() : "", reportEnabled ? DeviceInformation.getDeviceManufacturer() : "", reportEnabled ? DeviceInformation.getDeviceModel() : "", reportEnabled ? SoftwareInformation.getAppVersion(this.context) : "", this.mobileMessagingCore.isGeofencingActivated(), SoftwareInformation.areNotificationsEnabled(this.context), reportEnabled && DeviceInformation.isDeviceSecure(this.context), reportEnabled ? SystemInformation.getAndroidSystemLanguage() : "", reportEnabled ? SystemInformation.getAndroidDeviceName(this.context) : "", reportEnabled ? DeviceInformation.getDeviceTimeZoneOffset() : "");
        Integer hash = PreferenceHelper.findInt(this.context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH);
        if (hash.intValue() != data.hashCode()) {
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA, data.toString());
            return data;
        }
        return null;
    }

    private void setPushRegistrationEnabled(Boolean pushRegistrationEnabled) {
        if (pushRegistrationEnabled != null) {
            PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED, (boolean)pushRegistrationEnabled);
        }
    }

    private void setPushRegistrationId(String registrationId) {
        if (registrationId != null) {
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID, registrationId);
        }
    }

    public void setCloudTokenReported(boolean reported) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.CLOUD_TOKEN_REPORTED, reported);
    }

    public boolean isCloudTokenReported() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.CLOUD_TOKEN_REPORTED);
    }

    private PushInstallation from(SystemData data) {
        PushInstallation installation = new PushInstallation();
        installation.setSdkVersion(data.getSdkVersion());
        installation.setOsVersion(data.getOsVersion());
        installation.setDeviceManufacturer(data.getDeviceManufacturer());
        installation.setDeviceModel(data.getDeviceModel());
        installation.setAppVersion(data.getApplicationVersion());
        installation.setGeoEnabled(data.isGeofencing());
        installation.setNotificationsEnabled(data.areNotificationsEnabled());
        installation.setDeviceSecure(data.isDeviceSecure());
        installation.setLanguage(data.getLanguage());
        installation.setDeviceTimezoneOffset(data.getDeviceTimeZoneOffset());
        installation.setDeviceName(data.getDeviceName());
        installation.setOs("Android");
        return installation;
    }

    private static class PushInstallation
    extends Installation {
        private PushInstallation() {
        }

        void setServiceType() {
            super.setPushServiceType(Platform.usedPushServiceType);
        }

        void setToken(String token) {
            super.setPushServiceToken(token);
        }
    }
}

