/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.user;

import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.User;
import org.infobip.mobile.messaging.UserAttributes;
import org.infobip.mobile.messaging.UserIdentity;
import org.infobip.mobile.messaging.api.appinstance.MobileApiAppInstance;
import org.infobip.mobile.messaging.api.appinstance.UserPersonalizeBody;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.BatchReporter;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.Result;
import org.infobip.mobile.messaging.mobile.common.MRetryPolicy;
import org.infobip.mobile.messaging.mobile.common.MRetryableTask;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendInvalidParameterException;
import org.infobip.mobile.messaging.mobile.user.DepersonalizeActionListener;
import org.infobip.mobile.messaging.mobile.user.DepersonalizeServerListener;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.util.StringUtils;

public class PersonalizeSynchronizer {
    private final MobileMessagingCore mobileMessagingCore;
    private final Broadcaster broadcaster;
    private final MobileApiAppInstance mobileApiAppInstance;
    private final Executor executor;
    private final BatchReporter batchReporter;
    private final MRetryPolicy policy;
    private final DepersonalizeServerListener serverListener;

    public PersonalizeSynchronizer(MobileMessagingCore mobileMessagingCore, Broadcaster broadcaster, MobileApiAppInstance mobileApiAppInstance, MRetryPolicy policy, Executor executor, BatchReporter batchReporter, DepersonalizeServerListener serverListener) {
        this.mobileMessagingCore = mobileMessagingCore;
        this.broadcaster = broadcaster;
        this.mobileApiAppInstance = mobileApiAppInstance;
        this.policy = policy;
        this.executor = executor;
        this.batchReporter = batchReporter;
        this.serverListener = serverListener;
    }

    public void personalize(final UserIdentity userIdentity, final UserAttributes userAttributes, final boolean forceDepersonalize, final MobileMessaging.ResultListener<User> listener) {
        if (StringUtils.isBlank(this.mobileMessagingCore.getPushRegistrationId())) {
            MobileMessagingLogger.w("Registration not available yet, will patch user data later");
            if (listener != null) {
                listener.onResult(new Result<User, MobileMessagingError>(this.mobileMessagingCore.getUser(), InternalSdkError.NO_VALID_REGISTRATION.getError()));
            }
            return;
        }
        final UserPersonalizeBody userPersonalizeBody = new UserPersonalizeBody();
        userPersonalizeBody.setUserIdentity(userIdentity.getMap());
        if (userAttributes != null && userAttributes.hasDataToReport()) {
            userPersonalizeBody.setUserAttributes(userAttributes.getMap());
        }
        new MRetryableTask<UserPersonalizeBody, Void>(){

            public Void run(UserPersonalizeBody[] userPersonalizeBodies) {
                MobileMessagingLogger.v("PERSONALIZE >>>", userPersonalizeBody);
                PersonalizeSynchronizer.this.mobileApiAppInstance.personalize(PersonalizeSynchronizer.this.mobileMessagingCore.getPushRegistrationId(), forceDepersonalize, userPersonalizeBody);
                return null;
            }

            @Override
            public void after(Void aVoid) {
                MobileMessagingLogger.v("PERSONALIZE <<<");
                PersonalizeSynchronizer.this.mobileMessagingCore.setUserDataReported(new User(userIdentity, userAttributes), true);
                User userToReturn = PersonalizeSynchronizer.this.mobileMessagingCore.getUser();
                PersonalizeSynchronizer.this.broadcaster.personalized(userToReturn);
                if (listener != null) {
                    listener.onResult(new Result(userToReturn));
                }
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.v("PERSONALIZE ERROR <<<", error);
                MobileMessagingError mobileMessagingError = MobileMessagingError.createFrom(error);
                PersonalizeSynchronizer.this.broadcaster.error(mobileMessagingError);
                if (listener != null) {
                    listener.onResult(new Result<User, MobileMessagingError>(PersonalizeSynchronizer.this.mobileMessagingCore.getUser(), mobileMessagingError));
                }
                if (error instanceof BackendInvalidParameterException) {
                    PersonalizeSynchronizer.this.mobileMessagingCore.setUserDataReportedWithError();
                }
            }
        }.retryWith(this.policy).execute(this.executor, (IN[])new UserPersonalizeBody[]{userPersonalizeBody});
    }

    public void depersonalize() {
        this.batchReporter.put(new Runnable(){

            @Override
            public void run() {
                new MRetryableTask<String, Void>(){

                    public Void run(String[] pushRegIds) {
                        MobileMessagingLogger.v("DEPERSONALIZE >>>");
                        PersonalizeSynchronizer.this.mobileApiAppInstance.depersonalize(pushRegIds[0]);
                        return null;
                    }

                    @Override
                    public void before() {
                        PersonalizeSynchronizer.this.serverListener.onServerDepersonalizeStarted();
                    }

                    @Override
                    public void after(Void aVoid) {
                        MobileMessagingLogger.v("DEPERSONALIZE <<<");
                        PersonalizeSynchronizer.this.serverListener.onServerDepersonalizeCompleted();
                        PersonalizeSynchronizer.this.broadcaster.depersonalized();
                    }

                    @Override
                    public void error(Throwable error) {
                        MobileMessagingLogger.v("DEPERSONALIZE ERROR <<<", error);
                        PersonalizeSynchronizer.this.serverListener.onServerDepersonalizeFailed(error);
                        PersonalizeSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(error));
                    }
                }.retryWith(PersonalizeSynchronizer.this.policy).execute(PersonalizeSynchronizer.this.executor, (IN[])new String[]{PersonalizeSynchronizer.this.mobileMessagingCore.getPushRegistrationId()});
            }
        });
    }

    public void depersonalize(String unreportedDepersonalizedPushRegId, final DepersonalizeActionListener actionListener) {
        new MRetryableTask<String, Void>(){

            public Void run(String[] pushRegIds) {
                MobileMessagingLogger.v("DEPERSONALIZE >>>");
                PersonalizeSynchronizer.this.mobileApiAppInstance.depersonalize(pushRegIds[0]);
                return null;
            }

            @Override
            public void after(Void objects) {
                MobileMessagingLogger.v("DEPERSONALIZE <<<");
                if (actionListener != null) {
                    actionListener.onUserInitiatedDepersonalizeCompleted();
                }
                PersonalizeSynchronizer.this.broadcaster.depersonalized();
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.v("DEPERSONALIZE ERROR <<<", error);
                if (actionListener != null) {
                    actionListener.onUserInitiatedDepersonalizeFailed(error);
                }
                PersonalizeSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(error));
            }
        }.retryWith(this.policy).execute(this.executor, (IN[])new String[]{unreportedDepersonalizedPushRegId});
    }
}

