/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.platform;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import java.io.Serializable;
import java.util.List;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Installation;
import org.infobip.mobile.messaging.InstallationMapper;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.User;
import org.infobip.mobile.messaging.UserMapper;
import org.infobip.mobile.messaging.dal.bundle.MessageBundleMapper;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.platform.Broadcaster;

public class AndroidBroadcaster
implements Broadcaster {
    private final Context context;

    public AndroidBroadcaster(@NonNull Context context) {
        this.context = context;
    }

    @Override
    public void messageReceived(@NonNull Message message) {
        this.send(this.prepare(Event.MESSAGE_RECEIVED).putExtras(MessageBundleMapper.messageToBundle(message)));
    }

    @Override
    public void notificationTapped(Message message) {
        this.send(this.prepare(Event.NOTIFICATION_TAPPED).putExtras(MessageBundleMapper.messageToBundle(message)));
    }

    @Override
    public void error(@NonNull MobileMessagingError error) {
        this.send(this.prepare(Event.API_COMMUNICATION_ERROR).putExtra("org.infobip.mobile.messaging.exception", (Serializable)error));
    }

    @Override
    public void tokenReceived(String cloudToken) {
        this.send(this.prepare(Event.TOKEN_RECEIVED).putExtra("org.infobip.mobile.messaging.gcm.token", cloudToken));
    }

    @Override
    public void deliveryReported(String ... messageIds) {
        if (messageIds.length == 0) {
            return;
        }
        Intent deliveryReportsSent = this.prepare(Event.DELIVERY_REPORTS_SENT);
        Bundle extras = new Bundle();
        extras.putStringArray("org.infobip.mobile.messaging.message.ids", messageIds);
        deliveryReportsSent.putExtras(extras);
        this.send(deliveryReportsSent);
    }

    @Override
    public void seenStatusReported(String ... messageIds) {
        if (messageIds.length == 0) {
            return;
        }
        Intent seenReportsSent = this.prepare(Event.SEEN_REPORTS_SENT);
        Bundle extras = new Bundle();
        extras.putStringArray("org.infobip.mobile.messaging.message.ids", messageIds);
        seenReportsSent.putExtras(extras);
        this.send(seenReportsSent);
    }

    @Override
    public void messagesSent(List<Message> messages) {
        this.send(this.prepare(Event.MESSAGES_SENT).putParcelableArrayListExtra("org.infobip.mobile.messaging.messages", MessageBundleMapper.messagesToBundles(messages)));
    }

    @Override
    public void userUpdated(User user) {
        this.send(this.prepare(Event.USER_UPDATED).putExtras(UserMapper.toBundle("org.infobip.mobile.messaging.user", user)));
    }

    @Override
    public void installationUpdated(Installation installation) {
        this.send(this.prepare(Event.INSTALLATION_UPDATED).putExtras(InstallationMapper.toBundle("org.infobip.mobile.messaging.installation", installation)));
    }

    @Override
    public void registrationCreated(String cloudToken, String pushRegistrationId) {
        this.send(this.prepare(Event.REGISTRATION_CREATED).putExtra("org.infobip.mobile.messaging.gcm.token", cloudToken).putExtra("org.infobip.mobile.messaging.infobip.token", pushRegistrationId));
    }

    @Override
    public void depersonalized() {
        this.send(this.prepare(Event.DEPERSONALIZED));
    }

    @Override
    public void personalized(User user) {
        this.send(this.prepare(Event.PERSONALIZED).putExtras(UserMapper.toBundle("org.infobip.mobile.messaging.user", user)));
    }

    private void send(Intent intent) {
        this.context.sendBroadcast(intent);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
    }

    private Intent prepare(Event event) {
        return this.prepare(event.getKey());
    }

    private Intent prepare(String event) {
        return new Intent(event).setPackage(this.context.getPackageName());
    }
}

