/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.support.v4.content.LocalBroadcastManager;
import org.infobip.mobile.messaging.ConfigurationException;
import org.infobip.mobile.messaging.LocalEvent;
import org.infobip.mobile.messaging.MobileMessagingConnectivityReceiver;
import org.infobip.mobile.messaging.MobileMessagingSynchronizationReceiver;
import org.infobip.mobile.messaging.cloud.MobileMessagingCloudService;
import org.infobip.mobile.messaging.cloud.firebase.MobileMessagingFirebaseService;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.notification.NotificationTapReceiver;
import org.infobip.mobile.messaging.platform.MobileMessagingJobService;
import org.infobip.mobile.messaging.platform.Platform;
import org.infobip.mobile.messaging.util.SoftwareInformation;

public class ComponentUtil {
    public static void setState(Context context, boolean enabled, Class componentClass) {
        int state = enabled ? 1 : 2;
        ComponentName componentName = new ComponentName(context, componentClass);
        try {
            context.getPackageManager().setComponentEnabledSetting(componentName, state, 1);
        }
        catch (Exception e) {
            throw new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_COMPONENT, componentClass.getCanonicalName());
        }
    }

    public static void setSynchronizationReceiverStateEnabled(Context context, MobileMessagingSynchronizationReceiver syncReceiver, boolean enabled) {
        if (enabled) {
            LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)syncReceiver, new IntentFilter(LocalEvent.APPLICATION_FOREGROUND.getKey()));
        } else {
            LocalBroadcastManager.getInstance((Context)context).unregisterReceiver((BroadcastReceiver)syncReceiver);
        }
    }

    public static void setConnectivityComponentsStateEnabled(Context context, boolean enabled) {
        if (Build.VERSION.SDK_INT < 24) {
            ComponentUtil.setState(context, enabled, MobileMessagingConnectivityReceiver.class);
        } else {
            ComponentUtil.setState(context, enabled, MobileMessagingJobService.class);
        }
    }

    public static void verifyManifestComponentsForPush(Context context) {
        ComponentUtil.verifyManifestReceiver(context, NotificationTapReceiver.class);
        ComponentUtil.verifyManifestService(context, MobileMessagingCloudService.class);
        if (!Platform.shouldUseGCM) {
            ComponentUtil.verifyManifestService(context, MobileMessagingFirebaseService.class);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            ComponentUtil.verifyManifestService(context, MobileMessagingJobService.class);
        } else {
            ComponentUtil.verifyManifestReceiver(context, MobileMessagingConnectivityReceiver.class);
        }
    }

    public static void verifyManifestService(Context context, Class<? extends Service> cls) {
        try {
            context.getPackageManager().getServiceInfo(new ComponentName(context, cls), 512);
        }
        catch (Exception ignored) {
            ComponentUtil.reportMissingComponent(context, cls);
        }
    }

    public static void verifyManifestReceiver(Context context, Class<? extends BroadcastReceiver> cls) {
        try {
            context.getPackageManager().getReceiverInfo(new ComponentName(context, cls), 512);
        }
        catch (Exception ignored) {
            ComponentUtil.reportMissingComponent(context, cls);
        }
    }

    private static void reportMissingComponent(Context context, Class cls) {
        ConfigurationException exception = new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_COMPONENT, cls.getCanonicalName());
        if (SoftwareInformation.isDebuggableApplicationBuild(context)) {
            throw exception;
        }
        MobileMessagingLogger.e(exception.getMessage());
    }
}

