/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import java.util.HashMap;
import java.util.Map;
import org.infobip.mobile.messaging.CustomAttributeValue;
import org.infobip.mobile.messaging.CustomAttributesMapper;
import org.infobip.mobile.messaging.api.support.MapModel;

public class CustomAttributeHolder
extends MapModel {
    private Map<String, CustomAttributeValue> customAttributes;

    public CustomAttributeHolder() {
    }

    public CustomAttributeHolder(Map<String, CustomAttributeValue> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public void setCustomAttributes(Map<String, CustomAttributeValue> customAttributes) {
        this.customAttributes = customAttributes;
        this.setField("customAttributes", customAttributes != null ? CustomAttributesMapper.customAttsToBackend(customAttributes) : null);
    }

    public Map<String, CustomAttributeValue> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttribute(String key, CustomAttributeValue customAttributeValue) {
        if (this.customAttributes == null) {
            this.customAttributes = new HashMap<String, CustomAttributeValue>();
        }
        this.customAttributes.put(key, customAttributeValue);
        this.setCustomAttField(key, customAttributeValue);
    }

    public CustomAttributeValue getCustomAttributeValue(String key) {
        if (this.customAttributes == null) {
            return null;
        }
        return this.customAttributes.get(key);
    }

    public void removeCustomAttribute(String key) {
        if (this.customAttributes == null) {
            this.customAttributes = new HashMap<String, CustomAttributeValue>();
        }
        this.customAttributes.put(key, null);
        this.setCustomAttField(key, null);
    }

    private void setCustomAttField(String key, CustomAttributeValue customAttributeValue) {
        HashMap<String, Object> customAtts = (HashMap<String, Object>)this.getField("customAttributes");
        if (customAtts == null) {
            customAtts = new HashMap<String, Object>();
        }
        customAtts.put(key, CustomAttributesMapper.customValueToBackend(customAttributeValue));
        this.setField("customAttributes", customAtts);
    }
}

