/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.support.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;
import org.infobip.mobile.messaging.CustomAttributeValue;
import org.infobip.mobile.messaging.util.DateTimeUtil;

public class EventPropertiesMapper {
    @NonNull
    public static Map<String, Object> eventPropertiesToBackend(@NonNull Map<String, CustomAttributeValue> eventProperties) {
        HashMap<String, Object> eventPropertiesToReport = new HashMap<String, Object>(eventProperties.size());
        for (Map.Entry<String, CustomAttributeValue> entry : eventProperties.entrySet()) {
            eventPropertiesToReport.put(entry.getKey(), EventPropertiesMapper.eventPropertyToBackend(entry.getValue()));
        }
        return eventPropertiesToReport;
    }

    static Object eventPropertyToBackend(CustomAttributeValue value) {
        if (value == null) {
            return null;
        }
        switch (value.getType()) {
            case Date: {
                return DateTimeUtil.dateToISO8601UTCString(value.dateValue());
            }
            case Number: {
                return value.numberValue();
            }
            case String: {
                return value.stringValue();
            }
            case Boolean: {
                return value.booleanValue();
            }
        }
        return null;
    }
}

