/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.os.Bundle;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.infobip.mobile.messaging.dal.bundle.MessageBundleMapper;
import org.infobip.mobile.messaging.platform.Time;
import org.json.JSONObject;

public class Message
implements Comparable<Message> {
    private String messageId;
    private String title;
    private String body;
    private String sound;
    private boolean vibrate;
    private String icon;
    private boolean silent;
    private String category;
    private String from;
    private long receivedTimestamp;
    private long seenTimestamp;
    private long sentTimestamp;
    private long inAppExpiryTimestamp;
    private JSONObject customPayload;
    private String internalData;
    private String contentUrl;
    private InAppStyle inAppStyle;
    private String destination;
    private Status status;
    private String statusMessage;

    public static Message createFrom(Bundle bundle) {
        return MessageBundleMapper.messageFromBundle(bundle);
    }

    public static List<Message> createFrom(ArrayList<Bundle> bundles) {
        return MessageBundleMapper.messagesFromBundles(bundles);
    }

    public Message(String messageId, String title, String body, String sound, boolean vibrate, String icon, boolean silent, String category, String from, long receivedTimestamp, long seenTimestamp, long sentTimestamp, JSONObject customPayload, String internalData, String destination, Status status, String statusMessage, String contentUrl, InAppStyle inAppStyle, long inAppExpiryTimestamp) {
        this.messageId = messageId;
        this.title = title;
        this.body = body;
        this.sound = sound;
        this.vibrate = vibrate;
        this.icon = icon;
        this.silent = silent;
        this.category = category;
        this.from = from;
        this.receivedTimestamp = receivedTimestamp;
        this.seenTimestamp = seenTimestamp;
        this.sentTimestamp = sentTimestamp;
        this.customPayload = customPayload;
        this.internalData = internalData;
        this.destination = destination;
        this.status = status;
        this.statusMessage = statusMessage;
        this.contentUrl = contentUrl;
        this.inAppStyle = inAppStyle;
        this.inAppExpiryTimestamp = inAppExpiryTimestamp;
    }

    public Message() {
        this.messageId = UUID.randomUUID().toString();
        this.sentTimestamp = Time.now();
        this.receivedTimestamp = Time.now();
        this.status = Status.UNKNOWN;
    }

    @Override
    public int compareTo(@NonNull Message another) {
        if (another.sentTimestamp != 0L && this.sentTimestamp != 0L) {
            return (int)Math.signum(another.sentTimestamp - this.sentTimestamp);
        }
        return (int)Math.signum(another.receivedTimestamp - this.receivedTimestamp);
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public String getInternalData() {
        return this.internalData;
    }

    public void setInternalData(String internalData) {
        this.internalData = internalData;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public boolean isDefaultSound() {
        return "default".equals(this.sound);
    }

    public boolean isVibrate() {
        return this.vibrate;
    }

    public void setVibrate(boolean vibrate) {
        this.vibrate = vibrate;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public long getReceivedTimestamp() {
        return this.receivedTimestamp;
    }

    public void setReceivedTimestamp(long receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
    }

    public long getSeenTimestamp() {
        return this.seenTimestamp;
    }

    public void setSeenTimestamp(long seenTimestamp) {
        this.seenTimestamp = seenTimestamp;
    }

    public long getSentTimestamp() {
        return this.sentTimestamp;
    }

    public void setSentTimestamp(long sentTimestamp) {
        this.sentTimestamp = sentTimestamp;
    }

    public long getInAppExpiryTimestamp() {
        return this.inAppExpiryTimestamp;
    }

    public void setInAppExpiryTimestamp(long inAppExpiryTimestamp) {
        this.inAppExpiryTimestamp = inAppExpiryTimestamp;
    }

    public JSONObject getCustomPayload() {
        return this.customPayload;
    }

    public void setCustomPayload(JSONObject customPayload) {
        this.customPayload = customPayload;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public InAppStyle getInAppStyle() {
        return this.inAppStyle;
    }

    public void setInAppStyle(InAppStyle inAppStyle) {
        this.inAppStyle = inAppStyle;
    }

    public static enum InAppStyle {
        MODAL,
        BANNER;

    }

    public static enum Status {
        SUCCESS,
        ERROR,
        UNKNOWN;

    }
}

