/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infobip.mobile.messaging.CustomAttributeValue;
import org.infobip.mobile.messaging.CustomAttributesMapper;
import org.infobip.mobile.messaging.Installation;
import org.infobip.mobile.messaging.InstallationMapper;
import org.infobip.mobile.messaging.User;
import org.infobip.mobile.messaging.UserAttributes;
import org.infobip.mobile.messaging.api.appinstance.AppInstance;
import org.infobip.mobile.messaging.api.appinstance.UserBody;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.api.support.util.CollectionUtils;
import org.infobip.mobile.messaging.api.support.util.MapUtils;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.DateTimeUtil;
import org.infobip.mobile.messaging.util.StringUtils;
import org.json.JSONObject;

public class UserMapper {
    private static final JsonSerializer nullSerializer = new JsonSerializer(true, new JsonSerializer.ObjectAdapter[0]);

    static Pair<User, Map<String, CustomAttributeValue>> migrateToNewModels(String existingUserDataSerialized) {
        User newUser = new User();
        Map<String, CustomAttributeValue> customInstallationAtts = null;
        try {
            JSONObject userDataJsonObject = new JSONObject(existingUserDataSerialized);
            if (userDataJsonObject.has("externalUserId") && userDataJsonObject.opt("externalUserId") != null && !"null".equals(userDataJsonObject.opt("externalUserId"))) {
                newUser.setExternalUserId(userDataJsonObject.optString("externalUserId"));
            }
            if (userDataJsonObject.has("predefinedUserData")) {
                Object gender;
                HashSet<String> set;
                JSONObject predefinedUserData = userDataJsonObject.optJSONObject("predefinedUserData");
                if (predefinedUserData.opt("firstName") != null) {
                    newUser.setFirstName(predefinedUserData.optString("firstName"));
                }
                if (predefinedUserData.opt("middleName") != null) {
                    newUser.setMiddleName(predefinedUserData.optString("middleName"));
                }
                if (predefinedUserData.opt("lastName") != null) {
                    newUser.setLastName(predefinedUserData.optString("lastName"));
                }
                if (predefinedUserData.opt("msisdn") != null) {
                    set = new HashSet<String>();
                    set.add(predefinedUserData.optString("msisdn"));
                    newUser.setPhones(set);
                }
                if (predefinedUserData.opt("email") != null) {
                    set = new HashSet();
                    set.add(predefinedUserData.optString("email"));
                    newUser.setEmails(set);
                }
                if (predefinedUserData.opt("birthdate") != null) {
                    newUser.setBirthday(DateTimeUtil.dateFromYMDString(predefinedUserData.optString("birthdate")));
                }
                if ((gender = predefinedUserData.opt("gender")) instanceof String) {
                    String genderAsString = (String)gender;
                    if ("F".equalsIgnoreCase(genderAsString) || "Female".equalsIgnoreCase(genderAsString)) {
                        newUser.setGender(UserAttributes.Gender.Female);
                    }
                    if ("M".equalsIgnoreCase(genderAsString) || "Male".equalsIgnoreCase(genderAsString)) {
                        newUser.setGender(UserAttributes.Gender.Male);
                    }
                }
            }
            if (userDataJsonObject.optString("customUserData") != null) {
                customInstallationAtts = CustomAttributesMapper.customAttsFrom(userDataJsonObject.optString("customUserData"));
            }
        }
        catch (Exception e) {
            MobileMessagingLogger.e("User data migration failed %s", e.getMessage());
            newUser = null;
        }
        return new Pair((Object)newUser, customInstallationAtts);
    }

    @Nullable
    public static User fromBackend(UserBody userResponseBody) {
        if (userResponseBody == null) {
            return null;
        }
        return new User(userResponseBody.getExternalUserId(), userResponseBody.getFirstName(), userResponseBody.getLastName(), userResponseBody.getMiddleName(), UserMapper.genderFromBackend(userResponseBody.getGender()), userResponseBody.getBirthday(), UserMapper.destinationsFromBackend(userResponseBody.getPhones()), UserMapper.destinationsFromBackend(userResponseBody.getEmails()), userResponseBody.getTags(), UserMapper.installationsFromBackend(userResponseBody), CustomAttributesMapper.customAttsFromBackend(userResponseBody.getCustomAttributes()));
    }

    public static User fromJson(String userDataJson) {
        if (StringUtils.isBlank(userDataJson)) {
            return null;
        }
        return (User)((Object)nullSerializer.deserialize(userDataJson, User.class));
    }

    public static String toJson(User user) {
        if (user == null) {
            return null;
        }
        return nullSerializer.serialize((Object)user);
    }

    static User fromBundle(String key, Bundle bundle) {
        if (bundle == null || !bundle.containsKey(key)) {
            return null;
        }
        return UserMapper.fromJson(bundle.getString(key));
    }

    public static Bundle toBundle(String key, User user) {
        Bundle bundle = new Bundle();
        bundle.putString(key, UserMapper.toJson(user));
        return bundle;
    }

    static List<Map<String, Object>> mapPhonesToBackend(Set<String> phones) {
        return UserMapper.mapDestinationsToBackend(phones, "number");
    }

    static List<Map<String, Object>> mapEmailsToBackend(Set<String> emails) {
        return UserMapper.mapDestinationsToBackend(emails, "address");
    }

    private static List<Map<String, Object>> mapDestinationsToBackend(Set<String> destinations, String addressKey) {
        if (destinations == null) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(destinations.size());
        for (String destination : destinations) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(addressKey, destination);
            list.add(map);
        }
        return list;
    }

    private static List<Installation> installationsFromBackend(UserBody userResponse) {
        if (userResponse == null || userResponse.getInstances() == null) {
            return null;
        }
        ArrayList<Installation> installations = new ArrayList<Installation>();
        for (AppInstance instance : userResponse.getInstances()) {
            installations.add(InstallationMapper.fromBackend(instance));
        }
        return installations;
    }

    @Nullable
    static User merge(User old, User latest) {
        if (old == null && latest == null) {
            return null;
        }
        User merged = new User();
        UserMapper.plus(merged, old);
        UserMapper.plus(merged, latest);
        return merged;
    }

    private static void plus(User existing, User data) {
        if (data == null) {
            return;
        }
        if (data.containsField("externalUserId") || data.getExternalUserId() != null) {
            existing.setExternalUserId(data.getExternalUserId());
        }
        if (data.containsField("firstName") || data.getFirstName() != null) {
            existing.setFirstName(data.getFirstName());
        }
        if (data.containsField("lastName") || data.getLastName() != null) {
            existing.setLastName(data.getLastName());
        }
        if (data.containsField("middleName") || data.getMiddleName() != null) {
            existing.setMiddleName(data.getMiddleName());
        }
        if (data.containsField("gender") || data.getGender() != null) {
            existing.setGender(data.getGender());
        }
        if (data.containsField("birthday") || data.getBirthdayString() != null) {
            existing.setBirthdayString(data.getBirthdayString());
        }
        if (data.containsField("phones") || data.getPhones() != null) {
            existing.setPhones(data.getPhones());
        }
        if (data.containsField("emails") || data.getEmails() != null) {
            existing.setEmails(data.getEmails());
        }
        if (data.containsField("tags") || data.getTags() != null) {
            existing.setTags(data.getTags());
        }
        if (data.containsField("customAttributes") || data.getCustomAttributes() != null && !data.getCustomAttributes().isEmpty()) {
            existing.setCustomAttributes(MapUtils.concat((Map[])new Map[]{existing.getCustomAttributes(), data.getCustomAttributes()}));
        }
        existing.setInstallations((List)CollectionUtils.concat((Collection[])new List[]{existing.getInstallations(), data.getInstallations()}));
    }

    public static User filterOutDeletedData(User user) {
        HashMap<String, CustomAttributeValue> customAtts = null;
        if (user.getCustomAttributes() != null) {
            customAtts = new HashMap<String, CustomAttributeValue>(user.getCustomAttributes());
            Iterator iterator = customAtts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getValue() != null) continue;
                iterator.remove();
            }
        }
        return new User(user.getExternalUserId(), user.getFirstName(), user.getLastName(), user.getMiddleName(), user.getGender(), user.getBirthdayString(), user.getPhones(), user.getEmails(), user.getTags(), user.getInstallations(), customAtts);
    }

    public static UserAttributes.Gender genderFromBackend(String gender) {
        try {
            return gender != null ? UserAttributes.Gender.valueOf(gender) : null;
        }
        catch (Exception e) {
            MobileMessagingLogger.w("Cannot parse gender", e);
            return null;
        }
    }

    private static Set<String> destinationsFromBackend(Set<? extends UserBody.Destination> destinations) {
        if (destinations == null) {
            return null;
        }
        HashSet<String> addresses = new HashSet<String>(destinations.size());
        for (UserBody.Destination destination : destinations) {
            addresses.add(destination.getDestinationId());
        }
        return addresses;
    }
}

