/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.cloud;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.cloud.MobileMessageHandler;
import org.infobip.mobile.messaging.cloud.RegistrationTokenHandler;
import org.infobip.mobile.messaging.dal.bundle.MessageBundleMapper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.platform.Lazy;

public class MobileMessagingCloudHandler {
    private static final String PREFIX = "org.infobip.mobile.messaging.cloud.";
    static final String EXTRA_SENDER_ID = "org.infobip.mobile.messaging.cloud.SENDER_ID";
    static final String EXTRA_TOKEN = "org.infobip.mobile.messaging.cloud.TOKEN";
    static final String ACTION_CLOUD_MESSAGE_RECEIVE = "org.infobip.mobile.messaging.cloud.MESSAGE_RECEIVE";
    static final String ACTION_TOKEN_ACQUIRE = "org.infobip.mobile.messaging.cloud.TOKEN_ACQUIRE";
    static final String ACTION_TOKEN_CLEANUP = "org.infobip.mobile.messaging.cloud.TOKEN_CLEANUP";
    static final String ACTION_TOKEN_RESET = "org.infobip.mobile.messaging.cloud.TOKEN_RESET";
    static final String ACTION_NEW_TOKEN = "org.infobip.mobile.messaging.cloud.NEW_TOKEN";
    private final Lazy<RegistrationTokenHandler, Context> registrationTokenHandler;
    private final Lazy<MobileMessageHandler, Context> mobileMessageHandler;

    public MobileMessagingCloudHandler(RegistrationTokenHandler registrationTokenHandler, MobileMessageHandler mobileMessageHandler) {
        this.registrationTokenHandler = Lazy.just(registrationTokenHandler);
        this.mobileMessageHandler = Lazy.just(mobileMessageHandler);
    }

    @VisibleForTesting(otherwise=3)
    public void handleWork(Context context, Intent intent) {
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        switch (action) {
            case "org.infobip.mobile.messaging.cloud.MESSAGE_RECEIVE": {
                this.handleMessage(context, intent);
                break;
            }
            case "org.infobip.mobile.messaging.cloud.NEW_TOKEN": {
                this.handleNewToken(context, intent);
                break;
            }
            case "org.infobip.mobile.messaging.cloud.TOKEN_CLEANUP": {
                this.handleTokenCleanup(context, intent);
                break;
            }
            case "org.infobip.mobile.messaging.cloud.TOKEN_RESET": {
                this.handleTokenReset(context, intent);
                break;
            }
            case "org.infobip.mobile.messaging.cloud.TOKEN_ACQUIRE": {
                this.handleTokenAcquire(context, intent);
            }
        }
    }

    private void handleNewToken(Context context, @NonNull Intent intent) {
        String senderId = intent.getStringExtra(EXTRA_SENDER_ID);
        String token = intent.getStringExtra(EXTRA_TOKEN);
        this.registrationTokenHandler.get(context).handleNewToken(senderId, token);
    }

    private void handleTokenAcquire(Context context, @NonNull Intent intent) {
        String senderId = intent.getStringExtra(EXTRA_SENDER_ID);
        this.registrationTokenHandler.get(context).acquireNewToken(senderId);
    }

    private void handleTokenCleanup(Context context, @NonNull Intent intent) {
        String senderId = intent.getStringExtra(EXTRA_SENDER_ID);
        this.registrationTokenHandler.get(context).cleanupToken(senderId);
    }

    private void handleTokenReset(Context context, @NonNull Intent intent) {
        String senderId = intent.getStringExtra(EXTRA_SENDER_ID);
        RegistrationTokenHandler handler = this.registrationTokenHandler.get(context);
        handler.cleanupToken(senderId);
        handler.acquireNewToken(senderId);
    }

    private void handleMessage(Context context, @NonNull Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras == null) {
            MobileMessagingLogger.e("No extras in intent, cannot receive message");
            return;
        }
        Message message = MessageBundleMapper.messageFromBundle(extras);
        this.mobileMessageHandler.get(context).handleMessage(message);
    }
}

