/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.cloud.firebase;

import android.content.Context;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.cloud.MobileMessagingCloudService;
import org.infobip.mobile.messaging.cloud.firebase.FirebaseMessageMapper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

public class MobileMessagingFirebaseService
extends FirebaseMessagingService {
    private static final String TAG = MobileMessagingFirebaseService.class.getSimpleName();
    private static FirebaseMessageMapper messageMapper;

    public static FirebaseMessageMapper getMessageMapper() {
        if (null == messageMapper) {
            messageMapper = new FirebaseMessageMapper();
        }
        return messageMapper;
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        MobileMessagingFirebaseService.onMessageReceived((Context)this, remoteMessage);
    }

    public void onNewToken(String token) {
        MobileMessagingFirebaseService.onNewToken((Context)this, token);
    }

    public static boolean onMessageReceived(Context context, RemoteMessage remoteMessage) {
        Message message = MobileMessagingFirebaseService.getMessageMapper().createMessage(remoteMessage);
        MobileMessagingLogger.v(TAG, (Object)"RECEIVED MESSAGE FROM FCM", message);
        if (message != null) {
            MobileMessagingCloudService.enqueueNewMessage(context, message);
            return true;
        }
        MobileMessagingLogger.w("Cannot process message");
        return false;
    }

    public static void onNewToken(Context context, String token) {
        MobileMessagingLogger.v(TAG, (Object)"RECEIVED NEW FCM TOKEN", token);
        String senderId = MobileMessagingCore.getSenderId(context);
        MobileMessagingCloudService.enqueueNewToken(context, senderId, token);
    }
}

