/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.dal.json;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;

public class InternalDataMapper {
    private static final JsonSerializer serializer = new JsonSerializer(false, new JsonSerializer.ObjectAdapter[0]);

    public static String createInternalDataForFCMBasedOnMessageContents(@NonNull Message message) {
        return InternalDataMapper.createInternalDataForMessage(message);
    }

    public static String createInternalDataBasedOnMessageContents(@NonNull Message message) {
        return InternalDataMapper.createInternalDataForMessage(message);
    }

    public static void updateMessageWithInternalData(@NonNull Message message, String internalDataJson) {
        InternalData internalData = (InternalData)serializer.deserialize(internalDataJson, InternalData.class);
        if (internalData == null || internalData.silent == null) {
            return;
        }
        message.setTitle(internalData.silent.title);
        message.setBody(internalData.silent.body);
        message.setSound(internalData.silent.sound);
        if (internalData.silent.vibrate != null) {
            message.setVibrate(Boolean.valueOf(internalData.silent.vibrate.toString()));
        }
    }

    public static String getInternalDataTitle(String json) {
        try {
            return ((InternalData)InternalDataMapper.serializer.deserialize((String)json, InternalData.class)).silent.title;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getInternalDataBody(String json) {
        try {
            return ((InternalData)InternalDataMapper.serializer.deserialize((String)json, InternalData.class)).silent.body;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getInternalDataSound(String json) {
        try {
            return ((InternalData)InternalDataMapper.serializer.deserialize((String)json, InternalData.class)).silent.sound;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getInternalDataVibrate(String json, boolean defaultVibrate) {
        try {
            Object vibrate = ((InternalData)InternalDataMapper.serializer.deserialize((String)json, InternalData.class)).silent.vibrate;
            return Boolean.valueOf(vibrate.toString());
        }
        catch (Exception e) {
            return defaultVibrate;
        }
    }

    public static String getInternalDataCategory(String json) {
        try {
            return ((InternalData)InternalDataMapper.serializer.deserialize((String)json, InternalData.class)).silent.category;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getInternalDataContentUrl(String json) {
        try {
            return ((InternalData)InternalDataMapper.serializer.deserialize((String)json, InternalData.class)).atts[0].url;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static long getInternalDataSendDateTime(String json) {
        try {
            return ((InternalData)InternalDataMapper.serializer.deserialize((String)json, InternalData.class)).sendDateTime;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long getInternalDataInAppExpiryDateTime(String json) {
        try {
            return ((InternalData)InternalDataMapper.serializer.deserialize((String)json, InternalData.class)).inAppExpiryDateTime;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static String getInternalDataBulkId(String json) {
        try {
            return ((InternalData)InternalDataMapper.serializer.deserialize((String)json, InternalData.class)).bulkId;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getInternalDataInitialMessageId(String json) {
        try {
            return ((InternalData)InternalDataMapper.serializer.deserialize((String)json, InternalData.class)).initialMessageId;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Message.InAppStyle getInternalDataInAppStyle(String json) {
        try {
            InternalData internalData = (InternalData)serializer.deserialize(json, InternalData.class);
            if (internalData.inAppStyle != null) {
                return internalData.inAppStyle;
            }
            if (internalData.inApp.booleanValue()) {
                return Message.InAppStyle.MODAL;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static <VibrateValueType> String createInternalDataForMessage(Message message) {
        InternalData internalData = (InternalData)serializer.deserialize(message.getInternalData(), InternalData.class);
        internalData = InternalDataMapper.addContentUrlToInternalData(message, internalData);
        internalData = InternalDataMapper.addSilentToInternalData(message, internalData);
        internalData = InternalDataMapper.addSendDateTimeToInternalData(message, internalData);
        internalData = InternalDataMapper.addInAppStyleToInternalData(message, internalData);
        return InternalDataMapper.mergeExistingInternalDataWithAnythingToJson(message.getInternalData(), internalData);
    }

    @Nullable
    public static String mergeExistingInternalDataWithAnythingToJson(@Nullable String internalDataJson, @Nullable Object object) {
        if (internalDataJson == null && object == null) {
            return null;
        }
        if (internalDataJson == null || object == null) {
            return internalDataJson != null ? internalDataJson : serializer.serialize(object);
        }
        Map resultingMap = (Map)serializer.deserialize(internalDataJson, HashMap.class);
        String objectJson = serializer.serialize(object);
        Map objectMap = (Map)serializer.deserialize(objectJson, HashMap.class);
        resultingMap.putAll(objectMap);
        return serializer.serialize((Object)resultingMap);
    }

    private static <VibrateValueType> InternalData<VibrateValueType> addSilentToInternalData(Message message, InternalData<VibrateValueType> internalData) {
        if (!message.isSilent()) {
            return internalData;
        }
        if (internalData == null) {
            internalData = new InternalData();
        }
        if (internalData.silent == null) {
            internalData.silent = new Silent();
        }
        internalData.silent.title = message.getTitle();
        internalData.silent.body = message.getBody();
        internalData.silent.sound = message.getSound();
        if (internalData.silent.vibrate instanceof Boolean) {
            internalData.silent.vibrate = message.isVibrate();
        } else if (internalData.silent.vibrate instanceof String) {
            internalData.silent.vibrate = message.isVibrate() ? "true" : "false";
        }
        internalData.silent.category = message.getCategory();
        return internalData;
    }

    private static InternalData addContentUrlToInternalData(@NonNull Message message, InternalData internalData) {
        if (message.getContentUrl() == null) {
            return internalData;
        }
        if (internalData == null) {
            internalData = new InternalData();
        }
        internalData.atts = InternalDataMapper.createAttachments(message.getContentUrl());
        return internalData;
    }

    private static InternalData addSendDateTimeToInternalData(@NonNull Message message, InternalData internalData) {
        if (message.getSentTimestamp() == 0L) {
            return internalData;
        }
        if (internalData == null) {
            internalData = new InternalData();
        }
        internalData.sendDateTime = message.getSentTimestamp();
        return internalData;
    }

    private static InternalData addInAppStyleToInternalData(@NonNull Message message, InternalData internalData) {
        if (message.getInAppStyle() == null) {
            return internalData;
        }
        if (internalData == null) {
            internalData = new InternalData();
        }
        internalData.inAppStyle = message.getInAppStyle();
        internalData.inApp = message.getInAppStyle() == Message.InAppStyle.MODAL ? Boolean.valueOf(true) : null;
        return internalData;
    }

    private static Attachment[] createAttachments(@NonNull String contentUrl) {
        Attachment[] atts = new Attachment[]{new Attachment()};
        atts[0].url = contentUrl;
        return atts;
    }

    private static class Attachment {
        String t;
        String url;

        private Attachment() {
        }
    }

    public static class InternalData<VibrateValueType> {
        Attachment[] atts = new Attachment[0];
        long sendDateTime;
        Silent<VibrateValueType> silent;
        String bulkId;
        String initialMessageId;
        @Deprecated
        Boolean inApp;
        Message.InAppStyle inAppStyle;
        long inAppExpiryDateTime;

        public InternalData() {
        }

        public InternalData(long sendDateTime, String contentUrl) {
            this.sendDateTime = sendDateTime;
            if (contentUrl != null) {
                this.atts = InternalDataMapper.createAttachments(contentUrl);
            }
        }
    }

    private static class Silent<VibrateValueType> {
        String title;
        String body;
        String sound;
        VibrateValueType vibrate;
        String category;

        private Silent() {
        }
    }
}

