/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.dal.json;

import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONObjectAdapter
implements JsonSerializer.ObjectAdapter<JSONObject> {
    public Class<JSONObject> getCls() {
        return JSONObject.class;
    }

    public JSONObject deserialize(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new JSONObject(value);
        }
        catch (JSONException e) {
            MobileMessagingLogger.e("Error parsing JSONObject from " + value, e);
            return null;
        }
    }

    public String serialize(JSONObject value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

