/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.interactive.inapp.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.interactive.MobileInteractive;
import org.infobip.mobile.messaging.interactive.NotificationAction;
import org.infobip.mobile.messaging.interactive.NotificationCategory;
import org.infobip.mobile.messaging.interactive.inapp.foreground.ForegroundState;
import org.infobip.mobile.messaging.interactive.inapp.foreground.ForegroundStateMonitor;
import org.infobip.mobile.messaging.interactive.inapp.rules.ShowOrNot;
import org.infobip.mobile.messaging.interactive.predefined.PredefinedActionsProvider;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.util.StringUtils;

public class InAppRules {
    private final MobileInteractive mobileInteractive;
    private final ForegroundStateMonitor foregroundStateMonitor;
    private final NotificationAction[] defaultInAppActions;

    public InAppRules(MobileInteractive mobileInteractive, ForegroundStateMonitor foregroundStateMonitor, PredefinedActionsProvider predefinedActionsProvider) {
        this.mobileInteractive = mobileInteractive;
        this.foregroundStateMonitor = foregroundStateMonitor;
        this.defaultInAppActions = predefinedActionsProvider.getDefaultInAppActions();
    }

    public ShowOrNot shouldDisplayDialogFor(Message message) {
        long inAppExpiryTimestamp = message.getInAppExpiryTimestamp();
        if (!InAppRules.hasInAppEnabled(message) || inAppExpiryTimestamp != 0L && inAppExpiryTimestamp < Time.now()) {
            return ShowOrNot.not();
        }
        ForegroundState state = this.foregroundStateMonitor.isInForeground();
        if (state.isForeground() && state.getForegroundActivity() != null && !state.getForegroundActivity().isFinishing()) {
            if (StringUtils.isBlank(message.getCategory())) {
                return ShowOrNot.showNowWithDefaultActions(state.getForegroundActivity(), this.defaultInAppActions);
            }
            NotificationCategory category = this.mobileInteractive.getNotificationCategory(message.getCategory());
            if (category == null || category.getNotificationActions() == null) {
                return ShowOrNot.showNowWithDefaultActions(state.getForegroundActivity(), this.defaultInAppActions);
            }
            List<NotificationAction> actions = Arrays.asList(category.getNotificationActions());
            if (actions.size() == 0) {
                return ShowOrNot.showNowWithDefaultActions(state.getForegroundActivity(), this.defaultInAppActions);
            }
            NotificationAction[] eligibleActions = this.filterActionsForInAppDialog(category.getNotificationActions());
            if (eligibleActions.length == 0) {
                return ShowOrNot.showNowWithDefaultActions(state.getForegroundActivity(), this.defaultInAppActions);
            }
            return ShowOrNot.showNow(category, eligibleActions, state.getForegroundActivity());
        }
        return ShowOrNot.showWhenInForeground();
    }

    private NotificationAction[] filterActionsForInAppDialog(NotificationAction[] actions) {
        ArrayList<NotificationAction> as = new ArrayList<NotificationAction>();
        for (NotificationAction action : actions) {
            if (action.hasInput()) continue;
            as.add(action);
        }
        return as.toArray(new NotificationAction[0]);
    }

    private static boolean hasInAppEnabled(Message message) {
        return message.getInAppStyle() == Message.InAppStyle.MODAL;
    }
}

