/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.interactive.inapp.rules;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import org.infobip.mobile.messaging.interactive.NotificationAction;
import org.infobip.mobile.messaging.interactive.NotificationCategory;

public class ShowOrNot {
    private final Action action;
    private final NotificationCategory category;
    private final NotificationAction[] actionsToDisplayFor;
    private final Activity baseActivityForDialog;

    private ShowOrNot(Action action, NotificationCategory category, NotificationAction[] actionsToDisplayFor, Activity baseActivityForDialog) {
        this.action = action;
        this.category = category;
        this.actionsToDisplayFor = actionsToDisplayFor;
        this.baseActivityForDialog = baseActivityForDialog;
    }

    public static ShowOrNot not() {
        return new ShowOrNot(Action.DontShow, null, new NotificationAction[0], null);
    }

    public static ShowOrNot showNowWithDefaultActions(Activity activity, @NonNull @Size(min=1L) NotificationAction[] defaultActions) {
        return new ShowOrNot(Action.ShowNow, null, defaultActions, activity);
    }

    public static ShowOrNot showNow(NotificationCategory category, @NonNull @Size(min=1L) NotificationAction[] actions, Activity activity) {
        return new ShowOrNot(Action.ShowNow, category, actions, activity);
    }

    public static ShowOrNot showWhenInForeground() {
        return new ShowOrNot(Action.ShowWhenInForeground, null, new NotificationAction[0], null);
    }

    public boolean shouldShowNow() {
        return this.action == Action.ShowNow;
    }

    public boolean shouldShowWhenInForeground() {
        return this.action == Action.ShowWhenInForeground;
    }

    public NotificationAction[] getActionsToShowFor() {
        return this.actionsToDisplayFor;
    }

    public NotificationCategory getCategory() {
        return this.category;
    }

    public Activity getBaseActivityForDialog() {
        return this.baseActivityForDialog;
    }

    public static enum Action {
        DontShow,
        ShowNow,
        ShowWhenInForeground;

    }
}

