/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.common;

import android.annotation.SuppressLint;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.api.support.ApiBackendExceptionWithContent;
import org.infobip.mobile.messaging.api.support.ApiIOException;
import org.infobip.mobile.messaging.api.support.http.client.DefaultApiClient;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.common.IMAsyncTask;
import org.infobip.mobile.messaging.mobile.common.ResultWrapper;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendCommunicationException;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendCommunicationExceptionWithContent;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendInvalidParameterException;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendInvalidParameterExceptionWithContent;

public abstract class MAsyncTask<IN, OUT>
extends IMAsyncTask<IN, OUT> {
    private static final Set<String> invalidParameterErrorCodes = new HashSet<String>(){
        {
            this.add("EMAIL_INVALID");
            this.add("PHONE_INVALID");
            this.add("USER_IDENTITY_INVALID");
            this.add("REQUEST_FORMAT_INVALID");
            this.add("USER_MERGE_INTERRUPTED");
            this.add("USER_DATA_RESTRICTED");
            this.add("PERSONALIZATION_IMPOSSIBLE");
            this.add("AMBIGUOUS_PERSONALIZE_CANDIDATES");
            this.add("NO_REGISTRATION");
        }
    };
    @SuppressLint(value={"StaticFieldLeak"})
    private final AsyncTask<IN, Void, ResultWrapper<IN, OUT>> asyncTask = new AsyncTask<IN, Void, ResultWrapper<IN, OUT>>(){

        protected void onPreExecute() {
            MAsyncTask.this.before();
        }

        protected ResultWrapper<IN, OUT> doInBackground(IN[] ins) {
            try {
                if (MAsyncTask.this.shouldCancel()) {
                    return new ResultWrapper(ins, true);
                }
                Object out = MAsyncTask.this.run(ins);
                MAsyncTask.this.afterBackground(out);
                return new ResultWrapper(out);
            }
            catch (Throwable error) {
                return new ResultWrapper(ins, error);
            }
        }

        protected void onPostExecute(ResultWrapper<IN, OUT> resultWrapper) {
            MobileMessagingLogger.v("Result wrapper: ", resultWrapper);
            if (resultWrapper.cancelled) {
                MAsyncTask.this.cancelled(resultWrapper.inputs);
                return;
            }
            if (resultWrapper.error == null) {
                MAsyncTask.this.after(resultWrapper.result);
                return;
            }
            Throwable error = MAsyncTask.backendErrorToTaskError(resultWrapper.error);
            MAsyncTask.this.error(error);
            MAsyncTask.this.error(resultWrapper.inputs, error);
        }
    };

    public void execute(IN ... ins) {
        this.asyncTask.execute((Object[])ins);
    }

    public void execute(Executor executor, IN ... ins) {
        this.asyncTask.executeOnExecutor(executor, (Object[])ins);
    }

    private static Throwable backendErrorToTaskError(Throwable originalError) {
        if (MAsyncTask.isInvalidParameterErrorWithContent(originalError)) {
            return new BackendInvalidParameterExceptionWithContent(originalError.getMessage(), (ApiBackendExceptionWithContent)originalError);
        }
        if (MAsyncTask.isErrorWithContent(originalError)) {
            return new BackendCommunicationExceptionWithContent(originalError.getMessage(), (ApiBackendExceptionWithContent)originalError);
        }
        if (MAsyncTask.isInvalidParameterError(originalError)) {
            return new BackendInvalidParameterException(originalError.getMessage(), (ApiIOException)originalError);
        }
        if (MAsyncTask.isBackendError(originalError)) {
            return new BackendCommunicationException(originalError.getMessage(), (ApiIOException)originalError);
        }
        return originalError;
    }

    private static boolean isBackendError(@NonNull Throwable error) {
        if (!(error instanceof ApiIOException)) {
            return false;
        }
        String errorCode = ((ApiIOException)error).getCode();
        return DefaultApiClient.ErrorCode.UNKNOWN_API_BACKEND_ERROR.getValue().equals(errorCode);
    }

    private static boolean isInvalidParameterError(@NonNull Throwable error) {
        if (!(error instanceof ApiIOException)) {
            return false;
        }
        String code = ((ApiIOException)error).getCode();
        return invalidParameterErrorCodes.contains(code);
    }

    private static boolean isErrorWithContent(@NonNull Throwable error) {
        return error instanceof ApiBackendExceptionWithContent;
    }

    private static boolean isInvalidParameterErrorWithContent(@NonNull Throwable error) {
        return error instanceof ApiBackendExceptionWithContent && MAsyncTask.isInvalidParameterError(error);
    }
}

