/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.events;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.util.PreferenceHelper;

public class UserSessionTracker {
    public static final String SESSION_BOUNDS_DELIMITER = "___";
    private static final int sessionTimeoutMillis = 30000;
    private static final int sessionAlarmIntervalMillis = 5000;
    private static Runnable sessionTrackingRunnable;
    private static final Handler handler;

    public static void startSessionTracking(Context context) {
        sessionTrackingRunnable = UserSessionTracker.getSessionTrackingRunnable(context);
        if (ActivityLifecycleMonitor.isForeground()) {
            handler.post(sessionTrackingRunnable);
        } else {
            handler.removeCallbacks(sessionTrackingRunnable);
        }
    }

    public static void stopSessionTracking(Context context) {
        if (sessionTrackingRunnable != null) {
            handler.removeCallbacks(sessionTrackingRunnable);
            sessionTrackingRunnable = null;
        }
        UserSessionTracker.saveActiveSessionEndTime(context, Time.now());
    }

    @NonNull
    private static Runnable getSessionTrackingRunnable(final Context context) {
        if (sessionTrackingRunnable != null) {
            return sessionTrackingRunnable;
        }
        return new Runnable(){

            @Override
            public void run() {
                if (ActivityLifecycleMonitor.isBackground()) {
                    UserSessionTracker.saveActiveSessionEndTime(context, Time.now());
                    handler.removeCallbacks((Runnable)this);
                } else {
                    UserSessionTracker.trackCurrentSession(context.getApplicationContext());
                    handler.postDelayed((Runnable)this, 5000L);
                }
            }
        };
    }

    private static void trackCurrentSession(Context context) {
        long now;
        if (ActivityLifecycleMonitor.isBackground()) {
            return;
        }
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(context);
        long activeSessionEndTimeMillis = mobileMessagingCore.getActiveSessionEndTime();
        long activeSessionStartTimeMillis = mobileMessagingCore.getActiveSessionStartTime();
        if (UserSessionTracker.shouldBeNewSession(activeSessionStartTimeMillis, activeSessionEndTimeMillis, now = Time.now())) {
            UserSessionTracker.saveActiveSessionStartTime(context, now);
            if (UserSessionTracker.sessionExistedBefore(activeSessionStartTimeMillis, activeSessionEndTimeMillis)) {
                mobileMessagingCore.saveSessionBounds(context, activeSessionStartTimeMillis, activeSessionEndTimeMillis);
                mobileMessagingCore.reportSessions();
            }
        }
        UserSessionTracker.saveActiveSessionEndTime(context, now);
    }

    private static boolean sessionExistedBefore(long activeSessionStartTimeMillis, long activeSessionEndTimeMillis) {
        return activeSessionStartTimeMillis != 0L && activeSessionEndTimeMillis != 0L;
    }

    private static boolean shouldBeNewSession(long activeSessionStartTimeMillis, long activeSessionEndTimeMillis, long now) {
        return activeSessionStartTimeMillis == 0L || now - activeSessionEndTimeMillis > 30000L;
    }

    private static void saveActiveSessionStartTime(Context context, long sessionStartTime) {
        PreferenceHelper.saveLong(context, MobileMessagingProperty.ACTIVE_SESSION_START_TIME_MILLIS, sessionStartTime);
    }

    private static void saveActiveSessionEndTime(Context context, long sessionEndTime) {
        PreferenceHelper.saveLong(context, MobileMessagingProperty.ACTIVE_SESSION_END_TIME_MILLIS, sessionEndTime);
    }

    static {
        handler = new Handler();
    }
}

