/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.messages;

import android.content.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.api.messages.MoMessagesBody;
import org.infobip.mobile.messaging.api.messages.MoMessagesResponse;
import org.infobip.mobile.messaging.api.messages.MobileApiMessages;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.Result;
import org.infobip.mobile.messaging.mobile.common.MRetryPolicy;
import org.infobip.mobile.messaging.mobile.common.MRetryableTask;
import org.infobip.mobile.messaging.mobile.messages.MoMessageMapper;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.storage.MessageStoreWrapper;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.StringUtils;

public class MoMessageSender {
    private final long MESSAGE_MAX_RETRY_LIFETIME = TimeUnit.DAYS.toMillis(2L);
    private final Context context;
    private final MobileMessagingCore mobileMessagingCore;
    private final Broadcaster broadcaster;
    private final Executor executor;
    private final MobileMessagingStats stats;
    private final MRetryPolicy retryPolicy;
    private final MRetryPolicy noRetryPolicy;
    private final MobileApiMessages mobileApiMessages;
    private final MessageStoreWrapper messageStoreWrapper;
    private final JsonSerializer jsonSerializer;

    public MoMessageSender(Context context, MobileMessagingCore mobileMessagingCore, Broadcaster broadcaster, Executor executor, MobileMessagingStats stats, MRetryPolicy retryPolicy, MobileApiMessages mobileApiMessages, MessageStoreWrapper messageStoreWrapper) {
        this.context = context;
        this.mobileMessagingCore = mobileMessagingCore;
        this.broadcaster = broadcaster;
        this.executor = executor;
        this.stats = stats;
        this.retryPolicy = retryPolicy;
        this.mobileApiMessages = mobileApiMessages;
        this.jsonSerializer = new JsonSerializer(false, new JsonSerializer.ObjectAdapter[0]);
        this.messageStoreWrapper = messageStoreWrapper;
        this.noRetryPolicy = new MRetryPolicy.Builder().withMaxRetries(0).build();
    }

    public void send(MobileMessaging.ResultListener<Message[]> listener, Message ... messages) {
        this.send(listener, true, messages);
    }

    public void sendDontSave(MobileMessaging.ResultListener<Message[]> listener, Message ... messages) {
        this.send(listener, false, messages);
    }

    public void send(final MobileMessaging.ResultListener<Message[]> listener, final boolean doSave, Message ... messages) {
        new Task(){

            @Override
            public void after(Message[] messages) {
                if (doSave) {
                    MoMessageSender.this.messageStoreWrapper.upsert(messages);
                }
                MoMessageSender.this.broadcaster.messagesSent(Arrays.asList(messages));
                if (listener != null) {
                    listener.onResult(new Result(messages));
                }
            }

            public void error(Message[] messages, Throwable error) {
                MobileMessagingLogger.e("MobileMessaging API returned error (sending message)!");
                MoMessageSender.this.stats.reportError(MobileMessagingStatsError.MESSAGE_SEND_ERROR);
                MoMessageSender.this.broadcaster.error(MobileMessagingError.createFrom(error));
                for (Message message : messages) {
                    message.setStatus(Message.Status.ERROR);
                    message.setStatusMessage(error.getMessage());
                }
                this.after(messages);
            }
        }.retryWith(this.noRetryPolicy).execute(this.executor, (IN[])messages);
    }

    public void sendWithRetry(Message ... messages) {
        this.saveMessages(messages);
        this.sync();
    }

    public void sync() {
        Message[] messages = this.getAndRemoveMessages();
        if (messages.length == 0) {
            return;
        }
        new Task(){

            public void error(Message[] messages, Throwable error) {
                MobileMessagingLogger.e("MobileMessaging API returned error (sending messages in retry)! ", error);
                MoMessageSender.this.stats.reportError(MobileMessagingStatsError.MESSAGE_SEND_ERROR);
                MoMessageSender.this.broadcaster.error(MobileMessagingError.createFrom(error));
                MoMessageSender.this.saveMessages(messages);
            }
        }.retryWith(this.retryPolicy).execute(this.executor, (IN[])messages);
    }

    private void saveMessages(Message ... messages) {
        String[] jsons = this.messagesToJson(this.excludeOutdatedMessages(messages));
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.UNSENT_MO_MESSAGES, jsons);
    }

    private Message[] getAndRemoveMessages() {
        String[] jsons = PreferenceHelper.findAndRemoveStringArray(this.context, MobileMessagingProperty.UNSENT_MO_MESSAGES);
        Message[] messages = this.messagesFromJson(jsons);
        return this.excludeOutdatedMessages(messages);
    }

    private String[] messagesToJson(Message ... messages) {
        if (messages == null || messages.length == 0) {
            return new String[0];
        }
        ArrayList<String> jsons = new ArrayList<String>(messages.length);
        for (Message message : messages) {
            jsons.add(this.jsonSerializer.serialize((Object)message));
        }
        return jsons.toArray(new String[0]);
    }

    private Message[] messagesFromJson(String ... jsons) {
        if (jsons == null || jsons.length == 0) {
            return new Message[0];
        }
        ArrayList<Object> messages = new ArrayList<Object>(jsons.length);
        for (String json : jsons) {
            messages.add(this.jsonSerializer.deserialize(json, Message.class));
        }
        return messages.toArray(new Message[0]);
    }

    private Message[] excludeOutdatedMessages(Message[] messages) {
        if (messages.length == 0) {
            return new Message[0];
        }
        Date now = Time.date();
        ArrayList<Message> relevantMessages = new ArrayList<Message>();
        for (Message message : messages) {
            long expirationTimestamp = message.getReceivedTimestamp() + this.MESSAGE_MAX_RETRY_LIFETIME;
            if (expirationTimestamp < now.getTime()) continue;
            relevantMessages.add(message);
        }
        return relevantMessages.toArray(new Message[0]);
    }

    abstract class Task
    extends MRetryableTask<Message, Message[]> {
        Task() {
        }

        public Message[] run(Message[] messages) {
            if (StringUtils.isBlank(MoMessageSender.this.mobileMessagingCore.getPushRegistrationId())) {
                MobileMessagingLogger.w("Can't send messages without valid registration");
                throw InternalSdkError.NO_VALID_REGISTRATION.getException();
            }
            MoMessagesBody moMessagesBody = MoMessageMapper.body(MoMessageSender.this.mobileMessagingCore.getPushRegistrationId(), messages);
            MobileMessagingLogger.v("SEND MO >>>", moMessagesBody);
            MoMessagesResponse moMessagesResponse = MoMessageSender.this.mobileApiMessages.sendMO(moMessagesBody);
            MobileMessagingLogger.v("SEND MO DONE <<<", moMessagesResponse);
            return MoMessageMapper.messages(moMessagesResponse);
        }
    }
}

