/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.support.annotation.NonNull;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.infobip.mobile.messaging.CustomAttributeValue;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.util.DateTimeUtil;

public class CustomAttributesMapper {
    private static final JsonSerializer nullSerializer = new JsonSerializer(true, new JsonSerializer.ObjectAdapter[0]);

    public static Map<String, Object> customAttsToBackend(@NonNull Map<String, CustomAttributeValue> customAttributes) {
        HashMap<String, Object> customAttributesToReport = new HashMap<String, Object>(customAttributes.size());
        for (Map.Entry<String, CustomAttributeValue> entry : customAttributes.entrySet()) {
            customAttributesToReport.put(entry.getKey(), CustomAttributesMapper.customValueToBackend(entry.getValue()));
        }
        return customAttributesToReport;
    }

    public static Object customValueToBackend(CustomAttributeValue value) {
        if (value == null) {
            return null;
        }
        switch (value.getType()) {
            case Date: {
                return DateTimeUtil.dateToYMDString(value.dateValue());
            }
            case Number: {
                return value.numberValue();
            }
            case String: {
                return value.stringValue();
            }
            case Boolean: {
                return value.booleanValue();
            }
        }
        return null;
    }

    public static Map<String, CustomAttributeValue> customAttsFrom(String json) {
        Type type = new TypeToken<Map<String, CustomAttributeValue>>(){}.getType();
        return (Map)nullSerializer.deserialize(json, type);
    }

    public static Map<String, CustomAttributeValue> customAttsFromBackend(Map<String, Object> customAttributes) {
        HashMap<String, CustomAttributeValue> customUserDataValueMap = new HashMap<String, CustomAttributeValue>();
        if (customAttributes == null) {
            return customUserDataValueMap;
        }
        for (Map.Entry<String, Object> entry : customAttributes.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String stringValue = (String)value;
                if (CustomAttributesMapper.isPossiblyDate(stringValue)) {
                    Date dateValue;
                    try {
                        dateValue = DateTimeUtil.dateFromISO8601DateUTCString((String)value);
                        customUserDataValueMap.put(key, new CustomAttributeValue(dateValue));
                        continue;
                    }
                    catch (ParseException ex1) {
                        try {
                            dateValue = DateTimeUtil.dateFromYMDString((String)value);
                            customUserDataValueMap.put(key, new CustomAttributeValue(dateValue));
                            continue;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
                customUserDataValueMap.put(key, new CustomAttributeValue(stringValue));
                continue;
            }
            if (value instanceof Number) {
                customUserDataValueMap.put(key, new CustomAttributeValue((Number)value));
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            customUserDataValueMap.put(key, new CustomAttributeValue((Boolean)value));
        }
        return customUserDataValueMap;
    }

    private static boolean isPossiblyDate(String stringValue) {
        return Character.isDigit(stringValue.charAt(0)) && (stringValue.length() == "yyyy-MM-dd".length() || stringValue.length() == 20);
    }
}

