/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.app;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.view.WebViewActivity;

public class ActivityStarterWrapper {
    private final Context context;
    private final MobileMessagingCore mobileMessagingCore;

    public ActivityStarterWrapper(Context context, MobileMessagingCore mobileMessagingCore) {
        this.context = context;
        this.mobileMessagingCore = mobileMessagingCore;
    }

    public void startCallbackActivity(@NonNull Intent callbackIntent) {
        NotificationSettings notificationSettings = this.mobileMessagingCore.getNotificationSettings();
        if (notificationSettings == null) {
            return;
        }
        Class<?> callbackActivity = notificationSettings.getCallbackActivity();
        if (callbackActivity == null) {
            MobileMessagingLogger.e("Callback activity is not set, cannot proceed");
            return;
        }
        int intentFlags = notificationSettings.getIntentFlags();
        callbackIntent.addFlags(intentFlags |= 0x10000000);
        callbackIntent.setClass(this.context, callbackActivity);
        this.context.startActivity(callbackIntent);
    }

    public void startWebViewActivity(@NonNull Intent webViewIntent, @NonNull String url) {
        webViewIntent.putExtra("ib_webview_url", url);
        webViewIntent.addFlags(0x14000000);
        webViewIntent.setClass(this.context, WebViewActivity.class);
        this.context.startActivity(webViewIntent);
    }
}

