/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.cloud;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import com.google.android.gms.common.GoogleApiAvailability;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.cloud.MobileMessagingCloudService;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobileapi.InternalSdkError;

public class PlayServicesSupport {
    public static final int DEVICE_NOT_SUPPORTED = -1;
    private static Boolean isPlayServicesAvailable;
    private final Handler handler = new Handler(Looper.getMainLooper());

    public void checkPlayServicesAndTryToAcquireToken(final Context context, boolean shouldResetToken, @Nullable MobileMessaging.InitListener initListener) {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int errorCode = apiAvailability.isGooglePlayServicesAvailable(context);
        isPlayServicesAvailable = errorCode == 0;
        if (errorCode != 0) {
            InternalSdkError internalSdkError;
            if (apiAvailability.isUserResolvableError(errorCode)) {
                internalSdkError = InternalSdkError.ERROR_ACCESSING_PLAY_SERVICES;
            } else {
                errorCode = -1;
                internalSdkError = InternalSdkError.DEVICE_NOT_SUPPORTED;
            }
            final int finalErrorCode = errorCode;
            if (initListener != null) {
                initListener.onError(internalSdkError, finalErrorCode);
            }
            MobileMessagingLogger.e(internalSdkError.get() + ". google error code: " + errorCode + ", see com.google.android.gms.common.ConnectionResult");
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Intent playServicesError = new Intent(Event.GOOGLE_PLAY_SERVICES_ERROR.getKey());
                    playServicesError.putExtra("org.infobip.mobile.messaging.play.services", finalErrorCode);
                    context.sendBroadcast(playServicesError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(playServicesError);
                    PlayServicesSupport.this.handler.removeCallbacksAndMessages(null);
                }
            });
            return;
        }
        String senderId = MobileMessagingCore.getSenderId(context);
        if (shouldResetToken) {
            MobileMessagingCloudService.enqueueTokenReset(context, senderId);
        } else {
            MobileMessagingCloudService.enqueueTokenAcquisition(context, senderId);
        }
        if (initListener != null) {
            initListener.onSuccess();
        }
    }

    public static boolean isPlayServicesAvailable(Context context) {
        if (isPlayServicesAvailable != null) {
            return isPlayServicesAvailable;
        }
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        isPlayServicesAvailable = apiAvailability.isGooglePlayServicesAvailable(context) == 0;
        return isPlayServicesAvailable;
    }
}

