/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.interactive.inapp.view;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.text.TextUtils;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.interactive.NotificationAction;
import org.infobip.mobile.messaging.interactive.NotificationCategory;
import org.infobip.mobile.messaging.interactive.inapp.image.DownloadImageTask;
import org.infobip.mobile.messaging.interactive.inapp.view.DialogStack;
import org.infobip.mobile.messaging.interactive.inapp.view.InAppView;
import org.infobip.mobile.messaging.interactive.inapp.view.InAppViewCtx;

public class QueuedDialogStack
implements DialogStack {
    private final Queue<InAppViewCtx> queue = new ConcurrentLinkedQueue<InAppViewCtx>();

    @Override
    public void add(InAppView view, Message message, NotificationCategory category, NotificationAction[] actions) {
        this.queue.add(new InAppViewCtx(view, message, category, actions));
        if (this.queue.size() <= 1) {
            this.show(this.queue.peek());
        }
    }

    @Override
    public void remove(InAppView view) {
        for (InAppViewCtx ctx : this.queue) {
            if (!ctx.getInAppView().equals(view)) continue;
            this.queue.remove(ctx);
            break;
        }
        this.show(this.queue.peek());
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    private void show(InAppViewCtx ctx) {
        if (ctx == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)ctx.getMessage().getContentUrl())) {
            ctx.getInAppView().show(ctx.getMessage(), ctx.getCategory(), ctx.getActions());
        } else {
            this.downloadImageThenShowDialog(ctx.getMessage(), ctx.getCategory(), ctx.getActions(), ctx.getMessage().getContentUrl(), ctx.getInAppView());
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void downloadImageThenShowDialog(final Message message, final NotificationCategory category, final NotificationAction[] actions, String imageUrl, final InAppView dialog) {
        new DownloadImageTask(){

            protected void onPostExecute(Bitmap bitmap) {
                if (bitmap == null) {
                    dialog.show(message, category, actions);
                } else {
                    dialog.showWithImage(bitmap, message, category, actions);
                }
            }
        }.execute(new String[]{imageUrl});
    }
}

