/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.interactive.notification;

import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.RemoteInput;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.app.ActivityStarterWrapper;
import org.infobip.mobile.messaging.interactive.MobileInteractive;
import org.infobip.mobile.messaging.interactive.MobileInteractiveImpl;
import org.infobip.mobile.messaging.interactive.NotificationAction;
import org.infobip.mobile.messaging.interactive.NotificationCategory;
import org.infobip.mobile.messaging.interactive.platform.AndroidInteractiveBroadcaster;
import org.infobip.mobile.messaging.interactive.platform.InteractiveBroadcaster;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

public class NotificationActionTapReceiver
extends BroadcastReceiver {
    private InteractiveBroadcaster broadcaster;
    private MobileMessagingCore mobileMessagingCore;
    private MobileInteractive mobileInteractive;
    private ActivityStarterWrapper activityStarterWrapper;

    public NotificationActionTapReceiver() {
    }

    @VisibleForTesting
    public NotificationActionTapReceiver(InteractiveBroadcaster broadcaster, MobileMessagingCore mobileMessagingCore, MobileInteractive mobileInteractive, ActivityStarterWrapper activityStarterWrapper) {
        this.broadcaster = broadcaster;
        this.mobileMessagingCore = mobileMessagingCore;
        this.mobileInteractive = mobileInteractive;
        this.activityStarterWrapper = activityStarterWrapper;
    }

    public void onReceive(Context context, Intent receivedIntent) {
        Bundle actionBundle = receivedIntent.getBundleExtra("org.infobip.mobile.messaging.notification.action.tapped");
        Bundle categoryBundle = receivedIntent.getBundleExtra("org.infobip.mobile.messaging.notification.category.tapped");
        int notificationId = receivedIntent.getIntExtra("org.infobip.mobile.messaging.notification.id", -1);
        Bundle messageBundle = receivedIntent.getBundleExtra("org.infobip.mobile.messaging.message");
        this.cancelNotification(context, notificationId);
        Message message = Message.createFrom(messageBundle);
        if (message == null) {
            MobileMessagingLogger.e("Received no message in NotificationActionTapReceiver");
            return;
        }
        NotificationAction notificationAction = NotificationAction.createFrom(actionBundle);
        if (notificationAction == null) {
            MobileMessagingLogger.e("Received no action in NotificationActionTapReceiver");
            return;
        }
        NotificationCategory notificationCategory = NotificationCategory.createFrom(categoryBundle);
        if (notificationCategory == null) {
            MobileMessagingLogger.e("Received no notification category in NotificationActionTapReceiver");
            return;
        }
        String inputText = this.getInputTextFromIntent(receivedIntent, notificationAction);
        if (inputText != null) {
            notificationAction.setInputText(inputText);
        }
        Intent callbackIntent = this.broadcaster(context).notificationActionTapped(message, notificationCategory, notificationAction);
        this.mobileInteractive(context).triggerSdkActionsFor(notificationAction, message);
        if (notificationAction.bringsAppToForeground()) {
            this.activityStarterWrapper(context).startCallbackActivity(callbackIntent);
        }
    }

    private String getInputTextFromIntent(Intent intent, NotificationAction notificationAction) {
        if (notificationAction == null || !notificationAction.hasInput()) {
            return null;
        }
        Bundle input = RemoteInput.getResultsFromIntent((Intent)intent);
        if (input == null) {
            return null;
        }
        CharSequence sequence = input.getCharSequence(notificationAction.getId());
        return sequence != null ? sequence.toString() : "";
    }

    private void cancelNotification(Context context, int notificationId) {
        NotificationManager notificationManager;
        if (notificationId != -1 && (notificationManager = (NotificationManager)context.getSystemService("notification")) != null) {
            notificationManager.cancel(notificationId);
        }
    }

    private InteractiveBroadcaster broadcaster(Context context) {
        if (this.broadcaster == null) {
            this.broadcaster = new AndroidInteractiveBroadcaster(context);
        }
        return this.broadcaster;
    }

    private MobileMessagingCore mobileMessagingCore(Context context) {
        if (this.mobileMessagingCore == null) {
            this.mobileMessagingCore = MobileMessagingCore.getInstance(context);
        }
        return this.mobileMessagingCore;
    }

    private MobileInteractive mobileInteractive(Context context) {
        if (this.mobileInteractive == null) {
            this.mobileInteractive = MobileInteractiveImpl.getInstance(context);
        }
        return this.mobileInteractive;
    }

    private ActivityStarterWrapper activityStarterWrapper(Context context) {
        if (this.activityStarterWrapper == null) {
            this.activityStarterWrapper = new ActivityStarterWrapper(context, this.mobileMessagingCore(context));
        }
        return this.activityStarterWrapper;
    }
}

