/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobileapi.common;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.infobip.mobile.messaging.mobileapi.common.IMAsyncTask;
import org.infobip.mobile.messaging.mobileapi.common.MAsyncTask;
import org.infobip.mobile.messaging.mobileapi.common.MRetryPolicy;

public abstract class MRetryableTask<IN, OUT>
extends IMAsyncTask<IN, OUT> {
    private final Handler handler = new Handler(Looper.getMainLooper());
    private volatile ExecutionContext executionContext;
    private MRetryPolicy retryPolicy;

    public MRetryableTask<IN, OUT> retryWith(MRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @SafeVarargs
    public final void execute(IN ... ins) {
        this.executionContext = new ExecutionContext(null, ins, this.retryPolicy);
        this.execute();
    }

    @SafeVarargs
    public final void execute(@Nullable Executor executor, IN ... ins) {
        this.executionContext = new ExecutionContext(executor, ins, this.retryPolicy);
        this.execute();
    }

    private void execute() {
        MAsyncTask asyncTask = new MAsyncTask<IN, OUT>(){

            @Override
            public void before() {
                if (((MRetryableTask)MRetryableTask.this).executionContext.attempts > 0) {
                    return;
                }
                MRetryableTask.this.before();
            }

            @Override
            public boolean shouldCancel() {
                return MRetryableTask.this.shouldCancel();
            }

            @Override
            public OUT run(IN[] ins) {
                return MRetryableTask.this.run(ins);
            }

            @Override
            public void afterBackground(OUT out) {
                MRetryableTask.this.afterBackground(out);
            }

            @Override
            public void after(OUT out) {
                MRetryableTask.this.after(out);
            }

            @Override
            public void error(Throwable error) {
                if (!((MRetryableTask)MRetryableTask.this).executionContext.retryPolicy.shouldRetry(error, ((MRetryableTask)MRetryableTask.this).executionContext.attempts)) {
                    MRetryableTask.this.error(error);
                    MRetryableTask.this.error(((MRetryableTask)MRetryableTask.this).executionContext.args, error);
                    MRetryableTask.this.executionContext = null;
                    return;
                }
                ++((MRetryableTask)MRetryableTask.this).executionContext.attempts;
                MRetryableTask.this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        MRetryableTask.this.execute();
                    }
                }, TimeUnit.SECONDS.toMillis(((MRetryableTask)MRetryableTask.this).executionContext.attempts * ((MRetryableTask)MRetryableTask.this).executionContext.attempts * ((MRetryableTask)MRetryableTask.this).executionContext.retryPolicy.getBackoffMultiplier()));
            }

            @Override
            public void cancelled(IN[] ins) {
                MRetryableTask.this.cancelled(ins);
            }
        };
        if (this.executionContext.executor != null) {
            asyncTask.execute(this.executionContext.executor, this.executionContext.args);
        } else {
            asyncTask.execute(this.executionContext.args);
        }
    }

    private class ExecutionContext {
        final Executor executor;
        final IN[] args;
        final MRetryPolicy retryPolicy;
        int attempts;

        ExecutionContext(Executor executor, IN[] args, MRetryPolicy retryPolicy) {
            this.executor = executor;
            this.args = args;
            this.retryPolicy = retryPolicy == null ? new MRetryPolicy.Builder().build() : retryPolicy;
        }
    }
}

