/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.stats;

import android.content.Context;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.util.PreferenceHelper;

public class MobileMessagingStats {
    public static final String STATS_KEY_BASE = "org.infobip.mobile.messaging.stats.";
    private final Context context;

    public MobileMessagingStats(Context context) {
        this.context = context;
    }

    public static String getKey(MobileMessagingStatsError mobileMessagingStatsError) {
        return STATS_KEY_BASE + mobileMessagingStatsError.name();
    }

    public long getErrorCount(MobileMessagingStatsError mobileMessagingStatsError) {
        return PreferenceHelper.getDefaultMMSharedPreferences(this.context).getLong(MobileMessagingStats.getKey(mobileMessagingStatsError), 0L);
    }

    public synchronized void reportError(MobileMessagingStatsError mobileMessagingStatsError) {
        this.saveLong(mobileMessagingStatsError, this.getErrorCount(mobileMessagingStatsError) + 1L);
    }

    public void resetErrors() {
        for (MobileMessagingStatsError e : MobileMessagingStatsError.values()) {
            this.resetError(e);
        }
    }

    public synchronized void resetError(MobileMessagingStatsError mobileMessagingStatsError) {
        this.saveLong(mobileMessagingStatsError, this.getErrorCount(mobileMessagingStatsError));
    }

    private void saveLong(MobileMessagingStatsError mobileMessagingStatsError, long value) {
        PreferenceHelper.getDefaultMMSharedPreferences(this.context).edit().putLong(MobileMessagingStats.getKey(mobileMessagingStatsError), value).apply();
    }
}

