/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.storage;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.storage.MessageStoreWrapper;

public class MessageStoreWrapperImpl
implements MessageStoreWrapper {
    @NonNull
    private final Context context;
    @Nullable
    private final MessageStore messageStore;

    public MessageStoreWrapperImpl(@NonNull Context context, @Nullable MessageStore messageStore) {
        this.context = context;
        this.messageStore = messageStore;
    }

    @Override
    public void upsert(@NonNull Message message) {
        if (this.messageStore == null) {
            MobileMessagingLogger.d("Skipping save message: " + message.getMessageId());
            return;
        }
        this.messageStore.save(this.context, message);
    }

    @Override
    public void upsert(@NonNull Message[] messages) {
        if (this.messageStore == null) {
            for (Message m : messages) {
                MobileMessagingLogger.d("Skipping save message: " + m.getMessageId());
            }
            return;
        }
        this.messageStore.save(this.context, messages);
    }
}

