/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.Cryptor;
import org.infobip.mobile.messaging.util.DeviceInformation;
import org.infobip.mobile.messaging.util.StringUtils;

public abstract class PreferenceHelper {
    private static final String MM_PREFS_PREFIX = "org.infobip.mobile.messaging";
    private static final Object LOCK = new Object();
    private static Cryptor cryptor = null;
    private static Boolean usePrivateSharedPrefs = null;

    protected PreferenceHelper() {
    }

    private static Cryptor getCryptor(Context context) {
        if (cryptor != null) {
            return cryptor;
        }
        cryptor = new Cryptor(DeviceInformation.getDeviceID(context));
        return cryptor;
    }

    public static SharedPreferences getDefaultMMSharedPreferences(Context context) {
        if (usePrivateSharedPrefs == null) {
            usePrivateSharedPrefs = PreferenceHelper.shouldUsePrivateSharedPrefs(context);
        }
        if (usePrivateSharedPrefs.booleanValue()) {
            return PreferenceHelper.getPrivateMMSharedPreferences(context);
        }
        return PreferenceHelper.getPublicSharedPreferences(context);
    }

    public static SharedPreferences getPrivateMMSharedPreferences(Context context) {
        return context.getSharedPreferences("MobileMessagingSDK", 0);
    }

    public static SharedPreferences getPublicSharedPreferences(Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    public static String findString(Context context, MobileMessagingProperty property) {
        return PreferenceHelper.findString(context, property.getKey(), (String)property.getDefaultValue(), property.isEncrypted());
    }

    public static String findString(Context context, String key, String defaultValue) {
        return PreferenceHelper.findString(context, key, defaultValue, false);
    }

    public static String findString(Context context, String key, String defaultValue, boolean encrypted) {
        SharedPreferences sharedPreferences = PreferenceHelper.getDefaultMMSharedPreferences(context);
        if (!encrypted) {
            return sharedPreferences.getString(key, defaultValue);
        }
        String encryptedKey = PreferenceHelper.getCryptor(context).encrypt(key);
        String encryptedValue = sharedPreferences.getString(encryptedKey, defaultValue);
        return PreferenceHelper.getCryptor(context).decrypt(encryptedValue);
    }

    public static void saveString(Context context, MobileMessagingProperty property, String value) {
        PreferenceHelper.saveString(context, property.getKey(), value, property.isEncrypted());
    }

    public static void saveString(Context context, String key, String value, boolean encrypted) {
        if (!encrypted) {
            PreferenceHelper.saveString(context, key, value);
            return;
        }
        String encryptedKey = PreferenceHelper.getCryptor(context).encrypt(key);
        String encryptedValue = PreferenceHelper.getCryptor(context).encrypt(value);
        PreferenceHelper.saveString(context, encryptedKey, encryptedValue);
    }

    public static void saveString(Context context, String key, String value) {
        SharedPreferences sharedPreferences = PreferenceHelper.getDefaultMMSharedPreferences(context);
        if (null == value) {
            PreferenceHelper.remove(context, key);
            return;
        }
        sharedPreferences.edit().putString(key, value).apply();
    }

    public static long findLong(Context context, MobileMessagingProperty property) {
        Object defaultValue = property.getDefaultValue();
        if (null == defaultValue) {
            defaultValue = 0L;
        }
        return PreferenceHelper.findLong(context, property.getKey(), (Long)defaultValue);
    }

    public static long findLong(Context context, String key, long defaultValue) {
        SharedPreferences sharedPreferences = PreferenceHelper.getDefaultMMSharedPreferences(context);
        String string = sharedPreferences.getString(key, String.valueOf(defaultValue));
        if (StringUtils.isBlank(string)) {
            return 0L;
        }
        return Long.parseLong(string);
    }

    public static void saveLong(Context context, MobileMessagingProperty property, long value) {
        PreferenceHelper.saveLong(context, property.getKey(), value);
    }

    public static void saveLong(Context context, String key, long value) {
        SharedPreferences sharedPreferences = PreferenceHelper.getDefaultMMSharedPreferences(context);
        sharedPreferences.edit().putString(key, String.valueOf(value)).apply();
    }

    public static <T> Class<T> findClass(Context context, MobileMessagingProperty property) {
        return PreferenceHelper.findClass(context, property.getKey(), (Class)property.getDefaultValue());
    }

    public static <T> Class<T> findClass(Context context, String key, Class<T> defaultValue) {
        String callbackActivityClassName = PreferenceHelper.findString(context, key, null);
        if (StringUtils.isBlank(callbackActivityClassName)) {
            return defaultValue;
        }
        try {
            return Class.forName(callbackActivityClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void saveClass(Context context, MobileMessagingProperty property, Class<?> aClass) {
        PreferenceHelper.saveClass(context, property.getKey(), aClass);
    }

    public static void saveClass(Context context, String key, Class<?> aClass) {
        String value = aClass.getName();
        PreferenceHelper.saveString(context, key, value);
    }

    public static boolean findBoolean(Context context, MobileMessagingProperty property) {
        return PreferenceHelper.findBoolean(context, property.getKey(), Boolean.TRUE.equals(property.getDefaultValue()));
    }

    public static boolean findBoolean(Context context, String key, boolean defaultValue) {
        return PreferenceHelper.getDefaultMMSharedPreferences(context).getBoolean(key, defaultValue);
    }

    public static boolean findBoolean(Context context, String key, boolean defaultValue, boolean privatePrefs) {
        if (privatePrefs) {
            return PreferenceHelper.getPrivateMMSharedPreferences(context).getBoolean(key, defaultValue);
        }
        return PreferenceHelper.getDefaultMMSharedPreferences(context).getBoolean(key, defaultValue);
    }

    public static void saveBoolean(Context context, MobileMessagingProperty property, boolean value) {
        PreferenceHelper.saveBoolean(context, property.getKey(), value, false);
    }

    public static boolean shouldMigrateToPrivatePrefs(Context context) {
        return PreferenceHelper.shouldUsePrivateSharedPrefs(context) && PreferenceHelper.publicPrefsAreNotMigratedToPrivatePrefs(context);
    }

    private static boolean publicPrefsAreNotMigratedToPrivatePrefs(Context context) {
        return PreferenceHelper.publicPrefsContains(context, MobileMessagingProperty.APPLICATION_CODE) && PreferenceHelper.publicPrefsContains(context, MobileMessagingProperty.SENDER_ID) && !PreferenceHelper.privatePrefsContains(context, MobileMessagingProperty.APPLICATION_CODE) && !PreferenceHelper.privatePrefsContains(context, MobileMessagingProperty.SENDER_ID);
    }

    private static boolean shouldUsePrivateSharedPrefs(Context context) {
        MobileMessagingProperty property = MobileMessagingProperty.USE_PRIVATE_SHARED_PREFS;
        return PreferenceHelper.findBoolean(context, property.getKey(), Boolean.TRUE.equals(property.getDefaultValue()), true);
    }

    public static void saveUsePrivateSharedPrefs(Context context, boolean value) {
        usePrivateSharedPrefs = value;
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.USE_PRIVATE_SHARED_PREFS.getKey(), value, true);
    }

    public static void saveBoolean(Context context, String key, boolean value) {
        PreferenceHelper.saveBoolean(context, key, value, false);
    }

    public static void saveBoolean(Context context, String key, boolean value, boolean privatePrefs) {
        if (privatePrefs) {
            PreferenceHelper.getPrivateMMSharedPreferences(context).edit().putBoolean(key, value).apply();
        } else {
            PreferenceHelper.getDefaultMMSharedPreferences(context).edit().putBoolean(key, value).apply();
        }
    }

    public static int findInt(Context context, MobileMessagingProperty property) {
        Object defaultValue = property.getDefaultValue();
        int defaultInt = 0;
        if (null != defaultValue) {
            defaultInt = (Integer)defaultValue;
        }
        return PreferenceHelper.findInt(context, property.getKey(), defaultInt);
    }

    public static int findInt(Context context, String key, int defaultValue) {
        return PreferenceHelper.getDefaultMMSharedPreferences(context).getInt(key, defaultValue);
    }

    public static void saveInt(Context context, MobileMessagingProperty property, int value) {
        PreferenceHelper.saveInt(context, property.getKey(), value);
    }

    public static void saveInt(Context context, String key, int value) {
        PreferenceHelper.getDefaultMMSharedPreferences(context).edit().putInt(key, value).apply();
    }

    public static String[] findAndRemoveStringArray(Context context, MobileMessagingProperty property) {
        final ArrayList strings = new ArrayList();
        PreferenceHelper.editSet(context, property.getKey(), new SetMutator(){

            @Override
            public void mutate(Set<String> set) {
                strings.addAll(set);
                set.clear();
            }
        });
        return strings.toArray(new String[0]);
    }

    public static String[] findStringArray(Context context, MobileMessagingProperty property) {
        return PreferenceHelper.findStringArray(context, property.getKey(), (String[])property.getDefaultValue());
    }

    public static String[] findStringArray(Context context, String key, String[] defaultValue) {
        return PreferenceHelper.find(context, key, defaultValue, new SetConverter<String[]>(){

            @Override
            public String[] convert(Set<String> set) {
                return set.toArray(new String[0]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T find(Context context, String key, T defaultValue, SetConverter<T> converter) {
        Object object = LOCK;
        synchronized (object) {
            Set value = PreferenceHelper.getDefaultMMSharedPreferences(context).getStringSet(key, null);
            if (null == value) {
                return defaultValue;
            }
            return converter.convert(value);
        }
    }

    public static void appendToStringArray(Context context, MobileMessagingProperty property, String ... strings) {
        PreferenceHelper.appendToStringArray(context, property.getKey(), strings);
    }

    public static void appendToStringArray(Context context, String key, final String ... strings) {
        SetMutator mutator = new SetMutator(){

            @Override
            public void mutate(Set<String> set) {
                set.addAll(Arrays.asList(strings));
            }
        };
        PreferenceHelper.editSet(context, key, mutator);
    }

    public static void deleteFromStringArray(Context context, MobileMessagingProperty property, String ... strings) {
        PreferenceHelper.deleteFromStringArray(context, property.getKey(), strings);
    }

    public static void deleteFromStringArray(Context context, String key, final String ... strings) {
        SetMutator mutator = new SetMutator(){

            @Override
            public void mutate(Set<String> set) {
                set.removeAll(Arrays.asList(strings));
            }
        };
        PreferenceHelper.editSet(context, key, mutator);
    }

    public static void saveStringArray(Context context, MobileMessagingProperty property, String ... strings) {
        PreferenceHelper.saveStringArray(context, property.getKey(), strings);
    }

    public static void saveStringArray(Context context, String key, final String ... strings) {
        SharedPreferences sharedPreferences = PreferenceHelper.getDefaultMMSharedPreferences(context);
        HashSet<String> stringSet = new HashSet<String>(){
            {
                this.addAll(Arrays.asList(strings));
            }
        };
        sharedPreferences.edit().putStringSet(key, (Set)stringSet).apply();
    }

    public static Set<String> findStringSet(Context context, MobileMessagingProperty property) {
        return PreferenceHelper.findStringSet(context, property.getKey(), (Set)property.getDefaultValue());
    }

    public static Set<String> findStringSet(Context context, String key, Set<String> defaultValue) {
        return PreferenceHelper.find(context, key, defaultValue, new SetConverter<Set<String>>(){

            @Override
            public Set<String> convert(Set<String> set) {
                return set;
            }
        });
    }

    public static void saveStringSet(Context context, MobileMessagingProperty property, Set<String> set) {
        PreferenceHelper.saveStringSet(context, property.getKey(), set);
    }

    public static void saveStringSet(Context context, String key, final Set<String> set) {
        SetMutator mutator = new SetMutator(){

            @Override
            public void mutate(Set<String> innerSet) {
                innerSet.clear();
                innerSet.addAll(set);
            }
        };
        PreferenceHelper.editSet(context, key, mutator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editSet(Context context, String key, SetMutator mutator) {
        Object object = LOCK;
        synchronized (object) {
            SharedPreferences sharedPreferences = PreferenceHelper.getDefaultMMSharedPreferences(context);
            HashSet<String> set = new HashSet<String>(sharedPreferences.getStringSet(key, new HashSet()));
            mutator.mutate(set);
            if (set.isEmpty()) {
                PreferenceHelper.remove(context, key);
                return;
            }
            sharedPreferences.edit().putStringSet(key, set).apply();
        }
    }

    public static void remove(Context context, MobileMessagingProperty property) {
        String key = property.getKey();
        if (property.isEncrypted()) {
            key = PreferenceHelper.getCryptor(context).encrypt(key);
        }
        PreferenceHelper.remove(context, key);
    }

    public static void remove(Context context, String key) {
        PreferenceHelper.getDefaultMMSharedPreferences(context).edit().remove(key).apply();
    }

    public static boolean contains(Context context, MobileMessagingProperty property) {
        String key = property.getKey();
        if (property.isEncrypted()) {
            key = PreferenceHelper.getCryptor(context).encrypt(key);
        }
        return PreferenceHelper.contains(context, key);
    }

    public static boolean contains(Context context, String key) {
        return PreferenceHelper.getDefaultMMSharedPreferences(context).contains(key);
    }

    static boolean publicPrefsContains(Context context, MobileMessagingProperty property) {
        String key = property.getKey();
        if (property.isEncrypted()) {
            key = PreferenceHelper.getCryptor(context).encrypt(key);
        }
        return PreferenceHelper.getPublicSharedPreferences(context).contains(key);
    }

    static boolean privatePrefsContains(Context context, MobileMessagingProperty property) {
        String key = property.getKey();
        if (property.isEncrypted()) {
            key = PreferenceHelper.getCryptor(context).encrypt(key);
        }
        return PreferenceHelper.getPrivateMMSharedPreferences(context).contains(key);
    }

    public static void migrateToPrivatePrefs(Context context) {
        SharedPreferences.Editor publicPrefsEditor = PreferenceHelper.getPublicSharedPreferences(context).edit();
        SharedPreferences.Editor privatePrefsEditor = PreferenceHelper.getPrivateMMSharedPreferences(context).edit();
        Set allPublicPrefEntries = PreferenceHelper.getPublicSharedPreferences(context).getAll().entrySet();
        for (Map.Entry pref : allPublicPrefEntries) {
            String key = (String)pref.getKey();
            if (!key.startsWith(MM_PREFS_PREFIX)) continue;
            Object value = pref.getValue();
            try {
                if (value instanceof String) {
                    privatePrefsEditor.putString(key, (String)value);
                } else if (value instanceof Integer) {
                    privatePrefsEditor.putInt(key, ((Integer)value).intValue());
                } else if (value instanceof Long) {
                    privatePrefsEditor.putLong(key, ((Long)value).longValue());
                } else if (value instanceof Boolean) {
                    privatePrefsEditor.putBoolean(key, ((Boolean)value).booleanValue());
                } else if (value instanceof Float) {
                    privatePrefsEditor.putFloat(key, ((Float)value).floatValue());
                } else if (value instanceof Set) {
                    privatePrefsEditor.putStringSet(key, (Set)value);
                }
            }
            catch (Exception ignored) {
                MobileMessagingLogger.w(String.format("Failed to migrate key %s with value %s", key, value));
            }
            publicPrefsEditor.remove(key);
        }
        publicPrefsEditor.apply();
        privatePrefsEditor.apply();
        PreferenceHelper.migrateCryptedEntriesFromPublicToPrivatePrefs(context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID, MobileMessagingProperty.APPLICATION_CODE, MobileMessagingProperty.SENDER_ID, MobileMessagingProperty.CLOUD_TOKEN);
    }

    private static void migrateCryptedEntriesFromPublicToPrivatePrefs(Context context, MobileMessagingProperty ... properties) {
        for (MobileMessagingProperty property : properties) {
            String encryptedKey = PreferenceHelper.getCryptor(context).encrypt(property.getKey());
            String encryptedValue = PreferenceHelper.getPublicSharedPreferences(context).getString(encryptedKey, (String)property.getDefaultValue());
            PreferenceHelper.saveString(context, encryptedKey, encryptedValue);
        }
    }

    public static void registerOnSharedPreferenceChangeListener(Context context, SharedPreferences.OnSharedPreferenceChangeListener listener) {
        PreferenceHelper.getDefaultMMSharedPreferences(context).registerOnSharedPreferenceChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <Result> Result runTransaction(Transaction<Result> transaction) {
        Object object = LOCK;
        synchronized (object) {
            return transaction.run();
        }
    }

    public static interface Transaction<Result> {
        public Result run();
    }

    public static interface SetConverter<T> {
        public T convert(Set<String> var1);
    }

    public static interface SetMutator {
        public void mutate(Set<String> var1);
    }
}

