/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import java.util.HashMap;
import java.util.Map;
import org.infobip.mobile.messaging.CustomAttributeValue;
import org.infobip.mobile.messaging.EventPropertiesMapper;
import org.infobip.mobile.messaging.api.support.MapModel;

public class EventPropertiesHolder
extends MapModel {
    private Map<String, CustomAttributeValue> properties;

    public EventPropertiesHolder() {
    }

    public EventPropertiesHolder(Map<String, CustomAttributeValue> properties) {
        this.properties = properties;
    }

    public void setProperties(Map<String, CustomAttributeValue> properties) {
        this.properties = properties;
        this.setField("properties", properties != null ? EventPropertiesMapper.eventPropertiesToBackend(properties) : null);
    }

    public Map<String, CustomAttributeValue> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, CustomAttributeValue eventProperty) {
        if (this.properties == null) {
            this.properties = new HashMap<String, CustomAttributeValue>();
        }
        this.properties.put(key, eventProperty);
        this.setPropertyField(key, eventProperty);
    }

    public CustomAttributeValue getPropertyValue(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public void removePropertyValue(String key) {
        if (this.properties == null) {
            this.properties = new HashMap<String, CustomAttributeValue>();
        }
        this.properties.remove(key);
        this.setPropertyField(key, null);
    }

    private void setPropertyField(String key, CustomAttributeValue propertyValue) {
        HashMap<String, Object> eventProperties = (HashMap<String, Object>)this.getField("properties");
        if (eventProperties == null) {
            eventProperties = new HashMap<String, Object>();
        }
        eventProperties.put(key, EventPropertiesMapper.eventPropertyToBackend(propertyValue));
        this.setField("properties", eventProperties);
    }
}

