/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.app.Application;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.infobip.mobile.messaging.ApplicationCodeProvider;
import org.infobip.mobile.messaging.CustomAttributeValue;
import org.infobip.mobile.messaging.CustomAttributesMapper;
import org.infobip.mobile.messaging.CustomEvent;
import org.infobip.mobile.messaging.Installation;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MessageHandlerModule;
import org.infobip.mobile.messaging.MessageStoreInstantiationException;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.MobileMessagingSynchronizationReceiver;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.SuccessPending;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.User;
import org.infobip.mobile.messaging.UserAttributes;
import org.infobip.mobile.messaging.UserIdentity;
import org.infobip.mobile.messaging.UserMapper;
import org.infobip.mobile.messaging.api.appinstance.UserCustomEventBody;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.app.ContextHelper;
import org.infobip.mobile.messaging.cloud.MobileMessageHandler;
import org.infobip.mobile.messaging.cloud.MobileMessagingCloudService;
import org.infobip.mobile.messaging.cloud.PlayServicesSupport;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseHelper;
import org.infobip.mobile.messaging.dal.sqlite.PushDatabaseHelperImpl;
import org.infobip.mobile.messaging.dal.sqlite.SqliteDatabaseProvider;
import org.infobip.mobile.messaging.interactive.MobileInteractiveImpl;
import org.infobip.mobile.messaging.interactive.notification.InteractiveNotificationHandler;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobileapi.BatchReporter;
import org.infobip.mobile.messaging.mobileapi.InternalSdkError;
import org.infobip.mobile.messaging.mobileapi.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobileapi.MobileMessagingError;
import org.infobip.mobile.messaging.mobileapi.Result;
import org.infobip.mobile.messaging.mobileapi.appinstance.InstallationSynchronizer;
import org.infobip.mobile.messaging.mobileapi.common.MAsyncTask;
import org.infobip.mobile.messaging.mobileapi.common.RetryPolicyProvider;
import org.infobip.mobile.messaging.mobileapi.events.UserEventsRequestMapper;
import org.infobip.mobile.messaging.mobileapi.events.UserEventsSynchronizer;
import org.infobip.mobile.messaging.mobileapi.messages.MessagesSynchronizer;
import org.infobip.mobile.messaging.mobileapi.messages.MoMessageSender;
import org.infobip.mobile.messaging.mobileapi.seen.SeenStatusReporter;
import org.infobip.mobile.messaging.mobileapi.user.DepersonalizeActionListener;
import org.infobip.mobile.messaging.mobileapi.user.DepersonalizeServerListener;
import org.infobip.mobile.messaging.mobileapi.user.PersonalizeSynchronizer;
import org.infobip.mobile.messaging.mobileapi.user.UserDataReporter;
import org.infobip.mobile.messaging.mobileapi.version.VersionChecker;
import org.infobip.mobile.messaging.notification.NotificationHandler;
import org.infobip.mobile.messaging.platform.AndroidBroadcaster;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.platform.MobileMessagingJobService;
import org.infobip.mobile.messaging.platform.Platform;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.storage.MessageStoreWrapper;
import org.infobip.mobile.messaging.storage.MessageStoreWrapperImpl;
import org.infobip.mobile.messaging.telephony.MobileNetworkStateListener;
import org.infobip.mobile.messaging.util.ComponentUtil;
import org.infobip.mobile.messaging.util.DateTimeUtil;
import org.infobip.mobile.messaging.util.DeviceInformation;
import org.infobip.mobile.messaging.util.ExceptionUtils;
import org.infobip.mobile.messaging.util.MobileNetworkInformation;
import org.infobip.mobile.messaging.util.ModuleLoader;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.SHA1;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.StringUtils;
import org.infobip.mobile.messaging.util.SystemInformation;

public class MobileMessagingCore
extends MobileMessaging
implements DepersonalizeServerListener {
    private static final int MESSAGE_ID_PARAMETER_LIMIT = 100;
    private static final long MESSAGE_EXPIRY_TIME = TimeUnit.DAYS.toMillis(7L);
    private static final long LAZY_SYNC_THROTTLE_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final long FOREGROUND_SYNC_THROTTLE_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private static final JsonSerializer nullSerializer = new JsonSerializer(true, new JsonSerializer.ObjectAdapter[0]);
    public static final String MM_DEFAULT_HIGH_PRIORITY_CHANNEL_ID = "mm_default_channel_high_priority";
    public static final String MM_DEFAULT_CHANNEL_ID = "mm_default_channel";
    protected static MobileApiResourceProvider mobileApiResourceProvider;
    static String applicationCode;
    private static Map<String, String> applicationCodeHashMap;
    static ApplicationCodeProvider applicationCodeProvider;
    private static DatabaseHelper databaseHelper;
    private static MobileMessagingSynchronizationReceiver mobileMessagingSynchronizationReceiver;
    private final MobileMessagingStats stats;
    private final ExecutorService registrationAlignedExecutor;
    private final RetryPolicyProvider retryPolicyProvider;
    private final Broadcaster broadcaster;
    private final ModuleLoader moduleLoader;
    private final NotificationHandler notificationHandler;
    private MessagesSynchronizer messagesSynchronizer;
    private UserDataReporter userDataReporter;
    private InstallationSynchronizer installationSynchronizer;
    private PersonalizeSynchronizer personalizeSynchronizer;
    private UserEventsSynchronizer userEventsSynchronizer;
    private MoMessageSender moMessageSender;
    private SeenStatusReporter seenStatusReporter;
    private VersionChecker versionChecker;
    private ActivityLifecycleMonitor activityLifecycleMonitor;
    private MobileNetworkStateListener mobileNetworkStateListener;
    private PlayServicesSupport playServicesSupport;
    private NotificationSettings notificationSettings;
    private MessageStore messageStore;
    private MessageStoreWrapper messageStoreWrapper;
    private final Context context;
    private final Map<String, MessageHandlerModule> messageHandlerModules;
    private volatile boolean didSyncAtLeastOnce;
    private volatile Long lastSyncTimeMillis;
    private volatile Long lastForegroundSyncMillis;

    protected MobileMessagingCore(Context context) {
        this(context, new AndroidBroadcaster(context), Executors.newSingleThreadExecutor(), new ModuleLoader(context));
    }

    protected MobileMessagingCore(Context context, Broadcaster broadcaster, ExecutorService registrationAlignedExecutor, ModuleLoader moduleLoader) {
        Application application;
        MobileMessagingLogger.init(context);
        this.context = context;
        this.broadcaster = broadcaster;
        this.registrationAlignedExecutor = registrationAlignedExecutor;
        this.stats = new MobileMessagingStats(context);
        this.retryPolicyProvider = new RetryPolicyProvider(context);
        this.moduleLoader = moduleLoader;
        this.notificationHandler = new InteractiveNotificationHandler(context);
        this.messageHandlerModules = this.loadMessageHandlerModules();
        if (mobileMessagingSynchronizationReceiver == null) {
            mobileMessagingSynchronizationReceiver = new MobileMessagingSynchronizationReceiver();
        }
        if ((application = new ContextHelper(context).getApplication()) != null) {
            this.activityLifecycleMonitor = new ActivityLifecycleMonitor(application);
        }
        ComponentUtil.setSynchronizationReceiverStateEnabled(context, mobileMessagingSynchronizationReceiver, true);
        ComponentUtil.setConnectivityComponentsStateEnabled(context, true);
        this.initDefaultChannels();
        this.migratePrefsIfNecessary(context);
    }

    private void migratePrefsIfNecessary(Context context) {
        if (PreferenceHelper.shouldMigrateToPrivatePrefs(context)) {
            PreferenceHelper.migrateToPrivatePrefs(context);
        }
        if (PreferenceHelper.contains(context, MobileMessagingProperty.PERFORMED_USER_DATA_MIGRATION)) {
            return;
        }
        this.migrateUserData(MobileMessagingProperty.USER_DATA);
        this.migrateUserData(MobileMessagingProperty.UNREPORTED_USER_DATA);
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.PERFORMED_USER_DATA_MIGRATION, true);
    }

    private void migrateUserData(MobileMessagingProperty userDataProperty) {
        Map customAtts;
        if (!PreferenceHelper.contains(this.context, userDataProperty)) {
            return;
        }
        String unreportedUserData = PreferenceHelper.findString(this.context, userDataProperty);
        if (unreportedUserData == null) {
            return;
        }
        Pair<User, Map<String, CustomAttributeValue>> userDataWithCustomAtts = UserMapper.migrateToNewModels(unreportedUserData);
        if (userDataWithCustomAtts.first != null) {
            if (userDataProperty == MobileMessagingProperty.UNREPORTED_USER_DATA) {
                this.saveUnreportedUserData((User)((Object)userDataWithCustomAtts.first));
            } else if (userDataProperty == MobileMessagingProperty.USER_DATA) {
                this.storeAndMergeUnreportedUserLocally((User)((Object)userDataWithCustomAtts.first));
            }
        }
        if ((customAtts = (Map)userDataWithCustomAtts.second) != null) {
            this.saveCustomAttributes(customAtts);
            if (userDataProperty == MobileMessagingProperty.UNREPORTED_USER_DATA) {
                this.setUnreportedCustomAttributes(customAtts);
            } else if (userDataProperty == MobileMessagingProperty.USER_DATA) {
                this.saveCustomAttributes(customAtts);
            }
        }
    }

    private void initDefaultChannels() {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
        if (notificationManager == null) {
            return;
        }
        String channelName = SoftwareInformation.getAppName(this.context);
        NotificationChannel notificationChannel = new NotificationChannel(MM_DEFAULT_CHANNEL_ID, (CharSequence)channelName, 3);
        notificationChannel.enableLights(true);
        notificationChannel.enableVibration(true);
        notificationManager.createNotificationChannel(notificationChannel);
        NotificationSettings notificationSettings = this.getNotificationSettings();
        if (notificationSettings != null && notificationSettings.areHeadsUpNotificationsEnabled()) {
            NotificationChannel highPriorityNotificationChannel = new NotificationChannel(MM_DEFAULT_HIGH_PRIORITY_CHANNEL_ID, (CharSequence)(channelName + " High Priority"), 4);
            highPriorityNotificationChannel.enableLights(true);
            highPriorityNotificationChannel.enableVibration(true);
            notificationManager.createNotificationChannel(highPriorityNotificationChannel);
        }
    }

    public static MobileMessagingCore getInstance(Context context) {
        return Platform.mobileMessagingCore.get(context);
    }

    public Collection<MessageHandlerModule> getMessageHandlerModules() {
        return this.messageHandlerModules.values();
    }

    public <T extends MessageHandlerModule> T getMessageHandlerModule(Class<? extends MessageHandlerModule> cls) {
        if (this.messageHandlerModules.containsKey(cls.getName())) {
            return (T)this.messageHandlerModules.get(cls.getName());
        }
        MessageHandlerModule module = this.moduleLoader.createModule(cls);
        if (module != null) {
            module.init(this.context);
            this.messageHandlerModules.put(cls.getName(), module);
        }
        return (T)module;
    }

    private Map<String, MessageHandlerModule> loadMessageHandlerModules() {
        Map<String, MessageHandlerModule> modules = this.moduleLoader.loadModulesFromManifest(MessageHandlerModule.class);
        modules.put(MobileInteractiveImpl.class.getName(), new MobileInteractiveImpl());
        for (MessageHandlerModule module : modules.values()) {
            module.init(this.context);
        }
        return modules;
    }

    public static DatabaseHelper getDatabaseHelper(Context context) {
        if (null == databaseHelper) {
            databaseHelper = new PushDatabaseHelperImpl(context.getApplicationContext());
        }
        return databaseHelper;
    }

    public static SqliteDatabaseProvider getDatabaseProvider(Context context) {
        return (SqliteDatabaseProvider)((Object)MobileMessagingCore.getDatabaseHelper(context));
    }

    @Nullable
    public ActivityLifecycleMonitor getActivityLifecycleMonitor() {
        return this.activityLifecycleMonitor;
    }

    public void sync() {
        this.sync(true, false);
    }

    public void lazySync() {
        this.sync(false, false);
    }

    public void foregroundSync() {
        this.sync(false, true);
    }

    private void sync(boolean required, boolean foreground) {
        this.didSyncAtLeastOnce = true;
        if (!required && (this.didSyncRecently() || foreground && this.didSyncInForegroundRecently())) {
            return;
        }
        if (!MobileNetworkInformation.isNetworkAvailableSafely(this.context)) {
            this.registerForNetworkAvailability();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)MobileMessagingCore.getApplicationCode(this.context))) {
            MobileMessagingLogger.w("Application code is not found, check your setup");
            return;
        }
        this.lastSyncTimeMillis = Time.now();
        if (foreground) {
            this.lastForegroundSyncMillis = this.lastSyncTimeMillis;
            this.userEventsSynchronizer().reportSessions();
            this.performSyncActions();
            this.versionChecker().sync();
            return;
        }
        this.performSyncActions();
    }

    private boolean didSyncRecently() {
        return this.lastSyncTimeMillis != null && Time.now() - this.lastSyncTimeMillis < LAZY_SYNC_THROTTLE_INTERVAL_MILLIS;
    }

    private boolean didSyncInForegroundRecently() {
        return this.lastForegroundSyncMillis != null && Time.now() - this.lastForegroundSyncMillis < FOREGROUND_SYNC_THROTTLE_INTERVAL_MILLIS;
    }

    public void retrySyncOnNetworkAvailable() {
        if (!this.didSyncAtLeastOnce) {
            return;
        }
        if (this.didSyncRecently()) {
            return;
        }
        MobileMessagingLogger.d(">>> Retry sync on network available");
        this.performSyncActions();
    }

    private void performSyncActions() {
        this.depersonalizeOnServerIfNeeded();
        this.syncInstallation();
        if (this.isDepersonalizeInProgress()) {
            return;
        }
        for (MessageHandlerModule module : this.messageHandlerModules.values()) {
            module.performSyncActions();
        }
        if (this.shouldRepersonalize().booleanValue()) {
            this.personalizeSynchronizer().repersonalize();
        } else {
            this.userDataReporter().patch(null, this.getUnreportedUserData());
        }
        this.messagesSynchronizer().sync();
        this.moMessageSender().sync();
        this.seenStatusReporter().sync();
    }

    protected void syncInstallation() {
        this.installationSynchronizer().sync();
    }

    public Boolean getUnreportedPrimarySetting() {
        return PreferenceHelper.runTransaction(new PreferenceHelper.Transaction<Boolean>(){

            @Override
            public Boolean run() {
                if (PreferenceHelper.contains(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED)) {
                    return PreferenceHelper.findBoolean(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED);
                }
                return null;
            }
        });
    }

    public void setUnreportedPrimarySetting() {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED, true);
    }

    public boolean isRegistrationAvailable() {
        if (StringUtils.isBlank(this.getPushRegistrationId())) {
            MobileMessagingLogger.w("Registration is not available yet");
            return false;
        }
        return true;
    }

    private void depersonalizeOnServerIfNeeded() {
        if (!this.isRegistrationAvailable()) {
            return;
        }
        if (!this.isDepersonalizeInProgress()) {
            return;
        }
        this.personalizeSynchronizer().depersonalize();
    }

    @Override
    public void onServerDepersonalizeStarted() {
        this.onDepersonalizeStarted(this.getPushRegistrationId());
    }

    @Override
    public void onServerDepersonalizeCompleted() {
        this.onDepersonalizeCompleted();
    }

    @Override
    public void onServerDepersonalizeFailed(Throwable error) {
        MobileMessagingLogger.w("Server depersonalize failed", error);
    }

    private void onDepersonalizeCompleted() {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.IS_DEPERSONALIZE_UNREPORTED, false);
        this.broadcaster.depersonalized();
        this.resetCloudToken(true);
    }

    private void onDepersonalizeStarted(String pushRegId) {
        if (pushRegId == null) {
            return;
        }
        if (pushRegId.equals(this.getPushRegistrationId())) {
            this.depersonalizeCurrentInstallation(false);
            return;
        }
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.IS_DEPERSONALIZE_UNREPORTED, true);
    }

    private void depersonalizeCurrentInstallation(boolean forceDepersonalize) {
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA);
        PreferenceHelper.remove(this.context, MobileMessagingProperty.USER_DATA);
        PreferenceHelper.remove(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
        PreferenceHelper.remove(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
        PreferenceHelper.remove(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS);
        PreferenceHelper.remove(this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED);
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNSENT_MO_MESSAGES);
        PreferenceHelper.remove(this.context, MobileMessagingProperty.CUSTOM_ATTRIBUTES);
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_CUSTOM_ATTRIBUTES);
        PreferenceHelper.remove(this.context, MobileMessagingProperty.APP_USER_ID);
        PreferenceHelper.remove(this.context, MobileMessagingProperty.IS_APP_USER_ID_UNREPORTED);
        if (!forceDepersonalize) {
            PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.IS_DEPERSONALIZE_UNREPORTED, true);
        }
        if (this.messageStore != null) {
            this.messageStore.deleteAll(this.context);
        }
        this.getNotificationHandler().cancelAllNotifications();
        for (MessageHandlerModule module : this.messageHandlerModules.values()) {
            module.depersonalize();
        }
    }

    public boolean isDepersonalizeInProgress() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.IS_DEPERSONALIZE_UNREPORTED);
    }

    private void registerForNetworkAvailability() {
        if (Build.VERSION.SDK_INT >= 24) {
            MobileMessagingJobService.registerJobForConnectivityUpdates(this.context);
        }
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    public String getPushRegistrationId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID);
    }

    public void savePrimarySetting(boolean isPrimary) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.IS_PRIMARY, isPrimary);
    }

    @Override
    public void setInstallationAsPrimary(@NonNull String pushRegistrationId, boolean isPrimary) {
        this.setInstallationAsPrimary(pushRegistrationId, isPrimary, null);
    }

    @Override
    public void setInstallationAsPrimary(final @NonNull String pushRegistrationId, final boolean isPrimary, final MobileMessaging.ResultListener<List<Installation>> listener) {
        this.installationSynchronizer().updatePrimaryStatus(pushRegistrationId, isPrimary, new MobileMessaging.ResultListener<Installation>(){

            @Override
            public void onResult(Result<Installation, MobileMessagingError> result) {
                if (!result.isSuccess()) {
                    if (listener != null) {
                        listener.onResult(new Result(result.getError()));
                    }
                    return;
                }
                List installationsToReturn = MobileMessagingCore.this.performLocalSettingOfPrimary(pushRegistrationId, isPrimary);
                if (listener != null) {
                    listener.onResult(new Result(installationsToReturn));
                }
            }
        });
    }

    private List<Installation> performLocalSettingOfPrimary(String pushRegId, boolean isPrimary) {
        User user = this.getUser();
        if (user == null) {
            return null;
        }
        List<Installation> installations = user.getInstallations();
        if (installations != null && !installations.isEmpty()) {
            ArrayList<Installation> installationsTemp = new ArrayList<Installation>();
            for (Installation installation : installations) {
                if (pushRegId.equals(installation.getPushRegistrationId())) {
                    installation.setPrimaryDevice(isPrimary);
                } else if (installation.isPrimaryDevice().booleanValue()) {
                    installation.setPrimaryDevice(false);
                }
                installationsTemp.add(installation);
            }
            user.setInstallations(installationsTemp);
            this.saveUserDataToPrefs(user);
        }
        return user.getInstallations();
    }

    public void saveCustomAttributes(Map<String, CustomAttributeValue> customAttributes) {
        if (customAttributes == null) {
            customAttributes = new HashMap<String, CustomAttributeValue>();
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.CUSTOM_ATTRIBUTES, nullSerializer.serialize(customAttributes));
    }

    public String getCustomAttributes() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.CUSTOM_ATTRIBUTES);
    }

    public void setUnreportedCustomAttributes(Map<String, CustomAttributeValue> customAttributes) {
        if (customAttributes == null) {
            customAttributes = new HashMap<String, CustomAttributeValue>();
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.UNREPORTED_CUSTOM_ATTRIBUTES, nullSerializer.serialize(customAttributes));
    }

    private String getUnreportedCustomAttributes() {
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.UNREPORTED_CUSTOM_ATTRIBUTES)) {
            return PreferenceHelper.findString(this.context, MobileMessagingProperty.UNREPORTED_CUSTOM_ATTRIBUTES);
        }
        return null;
    }

    public Map<String, CustomAttributeValue> getMergedUnreportedAndReportedCustomAtts() {
        String unreportedCustomAttributes = this.getUnreportedCustomAttributes();
        String reportedCustomAtts = this.getCustomAttributes();
        Map<String, CustomAttributeValue> unreportedCustomAttsMap = CustomAttributesMapper.customAttsFrom(unreportedCustomAttributes);
        Map<String, CustomAttributeValue> customAttsMap = CustomAttributesMapper.customAttsFrom(reportedCustomAtts);
        if (customAttsMap == null) {
            customAttsMap = new HashMap<String, CustomAttributeValue>();
        }
        if (unreportedCustomAttsMap != null) {
            customAttsMap.putAll(unreportedCustomAttsMap);
        }
        return customAttsMap;
    }

    private boolean isPrimaryDevice() {
        return PreferenceHelper.runTransaction(new PreferenceHelper.Transaction<Boolean>(){

            @Override
            public Boolean run() {
                if (PreferenceHelper.contains(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED)) {
                    return PreferenceHelper.findBoolean(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED);
                }
                return PreferenceHelper.findBoolean(MobileMessagingCore.this.context, MobileMessagingProperty.IS_PRIMARY);
            }
        });
    }

    private void saveApplicationUserId(String applicationUserId) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.APP_USER_ID, applicationUserId);
    }

    public String getApplicationUserId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.APP_USER_ID);
    }

    public void setApplicationUserIdReported(boolean reported) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.IS_APP_USER_ID_UNREPORTED, !reported);
    }

    public Boolean isApplicationUserIdReported() {
        return !PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.IS_APP_USER_ID_UNREPORTED);
    }

    public void setShouldRepersonalize(boolean shouldRepersonalize) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.SHOULD_REPERSONALIZE, shouldRepersonalize);
    }

    public Boolean shouldRepersonalize() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.SHOULD_REPERSONALIZE);
    }

    private void reportErrorDepersonalizeInProgress(final MobileMessaging.ResultListener listener) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    listener.onResult(new Result(InternalSdkError.DEPERSONALIZATION_IN_PROGRESS.getError()));
                }
            }
        });
    }

    public void setPushRegistrationEnabled(Boolean pushRegistrationEnabled) {
        if (pushRegistrationEnabled != null) {
            PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED, (boolean)pushRegistrationEnabled);
        }
    }

    public boolean isPushRegistrationEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED);
    }

    public boolean isPushRegistrationEnabledUnreported() {
        return PreferenceHelper.contains(this.context, MobileMessagingProperty.UNREPORTED_PUSH_REGISTRATION_ENABLED) && PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.UNREPORTED_PUSH_REGISTRATION_ENABLED);
    }

    public void setPushRegistrationEnabledReported(boolean reported) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.UNREPORTED_PUSH_REGISTRATION_ENABLED, !reported);
    }

    public String getCloudToken() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.CLOUD_TOKEN);
    }

    public void setCloudToken(String registrationId) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.CLOUD_TOKEN, registrationId);
        this.setCloudTokenUnreported();
    }

    public String[] getAndRemoveUnreportedMessageIds() {
        return PreferenceHelper.findAndRemoveStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
    }

    public void addUnreportedMessageIds(String ... messageIDs) {
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS, messageIDs);
    }

    public void addSyncMessagesIds(String ... messageIDs) {
        String[] timestampMessageIdPair = this.concatTimestampToMessageId(messageIDs);
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS, timestampMessageIdPair);
    }

    public String[] getSyncMessagesIds() {
        String[] messageIds = PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS);
        ArrayList<String> messageIdsArrayList = new ArrayList<String>(Arrays.asList(messageIds));
        HashSet<String> messageIdsToSync = new HashSet<String>(messageIdsArrayList.size() <= 100 ? messageIdsArrayList.size() : 100);
        boolean shouldUpdateMessageIds = false;
        for (int i = 0; i < messageIdsArrayList.size(); ++i) {
            String syncMessage = messageIdsArrayList.get(i);
            String[] messageIdWithTimestamp = syncMessage.split(", ");
            String strTimeMessageReceived = messageIdWithTimestamp[1];
            long timeMessageReceived = Long.valueOf(strTimeMessageReceived);
            long timeInterval = Time.now() - timeMessageReceived;
            if (timeInterval > MESSAGE_EXPIRY_TIME || i >= 100) {
                messageIdsArrayList.remove(i);
                shouldUpdateMessageIds = true;
                --i;
                continue;
            }
            messageIdsToSync.add(messageIdWithTimestamp[0]);
        }
        if (shouldUpdateMessageIds) {
            String[] messageIdsToUpdate = new String[messageIdsArrayList.size()];
            messageIdsToUpdate = messageIdsArrayList.toArray(messageIdsToUpdate);
            PreferenceHelper.remove(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS);
            PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS, messageIdsToUpdate);
        }
        return messageIdsToSync.toArray(new String[0]);
    }

    public boolean isMessageAlreadyProcessed(String messageId) {
        return Arrays.asList(this.getSyncMessagesIds()).contains(messageId);
    }

    public String[] getUnreportedSeenMessageIds() {
        String[] ids = PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
        return this.filterOutGeneratedMessageIds(ids);
    }

    public void updateUnreportedSeenMessageIds(final Map<String, String> messageIdMap) {
        if (messageIdMap == null || messageIdMap.isEmpty()) {
            return;
        }
        PreferenceHelper.runTransaction(new PreferenceHelper.Transaction<Void>(){

            @Override
            public Void run() {
                String[] reports = PreferenceHelper.findStringArray(MobileMessagingCore.this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
                if (reports.length == 0) {
                    return null;
                }
                for (int i = 0; i < reports.length; ++i) {
                    String[] messageIdAndTimestamp = reports[i].split(", ");
                    String newMessageId = (String)messageIdMap.get(messageIdAndTimestamp[0]);
                    if (newMessageId == null) continue;
                    reports[i] = StringUtils.concat(newMessageId, messageIdAndTimestamp[1], ", ");
                }
                PreferenceHelper.saveStringArray(MobileMessagingCore.this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, reports);
                return null;
            }
        });
    }

    public void updateGeneratedMessageIds(final Map<String, String> messageIdMap) {
        if (messageIdMap == null || messageIdMap.isEmpty()) {
            return;
        }
        PreferenceHelper.runTransaction(new PreferenceHelper.Transaction<Void>(){

            @Override
            public Void run() {
                String[] generatedMessageIds;
                for (String messageId : generatedMessageIds = MobileMessagingCore.this.getGeneratedMessageIds()) {
                    if (messageIdMap.get(messageId) == null) continue;
                    MobileMessagingCore.this.removeGeneratedMessageIds(new String[]{messageId});
                }
                return null;
            }
        });
    }

    public void addGeneratedMessageIds(String ... messageIDs) {
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_GENERATED_MESSAGE_IDS, messageIDs);
    }

    private String[] getGeneratedMessageIds() {
        return PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_GENERATED_MESSAGE_IDS);
    }

    private void removeGeneratedMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_GENERATED_MESSAGE_IDS, messageIDs);
    }

    private void addUnreportedSeenMessageIds(String ... messageIDs) {
        String[] seenMessages = this.concatTimestampToMessageId(messageIDs);
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, seenMessages);
    }

    private String[] concatTimestampToMessageId(String[] messageIDs) {
        ArrayList<String> syncMessages = new ArrayList<String>(messageIDs.length);
        if (messageIDs.length > 0) {
            for (String messageId : messageIDs) {
                if (messageId == null) continue;
                String seenTimestamp = String.valueOf(Time.now());
                syncMessages.add(StringUtils.concat(messageId, seenTimestamp, ", "));
            }
        }
        return syncMessages.toArray(new String[0]);
    }

    public String[] filterOutGeneratedMessageIds(String[] messageIDs) {
        List<String> generatedMessageIDs = Arrays.asList(this.getGeneratedMessageIds());
        if (generatedMessageIDs.size() == 0 && messageIDs.length == 0) {
            return messageIDs;
        }
        List<String> seenIds = this.getSeenMessageIdsFromReports(messageIDs);
        ArrayList<String> seenIdsToRemove = new ArrayList<String>();
        for (String seenMsgId : seenIds) {
            if (!generatedMessageIDs.contains(seenMsgId) && !this.isInUuidFormat(seenMsgId)) continue;
            seenIdsToRemove.add(seenMsgId);
        }
        ArrayList<String> filteredSeenReports = new ArrayList<String>(Arrays.asList(messageIDs));
        for (String seenReport : messageIDs) {
            String seenMessageIdFromReport = this.getSeenMessageIdFromReport(seenReport);
            if (seenMessageIdFromReport == null || !seenIdsToRemove.contains(seenMessageIdFromReport)) continue;
            filteredSeenReports.remove(seenReport);
        }
        return filteredSeenReports.toArray(new String[0]);
    }

    private boolean isInUuidFormat(String msgIdToReport) {
        Pattern p = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$");
        return p.matcher(msgIdToReport).matches();
    }

    public List<String> getSeenMessageIdsFromReports(String[] reports) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String report : reports) {
            ids.add(this.getSeenMessageIdFromReport(report));
        }
        return ids;
    }

    private String getSeenMessageIdFromReport(String report) {
        String[] reportContents = report.split(", ");
        return reportContents.length > 0 ? reportContents[0] : null;
    }

    public void removeUnreportedSeenMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, messageIDs);
    }

    @Override
    public void setMessagesDelivered(String ... messageIds) {
        if (messageIds != null) {
            this.addUnreportedMessageIds(messageIds);
            this.addSyncMessagesIds(messageIds);
            this.sync();
        }
    }

    @Override
    public void setMessagesSeen(String ... messageIds) {
        if (messageIds != null) {
            this.addUnreportedSeenMessageIds(messageIds);
            this.updateStoredMessagesWithSeenStatus(messageIds);
            this.lazySync();
        }
    }

    public void setMessagesSeenDontStore(String ... messageIds) {
        if (messageIds != null) {
            this.addUnreportedSeenMessageIds(messageIds);
            this.lazySync();
        }
    }

    private void updateStoredMessagesWithSeenStatus(String[] messageIds) {
        if (!this.isMessageStoreEnabled()) {
            return;
        }
        MessageStore messageStore = this.getMessageStore();
        List<String> messageIdList = Arrays.asList(messageIds);
        for (Message m : new ArrayList<Message>(messageStore.findAll(this.context))) {
            if (!messageIdList.contains(m.getMessageId())) continue;
            m.setSeenTimestamp(Time.now());
            messageStore.save(this.context, m);
        }
    }

    @Nullable
    public NotificationSettings getNotificationSettings() {
        if (!this.isDisplayNotificationEnabled()) {
            return null;
        }
        if (null != this.notificationSettings) {
            return this.notificationSettings;
        }
        this.notificationSettings = new NotificationSettings(this.context);
        return this.notificationSettings;
    }

    private void setNotificationSettings(NotificationSettings notificationSettings) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED, null != notificationSettings);
        this.notificationSettings = notificationSettings;
    }

    private boolean isDisplayNotificationEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED);
    }

    static void setSenderId(Context context, String senderId) {
        if (StringUtils.isBlank(senderId)) {
            throw new IllegalArgumentException("senderId is mandatory! Get one here: https://github.com/infobip/mobile-messaging-sdk-android/wiki/Firebase-Cloud-Messaging");
        }
        PreferenceHelper.saveString(context, MobileMessagingProperty.SENDER_ID, senderId);
    }

    public static String getSenderId(Context context) {
        return PreferenceHelper.findString(context, MobileMessagingProperty.SENDER_ID);
    }

    public boolean isRegistrationIdReported() {
        return this.installationSynchronizer().isCloudTokenReported();
    }

    public boolean isPushServiceTypeChanged() {
        String reportedPushServiceType = this.getReportedPushServiceType();
        return StringUtils.isBlank(reportedPushServiceType) || !Platform.usedPushServiceType.name().equals(reportedPushServiceType);
    }

    private String getReportedPushServiceType() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.REPORTED_PUSH_SERVICE_TYPE);
    }

    public void setReportedPushServiceType() {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.REPORTED_PUSH_SERVICE_TYPE, Platform.usedPushServiceType.name());
    }

    public void setCloudTokenUnreported() {
        this.installationSynchronizer().setCloudTokenReported(false);
    }

    public static void setMessageStoreClass(Context context, Class<? extends MessageStore> messageStoreClass) {
        String value = null != messageStoreClass ? messageStoreClass.getName() : null;
        PreferenceHelper.saveString(context, MobileMessagingProperty.MESSAGE_STORE_CLASS, value);
    }

    @Override
    public MessageStore getMessageStore() {
        if (!this.isMessageStoreEnabled()) {
            return null;
        }
        if (null != this.messageStore) {
            return this.messageStore;
        }
        Class<? extends MessageStore> messageStoreClass = null;
        try {
            messageStoreClass = this.getMessageStoreClass();
            this.messageStore = messageStoreClass.newInstance();
            return this.messageStore;
        }
        catch (Exception e) {
            throw new MessageStoreInstantiationException("Can't create message store of type: " + messageStoreClass, e);
        }
    }

    @Override
    public Installation getInstallation() {
        return this.getInstallation(false);
    }

    public Installation getInstallation(boolean restrictData) {
        boolean reportEnabled = false;
        if (restrictData) {
            reportEnabled = PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.REPORT_SYSTEM_INFO);
        }
        HashMap<String, CustomAttributeValue> customAttsMap = new HashMap();
        String customAttributes = this.getCustomAttributes();
        if (customAttributes != null) {
            customAttsMap = CustomAttributesMapper.customAttsFrom(customAttributes);
        }
        return new Installation(this.getPushRegistrationId(), this.isPushRegistrationEnabled(), SoftwareInformation.areNotificationsEnabled(this.context), this.isGeofencingActivated(), SoftwareInformation.getSDKVersion(), reportEnabled ? SoftwareInformation.getAppVersion(this.context) : "", "Android", reportEnabled ? SystemInformation.getAndroidSystemVersion() : "", reportEnabled ? DeviceInformation.getDeviceManufacturer() : "", reportEnabled ? DeviceInformation.getDeviceModel() : "", reportEnabled && DeviceInformation.isDeviceSecure(this.context), reportEnabled ? SystemInformation.getAndroidSystemLanguage() : "", reportEnabled ? DeviceInformation.getDeviceTimeZoneOffset() : "", this.getApplicationUserId(), reportEnabled ? DeviceInformation.getDeviceModel() : "", this.isPrimaryDevice(), Platform.usedPushServiceType, this.getCloudToken(), customAttsMap);
    }

    @Override
    public void fetchInstallation(MobileMessaging.ResultListener<Installation> listener) {
        this.installationSynchronizer().fetchInstance(listener);
    }

    @Override
    public void saveInstallation(@NonNull Installation installation) {
        this.saveInstallation(installation, null);
    }

    @Override
    public void saveInstallation(@NonNull Installation installation, MobileMessaging.ResultListener<Installation> listener) {
        boolean isMyInstallation = this.isMyInstallation(installation);
        if (isMyInstallation) {
            if (installation.containsField("regEnabled")) {
                PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED, (boolean)installation.isPushRegistrationEnabled());
                PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.UNREPORTED_PUSH_REGISTRATION_ENABLED, true);
            }
            if (installation.containsField("customAttributes")) {
                this.setUnreportedCustomAttributes(installation.getCustomAttributes());
            }
            if (installation.containsField("isPrimary")) {
                PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.IS_PRIMARY, (boolean)installation.isPrimaryDevice());
                PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED, true);
            }
            if (installation.containsField("applicationUserId")) {
                this.setApplicationUserIdReported(false);
                this.saveApplicationUserId(installation.getApplicationUserId());
            }
        }
        if (this.isDepersonalizeInProgress()) {
            this.reportErrorDepersonalizeInProgress(listener);
            return;
        }
        this.installationSynchronizer().patch(installation, listener, isMyInstallation);
    }

    private boolean isMyInstallation(Installation installation) {
        String myPushRegId = this.getPushRegistrationId();
        return installation.getPushRegistrationId() == null || myPushRegId != null && myPushRegId.equals(installation.getPushRegistrationId());
    }

    protected Class<? extends MessageStore> getMessageStoreClass() {
        return PreferenceHelper.findClass(this.context, MobileMessagingProperty.MESSAGE_STORE_CLASS);
    }

    public boolean isMessageStoreEnabled() {
        return null != this.getMessageStoreClass();
    }

    public MessageStoreWrapper getMessageStoreWrapper() {
        if (this.messageStoreWrapper == null) {
            this.messageStoreWrapper = new MessageStoreWrapperImpl(this.context, this.getMessageStore());
        }
        return this.messageStoreWrapper;
    }

    public MobileMessagingStats getStats() {
        return this.stats;
    }

    public void setLastHttpException(Throwable lastHttpException) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.LAST_HTTP_EXCEPTION, ExceptionUtils.stacktrace(lastHttpException));
    }

    public String getLastHttpException() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.LAST_HTTP_EXCEPTION);
    }

    private void setApplicationCode(String applicationCode) {
        if (MobileMessagingCore.shouldSaveApplicationCode(this.context)) {
            if (StringUtils.isBlank(applicationCode)) {
                throw new IllegalArgumentException("applicationCode is mandatory! Get one here: https://portal.infobip.com/push/applications");
            }
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.APPLICATION_CODE, applicationCode);
            return;
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.APPLICATION_CODE, "");
    }

    static String getApplicationCodeFromResources(Context context) {
        int resource = ResourceLoader.loadResourceByName(context, "string", "infobip_application_code");
        if (resource > 0) {
            return context.getResources().getString(resource);
        }
        return null;
    }

    public static String getApplicationCode(Context context) {
        if (applicationCode != null) {
            return applicationCode;
        }
        if (MobileMessagingCore.shouldSaveApplicationCode(context) && (applicationCode = MobileMessagingCore.getStoredApplicationCode(context)) != null) {
            return applicationCode;
        }
        if (applicationCodeProvider != null) {
            applicationCode = applicationCodeProvider.resolve();
            return applicationCode;
        }
        String appCodeProviderCanonicalClassName = MobileMessagingCore.getApplicationCodeProviderClassName(context);
        try {
            if (StringUtils.isNotBlank(appCodeProviderCanonicalClassName)) {
                Class<?> c = Class.forName(appCodeProviderCanonicalClassName);
                Object applicationCodeProvider = c.newInstance();
                Method resolve = ApplicationCodeProvider.class.getMethod("resolve", new Class[0]);
                applicationCode = String.valueOf(resolve.invoke(applicationCodeProvider, new Object[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (applicationCode == null) {
            applicationCode = MobileMessagingCore.getApplicationCodeFromResources(context);
        }
        return applicationCode;
    }

    private static String getStoredApplicationCode(Context context) {
        return PreferenceHelper.findString(context, MobileMessagingProperty.APPLICATION_CODE);
    }

    public String getApplicationCode() {
        return MobileMessagingCore.getApplicationCode(this.context);
    }

    public static String getApplicationCodeHash(Context context) {
        return MobileMessagingCore.getApplicationCodeHash(MobileMessagingCore.getApplicationCode(context));
    }

    public static String getApplicationCodeHash(String applicationCode) {
        if (StringUtils.isBlank(applicationCode)) {
            return null;
        }
        if (applicationCodeHashMap != null && applicationCodeHashMap.containsKey(applicationCode)) {
            return applicationCodeHashMap.get(applicationCode);
        }
        String appCodeHash = SHA1.calc(applicationCode).substring(0, 10);
        applicationCodeHashMap = Collections.singletonMap(applicationCode, appCodeHash);
        return appCodeHash;
    }

    public static void setApiUri(Context context, String apiUri) {
        if (StringUtils.isBlank(apiUri)) {
            throw new IllegalArgumentException("apiUri is mandatory! If in doubt, use " + MobileMessagingProperty.API_URI.getDefaultValue());
        }
        PreferenceHelper.saveString(context, MobileMessagingProperty.API_URI, apiUri);
    }

    public static void resetApiUri(Context context) {
        PreferenceHelper.saveString(context, MobileMessagingProperty.API_URI, (String)MobileMessagingProperty.API_URI.getDefaultValue());
    }

    public static String getApiUri(Context context) {
        return PreferenceHelper.findString(context, MobileMessagingProperty.API_URI);
    }

    static void setReportCarrierInfo(Context context, boolean reportCarrierInfo) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.REPORT_CARRIER_INFO, reportCarrierInfo);
    }

    static void setReportSystemInfo(Context context, boolean reportSystemInfo) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.REPORT_SYSTEM_INFO, reportSystemInfo);
    }

    static void setDoMarkSeenOnNotificationTap(Context context, boolean doMarkSeenOnNotificationTap) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.MARK_SEEN_ON_NOTIFICATION_TAP, doMarkSeenOnNotificationTap);
    }

    public static void setShouldSaveUserData(Context context, boolean shouldSaveUserData) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.SAVE_USER_DATA_ON_DISK, shouldSaveUserData);
    }

    public boolean shouldSaveUserData() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.SAVE_USER_DATA_ON_DISK.getKey(), true);
    }

    public static void setShouldSaveAppCode(Context context, boolean shouldSaveAppCode) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.SAVE_APP_CODE_ON_DISK, shouldSaveAppCode);
    }

    public static void setAllowUntrustedSSLOnError(Context context, boolean allowUntrustedSSLOnError) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.ALLOW_UNTRUSTED_SSL_ON_ERROR, allowUntrustedSSLOnError);
    }

    public static void setSharedPrefsStorage(Context context, boolean usePrivateSharedPrefs) {
        PreferenceHelper.saveUsePrivateSharedPrefs(context, usePrivateSharedPrefs);
    }

    static boolean shouldSaveApplicationCode(Context context) {
        return PreferenceHelper.findBoolean(context, MobileMessagingProperty.SAVE_APP_CODE_ON_DISK.getKey(), true);
    }

    @Override
    public void cleanup() {
        MobileMessagingCore.cleanup(this.context);
    }

    private static void cleanup(Context context) {
        for (MessageHandlerModule module : Platform.mobileMessagingCore.get((Context)context).messageHandlerModules.values()) {
            module.cleanup();
        }
        applicationCode = null;
        if (mobileMessagingSynchronizationReceiver != null) {
            ComponentUtil.setSynchronizationReceiverStateEnabled(context, mobileMessagingSynchronizationReceiver, false);
            mobileMessagingSynchronizationReceiver = null;
        }
        ComponentUtil.setConnectivityComponentsStateEnabled(context, false);
        MobileMessagingCore.resetMobileApi();
        String senderID = PreferenceHelper.findString(context, MobileMessagingProperty.SENDER_ID);
        MobileMessagingCloudService.enqueueTokenCleanup(context, senderID);
        PreferenceHelper.remove(context, MobileMessagingProperty.CLOUD_TOKEN);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID);
        PreferenceHelper.remove(context, MobileMessagingProperty.REPORTED_PUSH_SERVICE_TYPE);
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.CLOUD_TOKEN_REPORTED, false);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_USER_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.USER_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH);
        PreferenceHelper.remove(context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNSENT_MO_MESSAGES);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS);
        PreferenceHelper.remove(context, MobileMessagingProperty.CUSTOM_ATTRIBUTES);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_CUSTOM_ATTRIBUTES);
        PreferenceHelper.remove(context, MobileMessagingProperty.APP_USER_ID);
        PreferenceHelper.remove(context, MobileMessagingProperty.IS_APP_USER_ID_UNREPORTED);
        PreferenceHelper.remove(context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_PUSH_REGISTRATION_ENABLED);
        PreferenceHelper.remove(context, MobileMessagingProperty.IS_DEPERSONALIZE_UNREPORTED);
    }

    public void resetCloudToken(boolean force) {
        String senderID = PreferenceHelper.findString(this.context, MobileMessagingProperty.SENDER_ID);
        if (force || !this.didSyncRecently()) {
            MobileMessagingCloudService.enqueueTokenReset(this.context, senderID);
        }
    }

    public static void resetMobileApi() {
        mobileApiResourceProvider = null;
    }

    @Override
    public void saveUser(@NonNull User user) {
        this.saveUser(user, null);
    }

    @Override
    public void saveUser(@NonNull User user, MobileMessaging.ResultListener<User> listener) {
        User userToReport = this.storeAndMergeUnreportedUserLocally(user);
        if (this.isDepersonalizeInProgress()) {
            this.reportErrorDepersonalizeInProgress(listener);
            return;
        }
        this.userDataReporter().patch(listener, userToReport);
    }

    private User storeAndMergeUnreportedUserLocally(User user) {
        User existingData = this.getUnreportedUserData();
        User userToReport = UserMapper.merge(existingData, user);
        if (userToReport != null) {
            this.saveUnreportedUserData(userToReport);
        }
        return userToReport;
    }

    @Override
    public void fetchUser(@NonNull MobileMessaging.ResultListener<User> listener) {
        if (this.isDepersonalizeInProgress()) {
            this.reportErrorDepersonalizeInProgress(listener);
            return;
        }
        this.userDataReporter().fetch(listener);
    }

    @Override
    @Nullable
    public User getUser() {
        User existing = null;
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.USER_DATA)) {
            existing = UserMapper.fromJson(PreferenceHelper.findString(this.context, MobileMessagingProperty.USER_DATA));
            if (this.areInstallationsExpired() && existing != null) {
                existing.setInstallations(null);
            }
        }
        return UserMapper.merge(existing, this.getUnreportedUserData());
    }

    @Override
    public void personalize(@NonNull UserIdentity userIdentity, @Nullable UserAttributes userAttributes) {
        this.personalize(userIdentity, userAttributes, false, null);
    }

    @Override
    public void personalize(@NonNull UserIdentity userIdentity, @Nullable UserAttributes userAttributes, boolean forceDepersonalize) {
        this.personalize(userIdentity, userAttributes, forceDepersonalize, null);
    }

    @Override
    public void personalize(@NonNull UserIdentity userIdentity, @Nullable UserAttributes userAttributes, MobileMessaging.ResultListener<User> listener) {
        this.personalize(userIdentity, userAttributes, false, listener);
    }

    @Override
    public void personalize(@NonNull UserIdentity userIdentity, @Nullable UserAttributes userAttributes, boolean forceDepersonalize, MobileMessaging.ResultListener<User> listener) {
        if (!this.isRegistrationAvailable()) {
            if (listener != null) {
                listener.onResult(new Result<User, MobileMessagingError>(this.getUser(), InternalSdkError.NO_VALID_REGISTRATION.getError()));
            }
            return;
        }
        if (!MobileNetworkInformation.isNetworkAvailableSafely(this.context)) {
            this.registerForNetworkAvailability();
            if (listener != null) {
                listener.onResult(new Result<User, MobileMessagingError>(this.getUser(), InternalSdkError.NETWORK_UNAVAILABLE.getError()));
            }
            return;
        }
        if (forceDepersonalize) {
            this.depersonalizeCurrentInstallation(true);
        }
        if (!userIdentity.hasDataToReport()) {
            MobileMessagingLogger.w("Attempt to save empty user identity, will do nothing");
            if (listener != null) {
                listener.onResult(new Result<User, MobileMessagingError>(this.getUser(), InternalSdkError.ERROR_SAVING_EMPTY_OBJECT.getError()));
            }
            return;
        }
        if (userAttributes != null && userAttributes.hasDataToReport()) {
            if (userAttributes.containsField("phones")) {
                userAttributes.getMap().remove("phones");
            }
            if (userAttributes.containsField("emails")) {
                userAttributes.getMap().remove("emails");
            }
            if (userAttributes.containsField("externalUserId")) {
                userAttributes.getMap().remove("externalUserId");
            }
        }
        this.personalizeSynchronizer().personalize(userIdentity, userAttributes, forceDepersonalize, listener);
    }

    private boolean areInstallationsExpired() {
        Date now = Time.date();
        long expiryTimestamp = PreferenceHelper.findLong(this.context, MobileMessagingProperty.USER_INSTALLATIONS_EXPIRE_AT);
        if (expiryTimestamp != 0L) {
            Date expiryDate = new Date(expiryTimestamp);
            return expiryDate.before(now);
        }
        return false;
    }

    @Override
    public void depersonalize() {
        if (!this.isRegistrationAvailable()) {
            return;
        }
        String currentPushRegistrationId = this.getPushRegistrationId();
        this.onDepersonalizeStarted(currentPushRegistrationId);
        if (!MobileNetworkInformation.isNetworkAvailableSafely(this.context)) {
            this.registerForNetworkAvailability();
            return;
        }
        this.personalizeSynchronizer().depersonalize();
    }

    @Override
    public void depersonalize(MobileMessaging.ResultListener<SuccessPending> listener) {
        this.depersonalize(this.getPushRegistrationId(), listener);
    }

    public void depersonalize(@NonNull String pushRegId, final MobileMessaging.ResultListener<SuccessPending> listener) {
        if (!this.isRegistrationAvailable()) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (listener != null) {
                        listener.onResult(new Result(InternalSdkError.NO_VALID_REGISTRATION.getError()));
                    }
                }
            });
            return;
        }
        this.onDepersonalizeStarted(pushRegId);
        if (!MobileNetworkInformation.isNetworkAvailableSafely(this.context)) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (listener != null) {
                        listener.onResult(new Result(SuccessPending.Pending));
                    }
                }
            });
            this.registerForNetworkAvailability();
            return;
        }
        this.personalizeSynchronizer().depersonalize(pushRegId, new DepersonalizeActionListener(){

            @Override
            public void onUserInitiatedDepersonalizeCompleted() {
                MobileMessagingCore.this.onDepersonalizeCompleted();
                if (listener != null) {
                    listener.onResult(new Result(SuccessPending.Success));
                }
            }

            @Override
            public void onUserInitiatedDepersonalizeFailed(Throwable error) {
                if (listener != null) {
                    listener.onResult(new Result(MobileMessagingError.createFrom(error)));
                }
            }
        });
    }

    @Override
    public void depersonalizeInstallation(final @NonNull String pushRegId, final MobileMessaging.ResultListener<List<Installation>> listener) {
        this.depersonalize(pushRegId, new MobileMessaging.ResultListener<SuccessPending>(){

            @Override
            public void onResult(Result<SuccessPending, MobileMessagingError> result) {
                SuccessPending resultData = result.getData();
                if (resultData != null && SuccessPending.Pending.name().equals(resultData.name())) {
                    if (listener != null) {
                        listener.onResult(new Result(MobileMessagingError.createFrom(new IllegalStateException())));
                    }
                    return;
                }
                if (!result.isSuccess()) {
                    if (listener != null) {
                        listener.onResult(new Result(result.getError()));
                    }
                    return;
                }
                List installations = MobileMessagingCore.this.performLocalDepersonalization(pushRegId);
                if (listener != null) {
                    listener.onResult(new Result(installations));
                }
            }
        });
    }

    @Override
    public void submitEvent(@NonNull CustomEvent customEvent) {
        this.addUnreportedUserCustomEvent(customEvent);
        this.userEventsSynchronizer().reportCustomEvents();
    }

    @Override
    public void submitEvent(@NonNull CustomEvent customEvent, MobileMessaging.ResultListener<CustomEvent> listener) {
        if (TextUtils.isEmpty((CharSequence)customEvent.getDefinitionId())) {
            listener.onResult(new Result<CustomEvent, MobileMessagingError>(customEvent, MobileMessagingError.createFrom(new RuntimeException("Definition ID needs to be provided"))));
            return;
        }
        this.userEventsSynchronizer().reportCustomEvent(customEvent, listener);
    }

    public void addUnreportedUserCustomEvent(CustomEvent customEvent) {
        UserCustomEventBody customEventRequest = UserEventsRequestMapper.createCustomEventRequest(customEvent);
        if (customEventRequest == null) {
            return;
        }
        UserCustomEventBody.CustomEvent customEvents = customEventRequest.getEvents()[0];
        String customEventRequestJsonString = UserEventsRequestMapper.toJson(customEvents);
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.USER_CUSTOM_EVENTS, customEventRequestJsonString);
    }

    public UserCustomEventBody.CustomEvent[] getUnreportedUserCustomEvents() {
        String[] customEventsStringArray = PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.USER_CUSTOM_EVENTS);
        ArrayList<UserCustomEventBody.CustomEvent> customEvents = new ArrayList<UserCustomEventBody.CustomEvent>();
        for (String eventJsonString : customEventsStringArray) {
            customEvents.add(UserEventsRequestMapper.fromJson(eventJsonString));
        }
        return customEvents.toArray(new UserCustomEventBody.CustomEvent[0]);
    }

    public void setUserCustomEventsReported() {
        PreferenceHelper.remove(this.context, MobileMessagingProperty.USER_CUSTOM_EVENTS);
    }

    public void saveSessionBounds(Context context, long sessionStartTimeMillis, long sessionEndTimeMillis) {
        String sessionStartDateTime = DateTimeUtil.dateToISO8601UTCString(new Date(sessionStartTimeMillis));
        String sessionEndDateTime = DateTimeUtil.dateToISO8601UTCString(new Date(sessionEndTimeMillis));
        String sessionBound = sessionStartDateTime + "___" + sessionEndDateTime;
        PreferenceHelper.appendToStringArray(context, MobileMessagingProperty.SESSION_BOUNDS, sessionBound);
    }

    public void reportSessions() {
        this.userEventsSynchronizer().reportSessions();
    }

    public String[] getStoredSessionBounds() {
        return PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.SESSION_BOUNDS);
    }

    public void setUserSessionsReported(String[] storedSessionBounds, long sessionStartsMillis) {
        if (storedSessionBounds != null && storedSessionBounds.length != 0) {
            PreferenceHelper.remove(this.context, MobileMessagingProperty.SESSION_BOUNDS);
        }
        PreferenceHelper.saveLong(this.context, MobileMessagingProperty.LAST_REPORTED_ACTIVE_SESSION_START_TIME_MILLIS, sessionStartsMillis);
    }

    public long getActiveSessionStartTime() {
        return PreferenceHelper.findLong(this.context, MobileMessagingProperty.ACTIVE_SESSION_START_TIME_MILLIS);
    }

    public long getLastReportedActiveSessionStartTime() {
        return PreferenceHelper.findLong(this.context, MobileMessagingProperty.LAST_REPORTED_ACTIVE_SESSION_START_TIME_MILLIS);
    }

    public long getActiveSessionEndTime() {
        return PreferenceHelper.findLong(this.context, MobileMessagingProperty.ACTIVE_SESSION_END_TIME_MILLIS);
    }

    public String getSessionIdHeader() {
        String pushRegistrationId = this.getPushRegistrationId();
        long activeSessionStartTime = this.getActiveSessionStartTime();
        if (pushRegistrationId != null && activeSessionStartTime != 0L) {
            return pushRegistrationId + "_" + activeSessionStartTime;
        }
        return null;
    }

    private List<Installation> performLocalDepersonalization(String pushRegId) {
        User user = this.getUser();
        if (user == null) {
            return null;
        }
        List<Installation> installations = user.getInstallations();
        if (installations != null && !installations.isEmpty()) {
            ArrayList<Installation> installationsTemp = new ArrayList<Installation>(installations);
            for (Installation installation : installationsTemp) {
                if (!pushRegId.equals(installation.getPushRegistrationId())) continue;
                installations.remove((Object)installation);
                break;
            }
            user.setInstallations(installations);
            this.saveUserDataToPrefs(user);
        }
        return user.getInstallations();
    }

    @Nullable
    public User getUnreportedUserData() {
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA)) {
            return UserMapper.fromJson(PreferenceHelper.findString(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA));
        }
        return null;
    }

    public void setUserDataReportedWithError() {
        this.setUserDataReported(null, false);
    }

    public void setUserDataReported(User user, boolean merge) {
        if (user != null && this.shouldSaveUserData()) {
            User dataForStoring = user;
            dataForStoring.clearUnreportedData();
            if (merge) {
                dataForStoring = UserMapper.merge(this.getUser(), user);
            }
            if (dataForStoring != null) {
                this.saveUserDataToPrefs(UserMapper.filterOutDeletedData(dataForStoring));
            }
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA);
    }

    private void saveUserDataToPrefs(User dataForStoring) {
        long oneMinuteInMillis = 60000L;
        Calendar date = Calendar.getInstance();
        long t = date.getTimeInMillis();
        Date inOneMinute = new Date(t + oneMinuteInMillis);
        PreferenceHelper.saveLong(this.context, MobileMessagingProperty.USER_INSTALLATIONS_EXPIRE_AT, inOneMinute.getTime());
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.USER_DATA, UserMapper.toJson(dataForStoring));
    }

    @Override
    public void sendMessages(Message ... messages) {
        this.sendMessages((MobileMessaging.ResultListener<Message[]>)null, messages);
    }

    @Override
    public void sendMessages(MobileMessaging.ResultListener<Message[]> listener, Message ... messages) {
        if (this.isMessageStoreEnabled()) {
            this.getMessageStore().save(this.context, messages);
        }
        this.moMessageSender().send(listener, messages);
    }

    public void sendMessagesDontStore(MobileMessaging.ResultListener<Message[]> listener, Message ... messages) {
        this.moMessageSender().sendDontSave(listener, messages);
    }

    public void sendMessagesWithRetry(Message ... messages) {
        this.moMessageSender().sendWithRetry(messages);
    }

    public boolean isGeofencingActivated() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.GEOFENCING_ACTIVATED.getKey(), false);
    }

    public SystemData getUnreportedSystemData() {
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA)) {
            return SystemData.fromJson(PreferenceHelper.findString(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA));
        }
        return null;
    }

    public SystemData systemDataForReport(boolean forceSend) {
        boolean reportEnabled = PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.REPORT_SYSTEM_INFO);
        SystemData data = new SystemData(SoftwareInformation.getSDKVersionWithPostfixForSystemData(this.context), reportEnabled ? SystemInformation.getAndroidSystemVersion() : "", reportEnabled ? DeviceInformation.getDeviceManufacturer() : "", reportEnabled ? DeviceInformation.getDeviceModel() : "", reportEnabled ? SoftwareInformation.getAppVersion(this.context) : "", this.isGeofencingActivated(), SoftwareInformation.areNotificationsEnabled(this.context), reportEnabled && DeviceInformation.isDeviceSecure(this.context), reportEnabled ? SystemInformation.getAndroidSystemLanguage() : "", reportEnabled ? SystemInformation.getAndroidDeviceName(this.context) : "", reportEnabled ? DeviceInformation.getDeviceTimeZoneOffset() : "");
        if (forceSend) {
            return data;
        }
        int hash = PreferenceHelper.findInt(this.context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH);
        if (hash != data.hashCode()) {
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA, data.toString());
            return data;
        }
        return null;
    }

    @NonNull
    public Installation populateInstallationWithSystemData(SystemData data, Installation installation) {
        installation.setSdkVersion(data.getSdkVersion());
        installation.setOsVersion(data.getOsVersion());
        installation.setDeviceManufacturer(data.getDeviceManufacturer());
        installation.setDeviceModel(data.getDeviceModel());
        installation.setAppVersion(data.getApplicationVersion());
        if (installation.getGeoEnabled() == null) {
            installation.setGeoEnabled(data.isGeofencing());
        }
        if (installation.getNotificationsEnabled() == null) {
            installation.setNotificationsEnabled(data.areNotificationsEnabled());
        }
        installation.setDeviceSecure(data.isDeviceSecure());
        if (installation.getLanguage() == null) {
            installation.setLanguage(data.getLanguage());
        }
        if (installation.getDeviceTimezoneOffset() == null) {
            installation.setDeviceTimezoneOffset(data.getDeviceTimeZoneOffset());
        }
        if (installation.getDeviceName() == null) {
            installation.setDeviceName(data.getDeviceName());
        }
        installation.setOs("Android");
        return installation;
    }

    public void removeReportedSystemData() {
        PreferenceHelper.remove(this.context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH);
    }

    public void setSystemDataReported() {
        SystemData systemData = this.getUnreportedSystemData();
        if (systemData == null) {
            return;
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA);
        PreferenceHelper.saveInt(this.context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH, systemData.hashCode());
    }

    private void setApplicationCodeProviderClassName(ApplicationCodeProvider applicationCodeProvider) {
        MobileMessagingCore.applicationCodeProvider = applicationCodeProvider;
        if (applicationCodeProvider == null) {
            return;
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.APP_CODE_PROVIDER_CANONICAL_CLASS_NAME, applicationCodeProvider.getClass().getCanonicalName());
    }

    private static String getApplicationCodeProviderClassName(Context context) {
        return PreferenceHelper.findString(context, MobileMessagingProperty.APP_CODE_PROVIDER_CANONICAL_CLASS_NAME);
    }

    public void saveUnreportedUserData(User user) {
        if (this.shouldSaveUserData()) {
            PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA);
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA, UserMapper.toJson(user));
        }
    }

    public void handleNoRegistrationError(MobileMessagingError mobileMessagingError) {
        if ("NO_REGISTRATION".equalsIgnoreCase(mobileMessagingError.getCode())) {
            this.setCloudTokenUnreported();
            this.setUnreportedCustomAttributes(this.getMergedUnreportedAndReportedCustomAtts());
            this.setShouldRepersonalize(true);
            this.removeReportedSystemData();
            this.setUnreportedPrimarySetting();
            this.setPushRegistrationEnabledReported(false);
        }
    }

    private void runOnUiThread(final Runnable runnable) {
        new MAsyncTask<Void, Void>(){

            public Void run(Void[] voids) {
                return null;
            }

            @Override
            public void after(Void aVoid) {
                runnable.run();
            }
        }.execute(new Void[0]);
    }

    @NonNull
    private MobileApiResourceProvider mobileApiResourceProvider() {
        if (mobileApiResourceProvider == null) {
            mobileApiResourceProvider = new MobileApiResourceProvider();
        }
        return mobileApiResourceProvider;
    }

    @NonNull
    private MoMessageSender moMessageSender() {
        if (this.moMessageSender == null) {
            this.moMessageSender = new MoMessageSender(this.context, this, this.broadcaster, this.registrationAlignedExecutor, this.stats, this.retryPolicyProvider.DEFAULT(), this.mobileApiResourceProvider().getMobileApiMessages(this.context), this.getMessageStoreWrapper());
        }
        return this.moMessageSender;
    }

    @NonNull
    private UserDataReporter userDataReporter() {
        if (this.userDataReporter == null) {
            this.userDataReporter = new UserDataReporter(this, this.registrationAlignedExecutor, this.broadcaster, this.retryPolicyProvider, this.stats, this.mobileApiResourceProvider().getMobileApiAppInstance(this.context));
        }
        return this.userDataReporter;
    }

    @NonNull
    private PersonalizeSynchronizer personalizeSynchronizer() {
        if (this.personalizeSynchronizer == null) {
            this.personalizeSynchronizer = new PersonalizeSynchronizer(this, this.broadcaster, this.mobileApiResourceProvider().getMobileApiAppInstance(this.context), this.retryPolicyProvider.DEFAULT(), this.registrationAlignedExecutor, new BatchReporter(PreferenceHelper.findLong(this.context, MobileMessagingProperty.BATCH_REPORTING_DELAY)), this);
        }
        return this.personalizeSynchronizer;
    }

    @NonNull
    private MessagesSynchronizer messagesSynchronizer() {
        if (this.messagesSynchronizer == null) {
            MobileMessageHandler mobileMessageHandler = new MobileMessageHandler(this, this.broadcaster, this.getNotificationHandler(), this.getMessageStoreWrapper());
            this.messagesSynchronizer = new MessagesSynchronizer(this, this.stats, this.registrationAlignedExecutor, this.broadcaster, this.retryPolicyProvider.DEFAULT(), mobileMessageHandler, this.mobileApiResourceProvider().getMobileApiMessages(this.context));
        }
        return this.messagesSynchronizer;
    }

    @NonNull
    private SeenStatusReporter seenStatusReporter() {
        if (this.seenStatusReporter == null) {
            this.seenStatusReporter = new SeenStatusReporter(this, this.stats, this.registrationAlignedExecutor, this.broadcaster, this.mobileApiResourceProvider().getMobileApiMessages(this.context), new BatchReporter(PreferenceHelper.findLong(this.context, MobileMessagingProperty.BATCH_REPORTING_DELAY)));
        }
        return this.seenStatusReporter;
    }

    @NonNull
    private VersionChecker versionChecker() {
        if (this.versionChecker == null) {
            this.versionChecker = new VersionChecker(this.context, this, this.stats, this.mobileApiResourceProvider().getMobileApiVersion(this.context), this.retryPolicyProvider);
        }
        return this.versionChecker;
    }

    @NonNull
    private InstallationSynchronizer installationSynchronizer() {
        if (this.installationSynchronizer == null) {
            this.installationSynchronizer = new InstallationSynchronizer(this.context, this, this.stats, this.registrationAlignedExecutor, this.broadcaster, this.retryPolicyProvider, this.mobileApiResourceProvider().getMobileApiAppInstance(this.context));
        }
        return this.installationSynchronizer;
    }

    @NonNull
    private UserEventsSynchronizer userEventsSynchronizer() {
        if (this.userEventsSynchronizer == null) {
            this.userEventsSynchronizer = new UserEventsSynchronizer(this, this.broadcaster, this.mobileApiResourceProvider().getMobileApiAppInstance(this.context), this.retryPolicyProvider.DEFAULT(), this.registrationAlignedExecutor, new BatchReporter(PreferenceHelper.findLong(this.context, MobileMessagingProperty.BATCH_REPORTING_DELAY)));
        }
        return this.userEventsSynchronizer;
    }

    public static final class Builder {
        private final Application application;
        private NotificationSettings notificationSettings = null;
        private String applicationCode = null;
        private ApplicationCodeProvider applicationCodeProvider;

        public Builder(Application application) {
            if (null == application) {
                throw new IllegalArgumentException("application is mandatory!");
            }
            this.application = application;
        }

        private void validateWithParam(Object o) {
            if (null != o) {
                return;
            }
            throw new IllegalArgumentException("Can't use 'with' method with null argument!");
        }

        public Builder withDisplayNotification(NotificationSettings notificationSettings) {
            this.notificationSettings = notificationSettings;
            return this;
        }

        public Builder withApplicationCode(String applicationCode) {
            this.validateWithParam(applicationCode);
            this.applicationCode = applicationCode;
            return this;
        }

        public Builder withApplicationCode(ApplicationCodeProvider applicationCodeProvider) {
            this.validateWithParam(applicationCodeProvider);
            this.applicationCodeProvider = applicationCodeProvider;
            return this;
        }

        public MobileMessagingCore build(@Nullable MobileMessaging.InitListener initListener) {
            String existingApplicationCode;
            if (MobileMessagingCore.shouldSaveApplicationCode(this.application.getApplicationContext()) && (existingApplicationCode = MobileMessagingCore.getStoredApplicationCode(this.application.getApplicationContext())) != null && this.applicationCode != null && !this.applicationCode.equals(existingApplicationCode)) {
                MobileMessagingCore.cleanup((Context)this.application);
            }
            Platform.verify((Context)this.application);
            MobileMessagingCore mobileMessagingCore = new MobileMessagingCore((Context)this.application);
            mobileMessagingCore.setNotificationSettings(this.notificationSettings);
            mobileMessagingCore.setApplicationCode(this.applicationCode);
            mobileMessagingCore.setApplicationCodeProviderClassName(this.applicationCodeProvider);
            mobileMessagingCore.mobileNetworkStateListener = new MobileNetworkStateListener((Context)this.application);
            mobileMessagingCore.playServicesSupport = new PlayServicesSupport();
            boolean shouldResetToken = mobileMessagingCore.isPushServiceTypeChanged() && mobileMessagingCore.getPushRegistrationId() != null;
            mobileMessagingCore.playServicesSupport.checkPlayServicesAndTryToAcquireToken(this.application.getApplicationContext(), shouldResetToken, initListener);
            Platform.reset(mobileMessagingCore);
            return mobileMessagingCore;
        }
    }
}

