/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.cloud;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.dal.bundle.MessageBundleMapper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.platform.JobIntentService;
import org.infobip.mobile.messaging.platform.MobileMessagingJob;
import org.infobip.mobile.messaging.platform.Platform;

public class MobileMessagingCloudService
extends JobIntentService {
    public static void enqueueTokenAcquisition(Context context, String senderId) {
        if (TextUtils.isEmpty((CharSequence)senderId)) {
            MobileMessagingLogger.e("Cannot acquire token, senderId is empty");
            return;
        }
        MobileMessagingCloudService.enqueueWork(context, new Intent("org.infobip.mobile.messaging.cloud.TOKEN_ACQUIRE").putExtra("org.infobip.mobile.messaging.cloud.SENDER_ID", senderId));
    }

    public static void enqueueTokenCleanup(Context context, String senderId) {
        if (TextUtils.isEmpty((CharSequence)senderId)) {
            MobileMessagingLogger.e("Cannot cleanup token, senderId is empty");
            return;
        }
        MobileMessagingCloudService.enqueueWork(context, new Intent("org.infobip.mobile.messaging.cloud.TOKEN_CLEANUP").putExtra("org.infobip.mobile.messaging.cloud.SENDER_ID", senderId));
    }

    public static void enqueueTokenReset(Context context, String senderId) {
        if (TextUtils.isEmpty((CharSequence)senderId)) {
            MobileMessagingLogger.e("Cannot reset token, senderId is empty");
            return;
        }
        MobileMessagingCloudService.enqueueWork(context, new Intent("org.infobip.mobile.messaging.cloud.TOKEN_RESET").putExtra("org.infobip.mobile.messaging.cloud.SENDER_ID", senderId));
    }

    public static void enqueueNewToken(Context context, String senderId, String token) {
        if (TextUtils.isEmpty((CharSequence)senderId)) {
            MobileMessagingLogger.e("Cannot process new token, senderId is empty");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)token)) {
            MobileMessagingLogger.e("Cannot process new token, token is empty");
            return;
        }
        MobileMessagingCloudService.enqueueWork(context, new Intent("org.infobip.mobile.messaging.cloud.NEW_TOKEN").putExtra("org.infobip.mobile.messaging.cloud.SENDER_ID", senderId).putExtra("org.infobip.mobile.messaging.cloud.TOKEN", token));
    }

    public static void enqueueNewMessage(Context context, @NonNull Message message) {
        Bundle messageBundle = MessageBundleMapper.messageToBundle(message);
        MobileMessagingCloudService.enqueueWork(context, new Intent("org.infobip.mobile.messaging.cloud.MESSAGE_RECEIVE").putExtras(messageBundle));
    }

    private static void enqueueWork(Context context, Intent work) {
        if (MobileMessagingCloudService.shouldEnqueueViaJobIntentService(context)) {
            MobileMessagingCloudService.enqueueWork(context, MobileMessagingCloudService.class, MobileMessagingJob.getScheduleId(context, 2), work.setPackage(context.getPackageName()));
        } else {
            MobileMessagingLogger.w("Enqueuing " + work.getAction() + " without WAKE_LOCK permission");
            MobileMessagingCloudService.enqueueInBackground(context, work);
        }
    }

    private static boolean shouldEnqueueViaJobIntentService(Context context) {
        return Platform.sdkInt >= 26 || ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.WAKE_LOCK") == 0;
    }

    private static void enqueueInBackground(final Context context, final Intent work) {
        Platform.executeInBackground(new Runnable(){

            @Override
            public void run() {
                Platform.mobileMessagingCloudHandler.get(context).handleWork(context, work);
            }
        });
    }

    @Override
    protected void onHandleWork(@NonNull Intent intent) {
        Platform.mobileMessagingCloudHandler.get((Context)this).handleWork((Context)this, intent);
    }
}

