/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.interactive;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import org.infobip.mobile.messaging.interactive.dal.bundle.NotificationActionBundleMapper;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.StringUtils;

public class NotificationAction {
    private final String id;
    private final int titleResourceId;
    private final int icon;
    private final boolean bringsAppToForeground;
    private final boolean sendsMoMessage;
    private final Integer inputPlaceholderResourceId;
    private String inputText;
    private final String titleText;
    private final String inputPlaceholderText;

    private NotificationAction(String id, int titleResourceId, int icon, boolean bringsAppToForeground, boolean sendsMoMessage, Integer inputPlaceholderResourceId, String titleText, String inputPlaceholderText) {
        this.id = id;
        this.titleResourceId = titleResourceId;
        this.icon = icon;
        this.bringsAppToForeground = bringsAppToForeground;
        this.sendsMoMessage = sendsMoMessage;
        this.inputPlaceholderResourceId = inputPlaceholderResourceId;
        this.titleText = titleText;
        this.inputPlaceholderText = inputPlaceholderText;
        if (inputPlaceholderResourceId != null || inputPlaceholderText != null) {
            this.inputText = "";
        }
    }

    public static NotificationAction createFrom(Bundle bundle) {
        return NotificationActionBundleMapper.notificationActionFromBundle(bundle);
    }

    public String getId() {
        return this.id;
    }

    public int getTitleResourceId() {
        return this.titleResourceId;
    }

    public int getIcon() {
        return this.icon;
    }

    public boolean bringsAppToForeground() {
        return this.bringsAppToForeground;
    }

    public boolean sendsMoMessage() {
        return this.sendsMoMessage;
    }

    public boolean hasInput() {
        return this.inputPlaceholderResourceId != null || this.inputPlaceholderText != null;
    }

    public int getInputPlaceholderResourceId() {
        return this.inputPlaceholderResourceId != null ? this.inputPlaceholderResourceId : 0;
    }

    public String getInputText() {
        return this.inputText;
    }

    public void setInputText(String input) {
        this.inputText = input;
    }

    public String getTitleText() {
        return this.titleText;
    }

    public String getInputPlaceholderText() {
        return this.inputPlaceholderText;
    }

    public static final class Builder {
        private final boolean predefined;
        private String id;
        private int titleResourceId;
        private int icon;
        private boolean bringsAppToForeground;
        private boolean sendsMoMessage;
        private Integer inputLabelResourceId;
        private String titleText;
        private String inputPlaceholderText;

        public Builder() {
            this.predefined = false;
        }

        public Builder(boolean predefined) {
            this.predefined = predefined;
        }

        public Builder withId(@NonNull String id) {
            this.validateWithParam(id);
            if (!this.predefined && id.startsWith("mm_")) {
                throw new IllegalArgumentException(String.format("'%s' prefix is reserved for Mobile Messaging library", "mm_"));
            }
            this.id = id;
            return this;
        }

        public Builder withTitleResourceId(int titleResourceId) {
            this.titleResourceId = titleResourceId;
            return this;
        }

        public Builder withIcon(int icon) {
            this.icon = icon;
            return this;
        }

        public Builder withBringingAppToForeground(boolean bringAppToForeground) {
            this.bringsAppToForeground = bringAppToForeground;
            return this;
        }

        public Builder withMoMessage() {
            this.sendsMoMessage = true;
            return this;
        }

        public Builder withMoMessage(boolean sendsMoMessage) {
            this.sendsMoMessage = sendsMoMessage;
            return this;
        }

        public Builder withInput() {
            this.inputLabelResourceId = 0;
            return this;
        }

        public Builder withInput(int labelResourceId) {
            this.inputLabelResourceId = labelResourceId;
            return this;
        }

        public Builder withTitleText(String titleText) {
            this.titleText = titleText;
            return this;
        }

        public Builder withInput(String inputPlaceholderText) {
            this.inputPlaceholderText = inputPlaceholderText;
            return this;
        }

        public Builder withIcon(Context context, String iconResourceName) {
            if (!TextUtils.isEmpty((CharSequence)iconResourceName)) {
                this.icon = ResourceLoader.loadResourceByName(context, null, iconResourceName);
            }
            return this;
        }

        public NotificationAction build() {
            if (StringUtils.isBlank(this.id)) {
                throw new IllegalArgumentException("Please specify valid ID for notification action");
            }
            if (this.titleResourceId == 0 && TextUtils.isEmpty((CharSequence)this.titleText)) {
                throw new IllegalArgumentException(String.format("Please specify valid title for notification ID '%s'", this.id));
            }
            return new NotificationAction(this.id, this.titleResourceId, this.icon, this.bringsAppToForeground, this.sendsMoMessage, this.inputLabelResourceId, this.titleText, this.inputPlaceholderText);
        }

        private void validateWithParam(Object o) {
            if (null != o) {
                return;
            }
            throw new IllegalArgumentException("Can't use 'with' method with null argument!");
        }
    }
}

