/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.interactive.inapp.view;

import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.R;
import org.infobip.mobile.messaging.interactive.NotificationAction;
import org.infobip.mobile.messaging.interactive.NotificationCategory;
import org.infobip.mobile.messaging.interactive.inapp.view.ActivityWrapper;
import org.infobip.mobile.messaging.interactive.inapp.view.InAppView;
import org.infobip.mobile.messaging.interactive.inapp.view.InAppViewDialogClickListener;
import org.infobip.mobile.messaging.interactive.inapp.view.InAppViewDialogDismissListener;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

public class InAppViewDialog
implements InAppView {
    private final InAppView.Callback callback;
    private final View dialogView;
    private final TextView tvMessageText;
    private final TextView tvMessageTitle;
    private final RelativeLayout rlDialogImage;
    private final ImageView image;
    private final Executor uiThreadExecutor;
    private final ActivityWrapper activityWrapper;

    InAppViewDialog(InAppView.Callback callback, Executor uiThreadExecutor, ActivityWrapper activityWrapper) {
        this.dialogView = activityWrapper.inflateView(R.layout.in_app_dialog_image);
        this.tvMessageText = (TextView)this.dialogView.findViewById(R.id.tv_msg_text);
        this.tvMessageTitle = (TextView)this.dialogView.findViewById(R.id.tv_msg_title);
        this.rlDialogImage = (RelativeLayout)this.dialogView.findViewById(R.id.rl_dialog_image);
        this.image = (ImageView)this.dialogView.findViewById(R.id.iv_dialog);
        this.callback = callback;
        this.uiThreadExecutor = uiThreadExecutor;
        this.activityWrapper = activityWrapper;
    }

    @Override
    public void show(@NonNull Message message, @NonNull NotificationCategory category, NotificationAction ... actions) {
        this.show(null, message, category, actions);
    }

    @Override
    public void showWithImage(@NonNull Bitmap bitmap, @NonNull Message message, NotificationCategory category, NotificationAction ... actions) {
        this.show(bitmap, message, category, actions);
    }

    private void show(final Bitmap bitmap, final @NonNull Message message, final NotificationCategory category, final NotificationAction ... actions) {
        if (actions.length == 0) {
            return;
        }
        this.uiThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    InAppViewDialog.this.showOnUiThreadWithAppTheme(bitmap, message, category, actions);
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().contains("You need to use a Theme.AppCompat theme")) {
                        InAppViewDialog.this.showOnUiThreadWithOwnTheme(bitmap, message, category, actions);
                    }
                    throw e;
                }
            }
        });
    }

    private void showOnUiThreadWithOwnTheme(Bitmap bitmap, @NonNull Message message, NotificationCategory category, @NonNull NotificationAction[] actions) {
        this.showOnUiThread(bitmap, message, category, actions, false);
    }

    private void showOnUiThreadWithAppTheme(Bitmap bitmap, @NonNull Message message, NotificationCategory category, @NonNull NotificationAction[] actions) {
        this.showOnUiThread(bitmap, message, category, actions, true);
    }

    private void showOnUiThread(Bitmap bitmap, @NonNull Message message, NotificationCategory category, @NonNull NotificationAction[] actions, boolean useAppTheme) {
        if (bitmap != null) {
            this.image.setImageBitmap(bitmap);
            this.rlDialogImage.setVisibility(0);
            this.image.setVisibility(0);
        }
        if (!TextUtils.isEmpty((CharSequence)message.getTitle())) {
            this.tvMessageTitle.setText((CharSequence)message.getTitle());
            this.tvMessageTitle.setVisibility(0);
        }
        this.tvMessageText.setText((CharSequence)message.getBody());
        try {
            AlertDialog.Builder builder = this.activityWrapper.createAlertDialogBuilder(useAppTheme).setOnDismissListener((DialogInterface.OnDismissListener)new InAppViewDialogDismissListener(this, this.callback)).setView(this.dialogView);
            switch (actions.length) {
                case 1: {
                    builder.setPositiveButton(actions[0].getTitleResourceId(), (DialogInterface.OnClickListener)new InAppViewDialogClickListener(this, this.callback, message, category, actions[0]));
                    break;
                }
                case 2: {
                    builder.setNegativeButton(actions[0].getTitleResourceId(), (DialogInterface.OnClickListener)new InAppViewDialogClickListener(this, this.callback, message, category, actions[0])).setPositiveButton(actions[1].getTitleResourceId(), (DialogInterface.OnClickListener)new InAppViewDialogClickListener(this, this.callback, message, category, actions[1]));
                    break;
                }
                default: {
                    builder.setNegativeButton(actions[0].getTitleResourceId(), (DialogInterface.OnClickListener)new InAppViewDialogClickListener(this, this.callback, message, category, actions[0])).setNeutralButton(actions[1].getTitleResourceId(), (DialogInterface.OnClickListener)new InAppViewDialogClickListener(this, this.callback, message, category, actions[1])).setPositiveButton(actions[2].getTitleResourceId(), (DialogInterface.OnClickListener)new InAppViewDialogClickListener(this, this.callback, message, category, actions[2]));
                }
            }
            builder.create().show();
        }
        catch (Exception e) {
            MobileMessagingLogger.e("Failed to build in-app view due to " + e.getMessage());
        }
    }
}

