/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobileapi;

import android.content.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.api.appinstance.MobileApiAppInstance;
import org.infobip.mobile.messaging.api.chat.MobileApiChat;
import org.infobip.mobile.messaging.api.geo.MobileApiGeo;
import org.infobip.mobile.messaging.api.messages.MobileApiMessages;
import org.infobip.mobile.messaging.api.support.CustomApiHeaders;
import org.infobip.mobile.messaging.api.support.Generator;
import org.infobip.mobile.messaging.api.support.http.client.Logger;
import org.infobip.mobile.messaging.api.support.http.client.Request;
import org.infobip.mobile.messaging.api.support.http.client.RequestInterceptor;
import org.infobip.mobile.messaging.api.support.http.client.ResponsePreProcessor;
import org.infobip.mobile.messaging.api.version.MobileApiVersion;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.DeviceInformation;
import org.infobip.mobile.messaging.util.MobileNetworkInformation;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.StringUtils;
import org.infobip.mobile.messaging.util.SystemInformation;

public class MobileApiResourceProvider {
    private BaseUrlManager mobileMessagingRequestInterceptor;
    private Generator generator;
    private MobileApiMessages mobileApiMessages;
    private MobileApiVersion mobileApiVersion;
    private MobileApiGeo mobileApiGeo;
    private MobileApiAppInstance mobileApiAppInstance;
    private MobileApiChat mobileApiChat;

    public MobileApiMessages getMobileApiMessages(Context context) {
        if (null != this.mobileApiMessages) {
            return this.mobileApiMessages;
        }
        this.mobileApiMessages = (MobileApiMessages)this.getGenerator(context).create(MobileApiMessages.class);
        return this.mobileApiMessages;
    }

    public MobileApiVersion getMobileApiVersion(Context context) {
        if (null != this.mobileApiVersion) {
            return this.mobileApiVersion;
        }
        this.mobileApiVersion = (MobileApiVersion)this.getGenerator(context).create(MobileApiVersion.class);
        return this.mobileApiVersion;
    }

    public MobileApiGeo getMobileApiGeo(Context context) {
        if (null != this.mobileApiGeo) {
            return this.mobileApiGeo;
        }
        this.mobileApiGeo = (MobileApiGeo)this.getGenerator(context).create(MobileApiGeo.class);
        return this.mobileApiGeo;
    }

    public MobileApiAppInstance getMobileApiAppInstance(Context context) {
        if (null != this.mobileApiAppInstance) {
            return this.mobileApiAppInstance;
        }
        this.mobileApiAppInstance = (MobileApiAppInstance)this.getGenerator(context).create(MobileApiAppInstance.class);
        return this.mobileApiAppInstance;
    }

    public MobileApiChat getMobileApiChat(Context context) {
        if (null != this.mobileApiChat) {
            return this.mobileApiChat;
        }
        this.mobileApiChat = (MobileApiChat)this.getGenerator(context).create(MobileApiChat.class);
        return this.mobileApiChat;
    }

    private String[] getUserAgentAdditions(Context context) {
        ArrayList<String> userAgentAdditions = new ArrayList<String>();
        if (PreferenceHelper.findBoolean(context, MobileMessagingProperty.REPORT_SYSTEM_INFO)) {
            userAgentAdditions.add(SystemInformation.getAndroidSystemName());
            userAgentAdditions.add(SystemInformation.getAndroidSystemVersion());
            userAgentAdditions.add(SystemInformation.getAndroidSystemABI());
            userAgentAdditions.add(DeviceInformation.getDeviceModel());
            userAgentAdditions.add(DeviceInformation.getDeviceManufacturer());
            userAgentAdditions.add(SoftwareInformation.getAppName(context));
            userAgentAdditions.add(SoftwareInformation.getAppVersion(context));
            userAgentAdditions.add(SystemInformation.getAndroidDeviceName(context));
        } else {
            String[] emptySystemInfo = new String[]{"", "", "", "", "", "", "", ""};
            userAgentAdditions.addAll(Arrays.asList(emptySystemInfo));
        }
        if (PreferenceHelper.findBoolean(context, MobileMessagingProperty.REPORT_CARRIER_INFO)) {
            userAgentAdditions.add(MobileNetworkInformation.getMobileCarrierName(context));
            userAgentAdditions.add(MobileNetworkInformation.getMobileNetworkCode(context));
            userAgentAdditions.add(MobileNetworkInformation.getMobileCountryCode(context));
            userAgentAdditions.add(MobileNetworkInformation.getSIMCarrierName(context));
            userAgentAdditions.add(MobileNetworkInformation.getSIMNetworkCode(context));
            userAgentAdditions.add(MobileNetworkInformation.getSIMCountryCode(context));
        } else {
            String[] emptyCarrierInfoAdditions = new String[]{"", "", "", "", "", ""};
            userAgentAdditions.addAll(Arrays.asList(emptyCarrierInfoAdditions));
        }
        return userAgentAdditions.toArray(new String[0]);
    }

    private boolean shouldAllowUntrustedSSLOnError(Context context) {
        return PreferenceHelper.findBoolean(context, MobileMessagingProperty.ALLOW_UNTRUSTED_SSL_ON_ERROR);
    }

    private Generator getGenerator(Context context) {
        if (null != this.generator) {
            return this.generator;
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        properties.put("api.key", MobileMessagingCore.getApplicationCode(context));
        properties.put("library.version", SoftwareInformation.getSDKVersionWithPostfixForUserAgent(context));
        this.generator = new Generator.Builder().withBaseUrl(MobileMessagingCore.getApiUri(context)).withProperties(properties).withUserAgentAdditions(this.getUserAgentAdditions(context)).withRequestInterceptors(new RequestInterceptor[]{this.baseUrlManager(context)}).withResponseHeaderInterceptors(new ResponsePreProcessor[]{this.baseUrlManager(context)}).withLogger((Logger)new AndroidHTTPLogger()).withAllowUntrustedSSLOnError(this.shouldAllowUntrustedSSLOnError(context)).build();
        return this.generator;
    }

    private BaseUrlManager baseUrlManager(Context context) {
        if (this.mobileMessagingRequestInterceptor == null) {
            this.mobileMessagingRequestInterceptor = new BaseUrlManager(context);
        }
        return this.mobileMessagingRequestInterceptor;
    }

    class AndroidHTTPLogger
    extends Logger {
        private static final String TAG = "MMHTTP";

        AndroidHTTPLogger() {
        }

        public void e(String message) {
            MobileMessagingLogger.e(TAG, message);
        }

        public void w(String message) {
            MobileMessagingLogger.w(TAG, message);
        }

        public void i(String message) {
            MobileMessagingLogger.i(TAG, message);
        }

        public void d(String message) {
            MobileMessagingLogger.d(TAG, message);
        }
    }

    public class BaseUrlManager
    implements RequestInterceptor,
    ResponsePreProcessor {
        private final Context context;

        public BaseUrlManager(Context context) {
            this.context = context;
        }

        public Request intercept(Request request) {
            String sessionIdHeader;
            boolean foreground = ActivityLifecycleMonitor.isForeground();
            request.getHeaders().put(CustomApiHeaders.FOREGROUND.getValue(), Collections.singletonList(foreground));
            if (foreground && StringUtils.isNotBlank(sessionIdHeader = MobileMessagingCore.getInstance(this.context).getSessionIdHeader())) {
                request.getHeaders().put(CustomApiHeaders.SESSION_ID.getValue(), Collections.singletonList(sessionIdHeader));
            }
            request.getHeaders().put(CustomApiHeaders.PUSH_REGISTRATION_ID.getValue(), Collections.singletonList(MobileMessagingCore.getInstance(this.context).getPushRegistrationId()));
            request.getHeaders().put(CustomApiHeaders.APPLICATION_CODE.getValue(), Collections.singletonList(MobileMessagingCore.getApplicationCodeHash(this.context)));
            return request;
        }

        public void beforeResponse(int responseCode, Map<String, List<String>> headers) {
            if (responseCode >= 400) {
                MobileMessagingCore.resetApiUri(this.context);
                return;
            }
            List<String> values = headers.get(CustomApiHeaders.NEW_BASE_URL.getValue());
            if (values == null || values.isEmpty() || StringUtils.isBlank(values.get(0))) {
                return;
            }
            String url = values.get(0);
            MobileMessagingCore.setApiUri(this.context, url);
            MobileApiResourceProvider.this.generator.setBaseUrl(url);
        }

        public void beforeResponse(Exception error) {
            MobileMessagingCore.resetApiUri(this.context);
        }
    }
}

