/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobileapi.appinstance;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.infobip.mobile.messaging.CustomAttributeValue;
import org.infobip.mobile.messaging.Installation;
import org.infobip.mobile.messaging.InstallationMapper;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.api.appinstance.AppInstance;
import org.infobip.mobile.messaging.api.appinstance.MobileApiAppInstance;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobileapi.InternalSdkError;
import org.infobip.mobile.messaging.mobileapi.MobileMessagingError;
import org.infobip.mobile.messaging.mobileapi.Result;
import org.infobip.mobile.messaging.mobileapi.common.MRetryableTask;
import org.infobip.mobile.messaging.mobileapi.common.RetryPolicyProvider;
import org.infobip.mobile.messaging.mobileapi.common.exceptions.BackendInvalidParameterException;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.StringUtils;

public class InstallationSynchronizer {
    private static final long SYNC_THROTTLE_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private final Context context;
    private final MobileMessagingCore mobileMessagingCore;
    private final MobileMessagingStats stats;
    private final Executor executor;
    private final Broadcaster broadcaster;
    private final RetryPolicyProvider retryPolicyProvider;
    private final MobileApiAppInstance mobileApiAppInstance;
    private volatile Long lastSyncTimeMillis;

    public InstallationSynchronizer(Context context, MobileMessagingCore mobileMessagingCore, MobileMessagingStats stats, Executor executor, Broadcaster broadcaster, RetryPolicyProvider retryPolicyProvider, MobileApiAppInstance mobileApiAppInstance) {
        this.context = context;
        this.mobileMessagingCore = mobileMessagingCore;
        this.stats = stats;
        this.executor = executor;
        this.broadcaster = broadcaster;
        this.retryPolicyProvider = retryPolicyProvider;
        this.mobileApiAppInstance = mobileApiAppInstance;
    }

    public void sync() {
        this.sync(null);
    }

    @VisibleForTesting
    void sync(MobileMessaging.ResultListener<Installation> actionListener) {
        boolean cloudTokenPresentAndUnreported;
        PushInstallation installation = new PushInstallation();
        SystemData systemDataForReport = this.mobileMessagingCore.systemDataForReport(false);
        if (systemDataForReport != null) {
            installation = this.from(systemDataForReport);
        }
        if (cloudTokenPresentAndUnreported = this.isCloudTokenPresentAndUnreported()) {
            installation.setToken(this.mobileMessagingCore.getCloudToken());
            installation.setServiceType();
        }
        if (this.mobileMessagingCore.isPushServiceTypeChanged()) {
            installation.setServiceType();
        }
        if (this.mobileMessagingCore.getUnreportedPrimarySetting() != null) {
            installation.setPrimaryDevice(this.mobileMessagingCore.getUnreportedPrimarySetting());
        }
        if (!this.mobileMessagingCore.isApplicationUserIdReported().booleanValue()) {
            installation.setApplicationUserId(this.mobileMessagingCore.getApplicationUserId());
        }
        if (this.mobileMessagingCore.isPushRegistrationEnabledUnreported()) {
            installation.setPushRegistrationEnabled(this.mobileMessagingCore.isPushRegistrationEnabled());
        }
        if (!this.mobileMessagingCore.isRegistrationAvailable()) {
            if (cloudTokenPresentAndUnreported && !this.didSyncRecently()) {
                this.createInstallation(installation, actionListener);
            }
        } else if (installation.hasDataToReport() && !this.didSyncRecently()) {
            this.patchMyInstallation(installation, actionListener);
        }
        this.lastSyncTimeMillis = Time.now();
    }

    private boolean didSyncRecently() {
        return this.lastSyncTimeMillis != null && Time.now() - this.lastSyncTimeMillis < SYNC_THROTTLE_INTERVAL_MILLIS;
    }

    public void updatePrimaryStatus(String pushRegId, Boolean primary, MobileMessaging.ResultListener<Installation> actionListener) {
        Installation installation = new Installation(pushRegId);
        installation.setPrimaryDevice(primary);
        this.patchMyInstallation(installation, actionListener);
    }

    private void createInstallation(final Installation installation, final MobileMessaging.ResultListener<Installation> actionListener) {
        new MRetryableTask<Void, AppInstance>(){

            @Override
            public boolean shouldCancel() {
                return InstallationSynchronizer.this.mobileMessagingCore.isRegistrationAvailable() || InstallationSynchronizer.this.isSystemDataAbsent(installation);
            }

            public AppInstance run(Void[] voids) {
                MobileMessagingLogger.v("CREATE INSTALLATION >>>", (Object)installation);
                InstallationSynchronizer.this.setCloudTokenReported(true);
                AppInstance appInstance = InstallationMapper.toBackend(installation);
                return InstallationSynchronizer.this.mobileApiAppInstance.createInstance(appInstance);
            }

            @Override
            public void afterBackground(AppInstance appInstance) {
                MobileMessagingLogger.v("CREATE INSTALLATION DONE <<<", appInstance);
                if (appInstance == null) {
                    InstallationSynchronizer.this.setCloudTokenReported(false);
                    return;
                }
                Installation installation2 = InstallationMapper.fromBackend(appInstance);
                InstallationSynchronizer.this.setPushRegistrationId(installation2.getPushRegistrationId());
                InstallationSynchronizer.this.updateInstallationReported(installation2, true);
            }

            @Override
            public void after(AppInstance appInstance) {
                String pushServiceToken = installation.getPushServiceToken();
                String pushRegId = appInstance.getPushRegId();
                appInstance.setPushServiceToken(pushServiceToken);
                Installation backendInstallation = InstallationMapper.fromBackend(appInstance);
                InstallationSynchronizer.this.broadcaster.registrationCreated(pushServiceToken, pushRegId);
                if (actionListener != null) {
                    actionListener.onResult(new Result(backendInstallation));
                }
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.v("CREATE INSTALLATION ERROR <<<", error);
                InstallationSynchronizer.this.setCloudTokenReported(false);
                InstallationSynchronizer.this.mobileMessagingCore.setLastHttpException(error);
                InstallationSynchronizer.this.stats.reportError(MobileMessagingStatsError.REGISTRATION_SYNC_ERROR);
                InstallationSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(error));
                if (actionListener != null) {
                    actionListener.onResult(new Result<Installation, MobileMessagingError>(InstallationSynchronizer.this.mobileMessagingCore.getInstallation(true), MobileMessagingError.createFrom(error)));
                }
            }

            public void cancelled(Void[] voids) {
                MobileMessagingLogger.v("CREATE INSTALLATION CANCELLED <<<");
                if (actionListener != null) {
                    actionListener.onResult(new Result(InstallationSynchronizer.this.mobileMessagingCore.getInstallation(true)));
                }
            }
        }.retryWith(this.retryPolicyProvider.DEFAULT()).execute(this.executor, (IN[])new Void[0]);
    }

    private boolean isSystemDataAbsent(Installation installation) {
        return installation.getSdkVersion() == null || installation.getDeviceManufacturer() == null || installation.getOs() == null || installation.getOsVersion() == null;
    }

    public void patchMyInstallation(@NonNull Installation installation, MobileMessaging.ResultListener<Installation> actionListener) {
        this.patch(installation, actionListener, true);
    }

    public void patch(final @NonNull Installation installation, final MobileMessaging.ResultListener<Installation> actionListener, final boolean myInstallation) {
        SystemData systemDataForReport = this.mobileMessagingCore.systemDataForReport(false);
        if (systemDataForReport != null) {
            this.mobileMessagingCore.populateInstallationWithSystemData(systemDataForReport, installation);
        }
        if (!installation.hasDataToReport()) {
            MobileMessagingLogger.w("Attempt to save empty installation data, will do nothing");
            if (actionListener != null) {
                actionListener.onResult(new Result(InternalSdkError.ERROR_SAVING_EMPTY_OBJECT.getError()));
            }
            return;
        }
        String pushRegId = this.mobileMessagingCore.getPushRegistrationId();
        if (!myInstallation) {
            pushRegId = installation.getPushRegistrationId();
        }
        if (StringUtils.isBlank(pushRegId)) {
            if (myInstallation) {
                MobileMessagingLogger.w("Push registration ID is not available from the provided context, will patch installation data later");
            } else {
                MobileMessagingLogger.w("Push registration ID is not provided, unable to patch installation data");
            }
            if (actionListener != null) {
                actionListener.onResult(new Result<Installation, MobileMessagingError>(this.mobileMessagingCore.getInstallation(true), InternalSdkError.NO_VALID_REGISTRATION.getError()));
            }
            return;
        }
        final String pushRegIdToUpdate = pushRegId;
        final Map installationMap = installation.getMap();
        new MRetryableTask<Void, Void>(){

            public Void run(Void[] voids) {
                MobileMessagingLogger.v("UPDATE INSTALLATION >>>");
                InstallationSynchronizer.this.mobileApiAppInstance.patchInstance(pushRegIdToUpdate, installationMap);
                return null;
            }

            @Override
            public void after(Void aVoid) {
                MobileMessagingLogger.v("UPDATE INSTALLATION DONE <<<");
                InstallationSynchronizer.this.updateInstallationReported(installation, myInstallation);
                Installation installationToReturn = installation;
                if (myInstallation) {
                    installationToReturn = InstallationSynchronizer.this.mobileMessagingCore.getInstallation(true);
                }
                InstallationSynchronizer.this.broadcaster.installationUpdated(installationToReturn);
                if (actionListener != null) {
                    actionListener.onResult(new Result(installationToReturn));
                }
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.v("UPDATE INSTALLATION ERROR <<<", error);
                MobileMessagingError mobileMessagingError = MobileMessagingError.createFrom(error);
                if (error instanceof BackendInvalidParameterException) {
                    InstallationSynchronizer.this.mobileMessagingCore.handleNoRegistrationError(mobileMessagingError);
                }
                InstallationSynchronizer.this.setCloudTokenReported(false);
                InstallationSynchronizer.this.mobileMessagingCore.setLastHttpException(error);
                InstallationSynchronizer.this.stats.reportError(MobileMessagingStatsError.REGISTRATION_SYNC_ERROR);
                InstallationSynchronizer.this.broadcaster.error(mobileMessagingError);
                if (actionListener != null) {
                    actionListener.onResult(new Result<Installation, MobileMessagingError>(InstallationSynchronizer.this.mobileMessagingCore.getInstallation(true), mobileMessagingError));
                }
            }
        }.retryWith(this.retryPolicyProvider.DEFAULT()).execute(this.executor, (IN[])new Void[0]);
    }

    private void updateInstallationReported(Installation installation, boolean myDevice) {
        PreferenceHelper.remove(this.context, MobileMessagingProperty.IS_PRIMARY_UNREPORTED);
        if (!myDevice) {
            this.mobileMessagingCore.savePrimarySetting(false);
            return;
        }
        if (installation.isPrimaryDevice() != null) {
            this.mobileMessagingCore.savePrimarySetting(installation.isPrimaryDevice());
        }
        if (installation.isPushRegistrationEnabled() != null) {
            this.mobileMessagingCore.setPushRegistrationEnabled(installation.isPushRegistrationEnabled());
            this.mobileMessagingCore.setPushRegistrationEnabledReported(true);
        }
        this.setCloudTokenReported(true);
        this.mobileMessagingCore.setApplicationUserIdReported(true);
        Map<String, CustomAttributeValue> customAttsMap = this.mobileMessagingCore.getMergedUnreportedAndReportedCustomAtts();
        this.mobileMessagingCore.setUnreportedCustomAttributes(null);
        this.mobileMessagingCore.saveCustomAttributes(customAttsMap);
        this.mobileMessagingCore.setSystemDataReported();
        this.mobileMessagingCore.setReportedPushServiceType();
    }

    public void fetchInstance(final MobileMessaging.ResultListener<Installation> listener) {
        if (!this.mobileMessagingCore.isRegistrationAvailable()) {
            MobileMessagingLogger.w("Registration not available yet, you can fetch installation when push registration ID becomes available");
            if (listener != null) {
                listener.onResult(new Result<Installation, MobileMessagingError>(this.mobileMessagingCore.getInstallation(), InternalSdkError.NO_VALID_REGISTRATION.getError()));
            }
            return;
        }
        new MRetryableTask<Void, AppInstance>(){

            public AppInstance run(Void[] voids) {
                MobileMessagingLogger.v("GET INSTALLATION >>>");
                return InstallationSynchronizer.this.mobileApiAppInstance.getInstance(InstallationSynchronizer.this.mobileMessagingCore.getPushRegistrationId());
            }

            @Override
            public void after(AppInstance instance) {
                Installation installation = InstallationMapper.fromBackend(instance);
                if (installation.isPrimaryDevice() != null) {
                    InstallationSynchronizer.this.mobileMessagingCore.savePrimarySetting(installation.isPrimaryDevice());
                }
                if (installation.isPushRegistrationEnabled() != null) {
                    InstallationSynchronizer.this.mobileMessagingCore.setPushRegistrationEnabled(installation.isPushRegistrationEnabled());
                }
                InstallationSynchronizer.this.mobileMessagingCore.saveCustomAttributes(installation.getCustomAttributes());
                if (listener != null) {
                    listener.onResult(new Result(installation));
                }
                InstallationSynchronizer.this.mobileMessagingCore.setShouldRepersonalize(false);
                MobileMessagingLogger.v("GET INSTALLATION DONE <<<");
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingError mobileMessagingError = MobileMessagingError.createFrom(error);
                if (error instanceof BackendInvalidParameterException) {
                    InstallationSynchronizer.this.mobileMessagingCore.handleNoRegistrationError(mobileMessagingError);
                }
                if (listener != null) {
                    listener.onResult(new Result<Installation, MobileMessagingError>(InstallationSynchronizer.this.mobileMessagingCore.getInstallation(true), mobileMessagingError));
                }
                MobileMessagingLogger.v("GET INSTALLATION ERROR <<<", error);
            }
        }.retryWith(this.retryPolicyProvider.DEFAULT()).execute(this.executor, (IN[])new Void[0]);
    }

    private boolean isCloudTokenPresentAndUnreported() {
        return !this.isCloudTokenReported() && StringUtils.isNotBlank(this.mobileMessagingCore.getCloudToken());
    }

    private void setPushRegistrationId(String registrationId) {
        if (registrationId != null) {
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID, registrationId);
        }
    }

    public void setCloudTokenReported(boolean reported) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.CLOUD_TOKEN_REPORTED, reported);
    }

    public boolean isCloudTokenReported() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.CLOUD_TOKEN_REPORTED);
    }

    private PushInstallation from(SystemData data) {
        PushInstallation installation = new PushInstallation();
        return (PushInstallation)this.mobileMessagingCore.populateInstallationWithSystemData(data, installation);
    }

    private static class PushInstallation
    extends Installation {
        private PushInstallation() {
        }

        void setServiceType() {
            super.setPushServiceType();
        }

        void setToken(String token) {
            super.setPushServiceToken(token);
        }
    }
}

