/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobileapi.messages;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.messages.MobileApiMessages;
import org.infobip.mobile.messaging.api.messages.SyncMessagesBody;
import org.infobip.mobile.messaging.api.messages.SyncMessagesResponse;
import org.infobip.mobile.messaging.cloud.MobileMessageHandler;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobileapi.MobileMessagingError;
import org.infobip.mobile.messaging.mobileapi.common.MRetryPolicy;
import org.infobip.mobile.messaging.mobileapi.common.MRetryableTask;
import org.infobip.mobile.messaging.mobileapi.messages.MessagesMapper;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.util.StringUtils;

public class MessagesSynchronizer {
    private static final long SYNC_MSGS_THROTTLE_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private final MobileMessagingCore mobileMessagingCore;
    private final MobileMessagingStats stats;
    private final Executor executor;
    private final Broadcaster broadcaster;
    private final MobileMessageHandler mobileMessageHandler;
    private final MRetryPolicy retryPolicy;
    private final MobileApiMessages mobileApiMessages;
    private volatile Long lastSyncTimeMillis;

    public MessagesSynchronizer(MobileMessagingCore mobileMessagingCore, MobileMessagingStats stats, Executor executor, Broadcaster broadcaster, MRetryPolicy retryPolicy, MobileMessageHandler mobileMessageHandler, MobileApiMessages mobileApiMessages) {
        this.mobileMessagingCore = mobileMessagingCore;
        this.stats = stats;
        this.executor = executor;
        this.broadcaster = broadcaster;
        this.retryPolicy = retryPolicy;
        this.mobileApiMessages = mobileApiMessages;
        this.mobileMessageHandler = mobileMessageHandler;
    }

    public void sync() {
        if (StringUtils.isBlank(this.mobileMessagingCore.getPushRegistrationId())) {
            MobileMessagingLogger.w("Registration not available yet, will patch messages later");
            return;
        }
        if (this.lastSyncTimeMillis != null && Time.now() - this.lastSyncTimeMillis < SYNC_MSGS_THROTTLE_INTERVAL_MILLIS || !this.mobileMessagingCore.isPushRegistrationEnabled()) {
            return;
        }
        this.lastSyncTimeMillis = Time.now();
        final String[] unreportedMessageIds = this.mobileMessagingCore.getAndRemoveUnreportedMessageIds();
        new MRetryableTask<Void, List<Message>>(){

            public List<Message> run(Void[] objects) {
                String[] messageIds = MessagesSynchronizer.this.mobileMessagingCore.getSyncMessagesIds();
                SyncMessagesBody syncMessagesBody = SyncMessagesBody.make((String[])messageIds, (String[])unreportedMessageIds);
                MobileMessagingLogger.v("SYNC MESSAGES >>>", syncMessagesBody);
                SyncMessagesResponse syncMessagesResponse = MessagesSynchronizer.this.mobileApiMessages.sync(syncMessagesBody);
                MobileMessagingLogger.v("SYNC MESSAGES DONE <<<", syncMessagesResponse);
                return MessagesMapper.mapResponseToMessages(syncMessagesResponse.getPayloads());
            }

            @Override
            public void after(List<Message> messages) {
                MessagesSynchronizer.this.broadcaster.deliveryReported(unreportedMessageIds);
                if (messages == null || messages.isEmpty()) {
                    return;
                }
                for (Message message : messages) {
                    MessagesSynchronizer.this.mobileMessageHandler.handleMessage(message);
                }
            }

            @Override
            public void error(Throwable error) {
                MessagesSynchronizer.this.mobileMessagingCore.addUnreportedMessageIds(unreportedMessageIds);
                MessagesSynchronizer.this.mobileMessagingCore.setLastHttpException(error);
                MobileMessagingLogger.e("MobileMessaging API returned error (synchronizing messages)! ", error);
                MessagesSynchronizer.this.stats.reportError(MobileMessagingStatsError.SYNC_MESSAGES_ERROR);
                MessagesSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(error));
            }
        }.retryWith(this.retryPolicy).execute(this.executor, (IN[])new Void[0]);
    }
}

