/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.notification;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MessageHandlerModule;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.app.ActivityStarterWrapper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.platform.AndroidBroadcaster;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.util.StringUtils;

public class NotificationTapReceiver
extends BroadcastReceiver {
    private Broadcaster broadcaster;
    private MobileMessagingCore mobileMessagingCore;
    private ActivityStarterWrapper activityStarterWrapper;

    public NotificationTapReceiver() {
    }

    @VisibleForTesting
    public NotificationTapReceiver(Broadcaster broadcaster, MobileMessagingCore mobileMessagingCore, ActivityStarterWrapper activityStarterWrapper) {
        this.broadcaster = broadcaster;
        this.mobileMessagingCore = mobileMessagingCore;
        this.activityStarterWrapper = activityStarterWrapper;
    }

    public void onReceive(Context context, Intent intent) {
        Bundle messageBundle = intent.getBundleExtra("org.infobip.mobile.messaging.message");
        Message message = Message.createFrom(messageBundle);
        if (message == null) {
            MobileMessagingLogger.e("Received no message in NotificationTapReceiver");
            return;
        }
        for (MessageHandlerModule module : this.mobileMessagingCore(context).getMessageHandlerModules()) {
            if (!module.messageTapped(message)) continue;
            return;
        }
        this.broadcaster(context).notificationTapped(message);
        NotificationSettings notificationSettings = this.mobileMessagingCore(context).getNotificationSettings();
        if (notificationSettings == null) {
            return;
        }
        if (notificationSettings.markSeenOnTap()) {
            this.mobileMessagingCore(context).setMessagesSeen(message.getMessageId());
        }
        Intent callbackIntent = new Intent(intent);
        callbackIntent.setAction(Event.NOTIFICATION_TAPPED.getKey());
        if (StringUtils.isNotBlank(message.getWebViewUrl())) {
            this.activityStarterWrapper(context).startWebViewActivity(callbackIntent, message.getWebViewUrl());
        } else {
            this.activityStarterWrapper(context).startCallbackActivity(callbackIntent);
        }
    }

    private Broadcaster broadcaster(Context context) {
        if (this.broadcaster == null) {
            this.broadcaster = new AndroidBroadcaster(context);
        }
        return this.broadcaster;
    }

    private MobileMessagingCore mobileMessagingCore(Context context) {
        if (this.mobileMessagingCore == null) {
            this.mobileMessagingCore = MobileMessagingCore.getInstance(context);
        }
        return this.mobileMessagingCore;
    }

    private ActivityStarterWrapper activityStarterWrapper(Context context) {
        if (this.activityStarterWrapper == null) {
            this.activityStarterWrapper = new ActivityStarterWrapper(context, this.mobileMessagingCore(context));
        }
        return this.activityStarterWrapper;
    }
}

