/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.platform;

import android.support.annotation.NonNull;
import java.lang.reflect.Constructor;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

public class Lazy<T, P> {
    private final Initializer<T, P> initializer;
    private final Object lock = new Object();
    private volatile T value = null;

    private Lazy(Initializer<T, P> initializer) {
        this.initializer = initializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public final T get(P param) {
        if (this.value == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.value == null) {
                    this.value = this.initializer.initialize(param);
                }
            }
        }
        return this.value;
    }

    public static <T, P> Lazy<T, P> fromSingleArgConstructor(Class<T> cls, Class<P> argCls) {
        Constructor<T> constructor;
        try {
            constructor = cls.getDeclaredConstructor(argCls);
            constructor.setAccessible(true);
        }
        catch (Exception e) {
            MobileMessagingLogger.e("Class " + cls.getName() + " does not have appropriate constructor that accepts " + argCls.getName(), e);
            throw new RuntimeException(e);
        }
        return new Lazy<T, P>(new Initializer<T, P>(){

            @Override
            public T initialize(P param) {
                try {
                    return constructor.newInstance(param);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static <T, P> Lazy<T, P> create(Initializer<T, P> initializer) {
        return new Lazy<T, P>(initializer);
    }

    public static <T, P> Lazy<T, P> just(final T value) {
        return new Lazy<T, P>(new Initializer<T, P>(){

            @Override
            public T initialize(P param) {
                return value;
            }
        });
    }

    public static interface Initializer<T, P> {
        public T initialize(P var1);
    }
}

